/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.FilteringCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringCollectionValueModelTests
extends TestCase {
    private SimpleCollectionValueModel<String> collectionHolder;
    CollectionAddEvent addEvent;
    CollectionRemoveEvent removeEvent;
    CollectionClearEvent collectionClearedEvent;
    CollectionChangeEvent collectionChangedEvent;
    private CollectionValueModel<String> filteredCollectionHolder;
    CollectionAddEvent filteredAddEvent;
    CollectionRemoveEvent filteredRemoveEvent;
    CollectionClearEvent filteredCollectionClearedEvent;
    CollectionChangeEvent filteredCollectionChangedEvent;

    public FilteringCollectionValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.collectionHolder = new SimpleCollectionValueModel(this.buildCollection());
        this.filteredCollectionHolder = new FilteringCollectionValueModel(this.collectionHolder, this.buildFilter());
    }

    private Collection<String> buildCollection() {
        Vector<String> collection = new Vector<String>();
        collection.add("foo");
        return collection;
    }

    private Predicate<String> buildFilter() {
        return new StringStartsWithB();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.filteredCollectionHolder.addCollectionChangeListener("values", this.buildFilteredListener());
        FilteringCollectionValueModelTests.assertEquals((String)"foo", (String)((String)this.collectionHolder.iterator().next()));
        FilteringCollectionValueModelTests.assertFalse((boolean)this.filteredCollectionHolder.iterator().hasNext());
        this.collectionHolder.add((Object)"bar");
        Iterator collectionHolderValue = this.collectionHolder.iterator();
        FilteringCollectionValueModelTests.assertEquals((String)"foo", (String)((String)collectionHolderValue.next()));
        FilteringCollectionValueModelTests.assertEquals((String)"bar", (String)((String)collectionHolderValue.next()));
        FilteringCollectionValueModelTests.assertTrue((boolean)this.filteredCollectionHolder.iterator().hasNext());
        FilteringCollectionValueModelTests.assertEquals((String)"bar", (String)((String)this.filteredCollectionHolder.iterator().next()));
        this.collectionHolder.remove((Object)"bar");
        FilteringCollectionValueModelTests.assertEquals((String)"foo", (String)((String)this.collectionHolder.iterator().next()));
        FilteringCollectionValueModelTests.assertFalse((boolean)this.filteredCollectionHolder.iterator().hasNext());
        this.collectionHolder.remove((Object)"foo");
        FilteringCollectionValueModelTests.assertFalse((boolean)this.collectionHolder.iterator().hasNext());
        FilteringCollectionValueModelTests.assertFalse((boolean)this.filteredCollectionHolder.iterator().hasNext());
        this.collectionHolder.add((Object)"foo");
        FilteringCollectionValueModelTests.assertEquals((String)"foo", (String)((String)this.collectionHolder.iterator().next()));
        FilteringCollectionValueModelTests.assertFalse((boolean)this.filteredCollectionHolder.iterator().hasNext());
    }

    public void testSetValue() {
        this.filteredCollectionHolder.addCollectionChangeListener("values", this.buildFilteredListener());
        Vector<String> newCollection = new Vector<String>();
        newCollection.add("fox");
        newCollection.add("baz");
        this.collectionHolder.setValues(newCollection);
        Iterator collectionValues = this.collectionHolder.iterator();
        FilteringCollectionValueModelTests.assertEquals((String)"fox", (String)((String)collectionValues.next()));
        FilteringCollectionValueModelTests.assertEquals((String)"baz", (String)((String)collectionValues.next()));
        Iterator filteredCollectionValues = this.filteredCollectionHolder.iterator();
        FilteringCollectionValueModelTests.assertEquals((String)"baz", (String)((String)filteredCollectionValues.next()));
        FilteringCollectionValueModelTests.assertFalse((boolean)filteredCollectionValues.hasNext());
    }

    public void testLazyListening() {
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
        ChangeListener listener = this.buildFilteredChangeListener();
        this.filteredCollectionHolder.addChangeListener(listener);
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasAnyCollectionChangeListeners("values"));
        this.filteredCollectionHolder.removeChangeListener(listener);
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
        this.filteredCollectionHolder.addCollectionChangeListener("values", (CollectionChangeListener)listener);
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasAnyCollectionChangeListeners("values"));
        this.filteredCollectionHolder.removeCollectionChangeListener("values", (CollectionChangeListener)listener);
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
    }

    public void testCollectionChange1() {
        this.collectionHolder.addChangeListener(this.buildChangeListener());
        this.filteredCollectionHolder.addChangeListener(this.buildFilteredChangeListener());
        this.verifyCollectionChanges();
    }

    public void testCollectionChange2() {
        this.collectionHolder.addCollectionChangeListener("values", this.buildListener());
        this.filteredCollectionHolder.addCollectionChangeListener("values", this.buildFilteredListener());
        this.verifyCollectionChanges();
    }

    private void clearEvents() {
        this.addEvent = null;
        this.removeEvent = null;
        this.collectionClearedEvent = null;
        this.collectionChangedEvent = null;
        this.filteredAddEvent = null;
        this.filteredRemoveEvent = null;
        this.filteredCollectionClearedEvent = null;
        this.filteredCollectionChangedEvent = null;
    }

    private void verifyCollectionChanges() {
        this.clearEvents();
        this.collectionHolder.add((Object)"bar");
        Vector<String> tempCollection = new Vector<String>();
        tempCollection.add("bar");
        this.verifyEvent(this.addEvent, this.collectionHolder, tempCollection);
        this.verifyEvent(this.filteredAddEvent, this.filteredCollectionHolder, tempCollection);
        this.clearEvents();
        this.collectionHolder.remove((Object)"foo");
        tempCollection.remove("bar");
        tempCollection.add("foo");
        this.verifyEvent(this.removeEvent, this.collectionHolder, tempCollection);
        FilteringCollectionValueModelTests.assertNull((Object)this.filteredRemoveEvent);
        this.clearEvents();
        this.collectionHolder.remove((Object)"bar");
        tempCollection.add("bar");
        tempCollection.remove("foo");
        this.verifyEvent(this.removeEvent, this.collectionHolder, tempCollection);
        this.verifyEvent(this.filteredRemoveEvent, this.filteredCollectionHolder, tempCollection);
        this.clearEvents();
        this.collectionHolder.add((Object)"foo");
        tempCollection.remove("bar");
        tempCollection.add("foo");
        this.verifyEvent(this.addEvent, this.collectionHolder, tempCollection);
        FilteringCollectionValueModelTests.assertNull((Object)this.filteredAddEvent);
        this.clearEvents();
        Vector<String> newCollection = new Vector<String>();
        newCollection.add("fox");
        newCollection.add("baz");
        this.collectionHolder.setValues(newCollection);
        this.verifyEvent(this.collectionChangedEvent, this.collectionHolder);
        tempCollection.remove("foo");
        tempCollection.add("baz");
        this.verifyEvent(this.filteredCollectionChangedEvent, this.filteredCollectionHolder);
    }

    private CollectionChangeListener buildListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent e) {
                FilteringCollectionValueModelTests.this.addEvent = e;
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                FilteringCollectionValueModelTests.this.removeEvent = e;
            }

            public void collectionCleared(CollectionClearEvent e) {
                FilteringCollectionValueModelTests.this.collectionClearedEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.collectionChangedEvent = e;
            }
        };
    }

    private ChangeListener buildChangeListener() {
        return new ChangeAdapter(){

            public void itemsAdded(CollectionAddEvent e) {
                FilteringCollectionValueModelTests.this.addEvent = e;
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                FilteringCollectionValueModelTests.this.removeEvent = e;
            }

            public void collectionCleared(CollectionClearEvent e) {
                FilteringCollectionValueModelTests.this.collectionClearedEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.collectionChangedEvent = e;
            }
        };
    }

    private CollectionChangeListener buildFilteredListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent e) {
                FilteringCollectionValueModelTests.this.filteredAddEvent = e;
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                FilteringCollectionValueModelTests.this.filteredRemoveEvent = e;
            }

            public void collectionCleared(CollectionClearEvent e) {
                FilteringCollectionValueModelTests.this.filteredCollectionClearedEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.filteredCollectionChangedEvent = e;
            }
        };
    }

    private ChangeListener buildFilteredChangeListener() {
        return new ChangeAdapter(){

            public void itemsAdded(CollectionAddEvent e) {
                FilteringCollectionValueModelTests.this.filteredAddEvent = e;
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                FilteringCollectionValueModelTests.this.filteredRemoveEvent = e;
            }

            public void collectionCleared(CollectionClearEvent e) {
                FilteringCollectionValueModelTests.this.filteredCollectionClearedEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.filteredCollectionChangedEvent = e;
            }
        };
    }

    private void verifyEvent(CollectionChangeEvent event, Object source) {
        FilteringCollectionValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        FilteringCollectionValueModelTests.assertEquals((String)"values", (String)event.getCollectionName());
    }

    private void verifyEvent(CollectionAddEvent event, Object source, Object items) {
        FilteringCollectionValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        FilteringCollectionValueModelTests.assertEquals((String)"values", (String)event.getCollectionName());
        FilteringCollectionValueModelTests.assertEquals((Object)items, (Object)CollectionTools.vector((Iterable)event.getItems()));
    }

    private void verifyEvent(CollectionRemoveEvent event, Object source, Object items) {
        FilteringCollectionValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        FilteringCollectionValueModelTests.assertEquals((String)"values", (String)event.getCollectionName());
        FilteringCollectionValueModelTests.assertEquals((Object)items, (Object)CollectionTools.vector((Iterable)event.getItems()));
    }

    public void testRemoveFilteredItem() {
        SimpleCollectionValueModel tiHolder = new SimpleCollectionValueModel(this.buildCollection2());
        FilteringCollectionValueModel filteredTIHolder = new FilteringCollectionValueModel((CollectionValueModel)tiHolder, this.buildFilter2());
        filteredTIHolder.addCollectionChangeListener("values", this.buildFilteredListener());
        FilteringCollectionValueModelTests.assertEquals((int)0, (int)filteredTIHolder.size());
        tiHolder.add((Object)new TestItem("bar"));
        FilteringCollectionValueModelTests.assertEquals((int)1, (int)filteredTIHolder.size());
        TestItem baz = new TestItem("baz");
        tiHolder.add((Object)baz);
        FilteringCollectionValueModelTests.assertEquals((int)2, (int)filteredTIHolder.size());
        baz.name = "jaz";
        tiHolder.remove((Object)baz);
        FilteringCollectionValueModelTests.assertEquals((int)1, (int)filteredTIHolder.size());
    }

    private Collection<TestItem> buildCollection2() {
        Vector<TestItem> collection = new Vector<TestItem>();
        collection.add(new TestItem("foo"));
        return collection;
    }

    private Predicate<TestItem> buildFilter2() {
        return new NameStartsWithB();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NameStartsWithB
    extends PredicateAdapter<TestItem> {
        NameStartsWithB() {
        }

        public boolean evaluate(TestItem ti) {
            return ti.name.startsWith("b");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StringStartsWithB
    extends PredicateAdapter<String> {
        StringStartsWithB() {
        }

        public boolean evaluate(String s) {
            return s.startsWith("b");
        }
    }

    private class TestItem {
        String name;

        TestItem(String name) {
            this.name = name;
        }
    }
}

