/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAspectAdapterTests
extends TestCase {
    private TestSubject subject1;
    private ModifiablePropertyValueModel<TestSubject> subjectHolder1;
    private LocalListAspectAdapter aa1;
    private ListEvent event1;
    private ListChangeListener listener1;
    private TestSubject subject2;

    public ListAspectAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.subject1 = new TestSubject();
        this.subject1.addNames(this.subject1Names());
        this.subject1.addDescriptions(this.subject1Descriptions());
        this.subjectHolder1 = new SimplePropertyValueModel((Object)this.subject1);
        this.aa1 = this.buildAspectAdapter((PropertyValueModel<TestSubject>)this.subjectHolder1);
        this.listener1 = this.buildValueChangeListener1();
        this.aa1.addListChangeListener("list values", this.listener1);
        this.event1 = null;
        this.subject2 = new TestSubject();
        this.subject2.addNames(this.subject2Names());
        this.subject2.addDescriptions(this.subject2Descriptions());
    }

    private List<String> subject1Names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("foo");
        result.add("bar");
        result.add("baz");
        result.add("bam");
        return result;
    }

    private List<String> subject1Descriptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("this.subject1 description1");
        result.add("this.subject1 description2");
        return result;
    }

    private List<String> subject2Names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("joo");
        result.add("jar");
        result.add("jaz");
        result.add("jam");
        return result;
    }

    private List<String> subject2Descriptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("this.subject2 description1");
        result.add("this.subject2 description2");
        return result;
    }

    private LocalListAspectAdapter buildAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
        return new LocalListAspectAdapter(subjectHolder);
    }

    private ListChangeListener buildValueChangeListener1() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
                ListAspectAdapterTests.this.value1Changed((ListEvent)e);
            }

            public void itemsRemoved(ListRemoveEvent e) {
                ListAspectAdapterTests.this.value1Changed((ListEvent)e);
            }

            public void itemsReplaced(ListReplaceEvent e) {
                ListAspectAdapterTests.this.value1Changed((ListEvent)e);
            }

            public void itemsMoved(ListMoveEvent e) {
                ListAspectAdapterTests.this.value1Changed((ListEvent)e);
            }

            public void listCleared(ListClearEvent e) {
                ListAspectAdapterTests.this.value1Changed((ListEvent)e);
            }

            public void listChanged(ListChangeEvent e) {
                ListAspectAdapterTests.this.value1Changed((ListEvent)e);
            }
        };
    }

    void value1Changed(ListEvent e) {
        this.event1 = e;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSubjectHolder() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        this.subjectHolder1.setValue((Object)this.subject2);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals(this.subject2Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        this.event1 = null;
        this.subjectHolder1.setValue(null);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertFalse((boolean)this.aa1.iterator().hasNext());
        this.event1 = null;
        this.subjectHolder1.setValue((Object)this.subject1);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testAdd() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.addName("jam");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)this.subject1Names().size(), (int)((ListAddEvent)this.event1).getIndex());
        ListAspectAdapterTests.assertEquals((Object)"jam", ((ListAddEvent)this.event1).getItems().iterator().next());
        List<String> namesPlus = this.subject1Names();
        namesPlus.add("jam");
        ListAspectAdapterTests.assertEquals(namesPlus, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        this.event1 = null;
        this.aa1.add(2, "jaz");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)2, (int)((ListAddEvent)this.event1).getIndex());
        ListAspectAdapterTests.assertEquals((Object)"jaz", ((ListAddEvent)this.event1).getItems().iterator().next());
        namesPlus.add(2, "jaz");
        ListAspectAdapterTests.assertEquals(namesPlus, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testDefaultAdd() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        ArrayList<String> items = new ArrayList<String>();
        items.add("joo");
        items.add("jar");
        items.add("jaz");
        items.add("jam");
        this.event1 = null;
        this.aa1.addAll(2, items);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)5, (int)((ListAddEvent)this.event1).getIndex());
        ListAspectAdapterTests.assertEquals((Object)"jam", ((ListAddEvent)this.event1).getItems().iterator().next());
        List<String> namesPlus = this.subject1Names();
        namesPlus.addAll(2, items);
        ListAspectAdapterTests.assertEquals(namesPlus, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testRemove() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        String removedName = this.subject1.removeName(0);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)0, (int)((ListRemoveEvent)this.event1).getIndex());
        ListAspectAdapterTests.assertEquals((Object)removedName, ((ListRemoveEvent)this.event1).getItems().iterator().next());
        List<String> namesMinus = this.subject1Names();
        namesMinus.remove(0);
        ListAspectAdapterTests.assertEquals(namesMinus, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        this.event1 = null;
        String removedItem = this.aa1.remove(0);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)0, (int)((ListRemoveEvent)this.event1).getIndex());
        ListAspectAdapterTests.assertEquals((Object)removedItem, ((ListRemoveEvent)this.event1).getItems().iterator().next());
        namesMinus.remove(0);
        ListAspectAdapterTests.assertEquals(namesMinus, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testDefaultLength() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        ArrayList<String> items = new ArrayList<String>();
        items.add("bar");
        items.add("baz");
        this.event1 = null;
        this.aa1.remove(1, 2);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)1, (int)((ListRemoveEvent)this.event1).getIndex());
        ListAspectAdapterTests.assertEquals((Object)"baz", ((ListRemoveEvent)this.event1).getItems().iterator().next());
        List<String> namesPlus = this.subject1Names();
        namesPlus.remove(1);
        namesPlus.remove(1);
        ListAspectAdapterTests.assertEquals(namesPlus, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testReplace() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        String replacedName = this.subject1.setName(0, "jelly");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)0, (int)((ListReplaceEvent)this.event1).getIndex());
        ListAspectAdapterTests.assertEquals((Object)"jelly", ((ListReplaceEvent)this.event1).getNewItems().iterator().next());
        ListAspectAdapterTests.assertEquals((Object)replacedName, ((ListReplaceEvent)this.event1).getOldItems().iterator().next());
        List<String> namesChanged = this.subject1Names();
        namesChanged.set(0, "jelly");
        ListAspectAdapterTests.assertEquals(namesChanged, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        this.event1 = null;
        replacedName = this.subject1.setName(1, "roll");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)1, (int)((ListReplaceEvent)this.event1).getIndex());
        ListAspectAdapterTests.assertEquals((Object)"roll", ((ListReplaceEvent)this.event1).getNewItems().iterator().next());
        ListAspectAdapterTests.assertEquals((Object)replacedName, ((ListReplaceEvent)this.event1).getOldItems().iterator().next());
        namesChanged = this.subject1Names();
        namesChanged.set(0, "jelly");
        namesChanged.set(1, "roll");
        ListAspectAdapterTests.assertEquals(namesChanged, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testListChange() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.addTwoNames("jam", "jaz");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        List<String> namesPlus2 = this.subject1Names();
        namesPlus2.add(0, "jaz");
        namesPlus2.add(0, "jam");
        ListAspectAdapterTests.assertEquals(namesPlus2, (Object)ListTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testIterator() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list(this.subject1.names()));
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)ListTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testGet() {
        ListAspectAdapterTests.assertEquals((String)this.subject1Names().get(0), (String)this.subject1.getName(0));
        ListAspectAdapterTests.assertEquals((String)this.subject1Names().get(0), (String)((String)this.aa1.get(0)));
    }

    public void testSize() {
        ListAspectAdapterTests.assertEquals((int)this.subject1Names().size(), (int)IteratorTools.size(this.subject1.names()));
        ListAspectAdapterTests.assertEquals((int)this.subject1Names().size(), (int)IteratorTools.size((Iterator)this.aa1.listIterator()));
    }

    public void testHasListeners() {
        ListAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyListChangeListeners("list values"));
        ListAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyListChangeListeners("names"));
        this.aa1.removeListChangeListener("list values", this.listener1);
        ListAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyListChangeListeners("names"));
        ListAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyListChangeListeners("list values"));
        ChangeAdapter listener2 = new ChangeAdapter();
        this.aa1.addChangeListener((ChangeListener)listener2);
        ListAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyListChangeListeners("list values"));
        ListAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyListChangeListeners("names"));
        this.aa1.removeChangeListener((ChangeListener)listener2);
        ListAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyListChangeListeners("names"));
        ListAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyListChangeListeners("list values"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LocalListAspectAdapter
    extends ListAspectAdapter<TestSubject, String> {
        LocalListAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
            super(subjectHolder, new String[]{"names"});
        }

        protected ListIterator<String> listIterator_() {
            if (this.aspectNames[0] == "names") {
                return ((TestSubject)((Object)this.subject)).names();
            }
            if (this.aspectNames[0] == "descriptions") {
                return ((TestSubject)((Object)this.subject)).descriptions();
            }
            throw new IllegalStateException("invalid aspect name: " + this.aspectNames[0]);
        }

        public void add(int index, Object item) {
            if (this.aspectNames[0] == "names") {
                ((TestSubject)((Object)this.subject)).addName(index, (String)item);
            } else if (this.aspectNames[0] == "descriptions") {
                ((TestSubject)((Object)this.subject)).addDescription(index, (String)item);
            } else {
                throw new IllegalStateException("invalid aspect name: " + this.aspectNames[0]);
            }
        }

        public void addAll(int index, List<String> items) {
            int i = 0;
            while (i < items.size()) {
                this.add(index + i, items.get(i));
                ++i;
            }
        }

        public String remove(int index) {
            if (this.aspectNames[0] == "names") {
                return ((TestSubject)((Object)this.subject)).removeName(index);
            }
            if (this.aspectNames[0] == "descriptions") {
                return ((TestSubject)((Object)this.subject)).removeDescription(index);
            }
            throw new IllegalStateException("invalid aspect name: " + this.aspectNames[0]);
        }

        public List<String> remove(int index, int length) {
            ArrayList<String> removedItems = new ArrayList<String>(length);
            int i = 0;
            while (i < length) {
                removedItems.add(this.remove(index));
                ++i;
            }
            return removedItems;
        }

        public Object replace(int index, Object item) {
            if (this.aspectNames[0] == "names") {
                return ((TestSubject)((Object)this.subject)).setName(index, (String)item);
            }
            if (this.aspectNames[0] == "descriptions") {
                return ((TestSubject)((Object)this.subject)).setDescription(index, (String)item);
            }
            throw new IllegalStateException("invalid aspect name: " + this.aspectNames[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestSubject
    extends AbstractModel {
        private List<String> names = new ArrayList<String>();
        public static final String NAMES_LIST = "names";
        private List<String> descriptions = new ArrayList<String>();
        public static final String DESCRIPTIONS_LIST = "descriptions";

        public ListIterator<String> names() {
            return IteratorTools.readOnly(this.names.listIterator());
        }

        public String getName(int index) {
            return this.names.get(index);
        }

        public void addName(int index, String name) {
            this.names.add(index, name);
            this.fireItemAdded(NAMES_LIST, index, name);
        }

        public void addName(String name) {
            this.addName(this.names.size(), name);
        }

        public void addNames(ListIterator<String> newNames) {
            while (newNames.hasNext()) {
                this.addName(newNames.next());
            }
        }

        public void addNames(List<String> newNames) {
            this.addNames(newNames.listIterator());
        }

        public void addTwoNames(String name1, String name2) {
            this.names.add(0, name2);
            this.names.add(0, name1);
            this.fireListChanged(NAMES_LIST, this.names);
        }

        public String removeName(int index) {
            String removedName = this.names.remove(index);
            this.fireItemRemoved(NAMES_LIST, index, removedName);
            return removedName;
        }

        public String setName(int index, String name) {
            String replacedName = this.names.set(index, name);
            this.fireItemReplaced(NAMES_LIST, index, name, replacedName);
            return replacedName;
        }

        public ListIterator<String> descriptions() {
            return IteratorTools.readOnly(this.descriptions.listIterator());
        }

        public String getDescription(int index) {
            return this.descriptions.get(index);
        }

        public void addDescription(int index, String description) {
            this.descriptions.add(index, description);
            this.fireItemAdded(DESCRIPTIONS_LIST, index, description);
        }

        public void addDescription(String description) {
            this.addDescription(this.descriptions.size(), description);
        }

        public void addDescriptions(ListIterator<String> newDescriptions) {
            while (newDescriptions.hasNext()) {
                this.addDescription(newDescriptions.next());
            }
        }

        public void addDescriptions(List<String> newDescriptions) {
            this.addDescriptions(newDescriptions.listIterator());
        }

        public String removeDescription(int index) {
            String removedDescription = this.descriptions.remove(index);
            this.fireItemRemoved(DESCRIPTIONS_LIST, index, removedDescription);
            return removedDescription;
        }

        public String setDescription(int index, String description) {
            String replacedDescription = this.descriptions.set(index, description);
            this.fireItemReplaced(DESCRIPTIONS_LIST, index, description, replacedDescription);
            return replacedDescription;
        }
    }
}

