/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TransformationPropertyValueModelTests
extends TestCase {
    private ModifiablePropertyValueModel<String> objectHolder;
    PropertyChangeEvent event;
    private ModifiablePropertyValueModel<String> transformationObjectHolder;
    PropertyChangeEvent transformationEvent;
    private static final Transformer<String, String> UPPER_CASE_TRANSFORMER = new UpperCaseTransformer();
    private static final Transformer<String, String> LOWER_CASE_TRANSFORMER = new LowerCaseTransformer();

    public TransformationPropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)"foo");
        this.transformationObjectHolder = new TransformationModifiablePropertyValueModel(this.objectHolder, UPPER_CASE_TRANSFORMER, LOWER_CASE_TRANSFORMER);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        TransformationPropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        TransformationPropertyValueModelTests.assertNull((Object)this.transformationObjectHolder.getValue());
        ChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addChangeListener(listener);
        TransformationPropertyValueModelTests.assertEquals((String)"FOO", (String)((String)this.transformationObjectHolder.getValue()));
        this.objectHolder.setValue((Object)"bar");
        TransformationPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        TransformationPropertyValueModelTests.assertEquals((String)"BAR", (String)((String)this.transformationObjectHolder.getValue()));
        this.objectHolder.setValue((Object)"baz");
        TransformationPropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.objectHolder.getValue()));
        TransformationPropertyValueModelTests.assertEquals((String)"BAZ", (String)((String)this.transformationObjectHolder.getValue()));
        this.objectHolder.setValue(null);
        TransformationPropertyValueModelTests.assertNull((Object)this.objectHolder.getValue());
        TransformationPropertyValueModelTests.assertNull((Object)this.transformationObjectHolder.getValue());
        this.objectHolder.setValue((Object)"foo");
        TransformationPropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        TransformationPropertyValueModelTests.assertEquals((String)"FOO", (String)((String)this.transformationObjectHolder.getValue()));
    }

    public void testSetValue() {
        this.transformationObjectHolder.setValue((Object)"BAR");
        TransformationPropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        TransformationPropertyValueModelTests.assertEquals((String)"BAR", (String)((String)this.transformationObjectHolder.getValue()));
        this.transformationObjectHolder.setValue((Object)"Foo");
        TransformationPropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        TransformationPropertyValueModelTests.assertEquals((String)"Foo", (String)((String)this.transformationObjectHolder.getValue()));
        ChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addChangeListener(listener);
        TransformationPropertyValueModelTests.assertEquals((String)"FOO", (String)((String)this.transformationObjectHolder.getValue()));
        this.transformationObjectHolder.removeChangeListener(listener);
        this.transformationObjectHolder.setValue(null);
        TransformationPropertyValueModelTests.assertNull((Object)this.objectHolder.getValue());
        TransformationPropertyValueModelTests.assertNull((Object)this.transformationObjectHolder.getValue());
        this.transformationObjectHolder.setValue((Object)"baz");
        TransformationPropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.objectHolder.getValue()));
        TransformationPropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.transformationObjectHolder.getValue()));
        this.transformationObjectHolder.addChangeListener(listener);
        TransformationPropertyValueModelTests.assertEquals((String)"BAZ", (String)((String)this.transformationObjectHolder.getValue()));
        this.transformationObjectHolder.removeChangeListener(listener);
    }

    public void testLazyListening() {
        TransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        ChangeListener listener = this.buildTransformationListener();
        this.transformationObjectHolder.addChangeListener(listener);
        TransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.transformationObjectHolder.removeChangeListener(listener);
        TransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        this.transformationObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        TransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.transformationObjectHolder.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        TransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.objectHolder.addChangeListener(this.buildListener());
        this.transformationObjectHolder.addChangeListener(this.buildTransformationListener());
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.transformationObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildTransformationListener());
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.event = null;
        this.transformationEvent = null;
        this.objectHolder.setValue((Object)"bar");
        this.verifyEvent(this.event, this.objectHolder, "foo", "bar");
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, "FOO", "BAR");
        this.event = null;
        this.transformationEvent = null;
        this.objectHolder.setValue((Object)"baz");
        this.verifyEvent(this.event, this.objectHolder, "bar", "baz");
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, "BAR", "BAZ");
        this.event = null;
        this.transformationEvent = null;
        this.objectHolder.setValue((Object)"Foo");
        this.verifyEvent(this.event, this.objectHolder, "baz", "Foo");
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, "BAZ", "FOO");
        this.event = null;
        this.transformationEvent = null;
        this.objectHolder.setValue((Object)"FOO");
        this.verifyEvent(this.event, this.objectHolder, "Foo", "FOO");
        TransformationPropertyValueModelTests.assertNull((Object)this.transformationEvent);
        this.event = null;
        this.transformationEvent = null;
        this.objectHolder.setValue(null);
        this.verifyEvent(this.event, this.objectHolder, "FOO", null);
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, "FOO", null);
        this.event = null;
        this.transformationEvent = null;
        this.objectHolder.setValue((Object)"bar");
        this.verifyEvent(this.event, this.objectHolder, null, "bar");
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, null, "BAR");
    }

    private ChangeListener buildListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                TransformationPropertyValueModelTests.this.event = e;
            }
        };
    }

    private ChangeListener buildTransformationListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                TransformationPropertyValueModelTests.this.transformationEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent e, Object source, Object oldValue, Object newValue) {
        TransformationPropertyValueModelTests.assertEquals((Object)source, (Object)e.getSource());
        TransformationPropertyValueModelTests.assertEquals((String)"value", (String)e.getPropertyName());
        TransformationPropertyValueModelTests.assertEquals((Object)oldValue, (Object)e.getOldValue());
        TransformationPropertyValueModelTests.assertEquals((Object)newValue, (Object)e.getNewValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LowerCaseTransformer
    extends AbstractTransformer<String, String> {
        LowerCaseTransformer() {
        }

        public String transform_(String s) {
            return s.toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UpperCaseTransformer
    extends AbstractTransformer<String, String> {
        UpperCaseTransformer() {
        }

        public String transform_(String s) {
            return s.toUpperCase();
        }
    }
}

