/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import java.io.Serializable;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.NOT;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NOTTests
extends TestCase {
    private NOT<Number> notPredicate;

    public NOTTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.notPredicate = new NOT(this.buildIsPositive());
    }

    private Predicate<Number> buildIsPositive() {
        return new IsPositive();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        NOTTests.assertTrue((boolean)this.notPredicate.evaluate((Object)new Integer(0)));
        NOTTests.assertTrue((boolean)this.notPredicate.evaluate((Object)new Integer(-1)));
        NOTTests.assertTrue((boolean)this.notPredicate.evaluate((Object)new Double(-0.001)));
        NOTTests.assertFalse((boolean)this.notPredicate.evaluate((Object)new Double(1.0)));
        NOTTests.assertFalse((boolean)this.notPredicate.evaluate((Object)new Double(11.0)));
        NOTTests.assertFalse((boolean)this.notPredicate.evaluate((Object)new Double(111.0)));
    }

    public void testEquals() {
        Predicate notPredicate2 = PredicateTools.not(this.buildIsPositive());
        NOTTests.assertEquals(this.notPredicate, (Object)notPredicate2);
        NOTTests.assertEquals((int)this.notPredicate.hashCode(), (int)notPredicate2.hashCode());
        NOTTests.assertFalse((boolean)this.notPredicate.equals((Object)IsNotNull.instance()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IsPositive
    extends PredicateAdapter<Number>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        IsPositive() {
        }

        public boolean evaluate(Number number) {
            return number.doubleValue() > 0.0;
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return 789;
        }
    }
}

