/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import java.io.Serializable;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TransformationPredicateTests
extends TestCase {
    private Predicate<Person> predicate;

    public TransformationPredicateTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.predicate = PredicateTools.wrap((Predicate)IsNotNull.instance(), Person.NAME_TRANSFORMER);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        TransformationPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)new Person("")));
        TransformationPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)new Person("Fred")));
        TransformationPredicateTests.assertFalse((boolean)this.predicate.evaluate((Object)new Person(null)));
    }

    public void testEquals() {
        Predicate predicate2 = PredicateTools.wrap((Predicate)IsNotNull.instance(), Person.NAME_TRANSFORMER);
        TransformationPredicateTests.assertEquals(this.predicate, (Object)predicate2);
        TransformationPredicateTests.assertEquals((int)this.predicate.hashCode(), (int)predicate2.hashCode());
        TransformationPredicateTests.assertFalse((boolean)this.predicate.equals((Object)IsNotNull.instance()));
    }

    static class Person {
        final String name;
        static final Transformer<Person, String> NAME_TRANSFORMER = new NameTransformer();

        Person(String name) {
            this.name = name;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class NameTransformer
        extends AbstractTransformer<Person, String>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            NameTransformer() {
            }

            protected String transform_(Person person) {
                return person.name;
            }

            public boolean equals(Object obj) {
                return obj.getClass() == this.getClass();
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }
        }
    }
}

