/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import java.io.Serializable;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TransformerPredicateTests
extends TestCase {
    private Transformer<Integer, Boolean> transformer;
    private Predicate<Integer> transformerPredicate;

    public TransformerPredicateTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.transformer = new LessThan42Transformer();
        this.transformerPredicate = PredicateTools.adapt(this.transformer);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        TransformerPredicateTests.assertTrue((boolean)this.transformerPredicate.evaluate((Object)new Integer(-42)));
        TransformerPredicateTests.assertFalse((boolean)this.transformerPredicate.evaluate((Object)new Integer(42)));
        TransformerPredicateTests.assertFalse((boolean)this.transformerPredicate.evaluate((Object)new Integer(4242)));
        TransformerPredicateTests.assertTrue((boolean)this.transformerPredicate.evaluate((Object)-42));
        TransformerPredicateTests.assertFalse((boolean)this.transformerPredicate.evaluate((Object)42));
        TransformerPredicateTests.assertFalse((boolean)this.transformerPredicate.evaluate((Object)4242));
        TransformerPredicateTests.assertTrue((boolean)this.transformerPredicate.evaluate((Object)Integer.valueOf("-42")));
        TransformerPredicateTests.assertFalse((boolean)this.transformerPredicate.evaluate((Object)Integer.valueOf("42")));
        TransformerPredicateTests.assertFalse((boolean)this.transformerPredicate.evaluate((Object)Integer.valueOf("4242")));
        TransformerPredicateTests.assertFalse((boolean)this.transformerPredicate.evaluate(null));
    }

    public void testEquals() {
        Predicate transformerPredicate2 = PredicateTools.adapt(this.transformer);
        TransformerPredicateTests.assertEquals(this.transformerPredicate, (Object)transformerPredicate2);
        TransformerPredicateTests.assertEquals((int)this.transformerPredicate.hashCode(), (int)transformerPredicate2.hashCode());
        TransformerPredicateTests.assertFalse((boolean)this.transformerPredicate.equals((Object)IsNotNull.instance()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LessThan42Transformer
    extends AbstractTransformer<Integer, Boolean>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        LessThan42Transformer() {
        }

        protected Boolean transform_(Integer integer) {
            return integer < 42;
        }

        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return 42;
        }
    }
}

