/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class LogicalAndTestCase
extends SingleJSPTestCase {
    public LogicalAndTestCase() {
        super("/testdata/jsps/logicalAND.jsp.data", "/logicalAND.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty && myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 828));
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty and myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 909));
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty && true ", (String)ELAssert.getELText(this._structuredDocument, 988));
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty and true ", (String)ELAssert.getELText(this._structuredDocument, 1049));
        LogicalAndTestCase.assertEquals((String)"'true' && myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1114));
        LogicalAndTestCase.assertEquals((String)"'true' and myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1180));
        LogicalAndTestCase.assertEquals((String)"false && myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1269));
        LogicalAndTestCase.assertEquals((String)"false and myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1333));
        LogicalAndTestCase.assertEquals((String)"null && myBean.booleanProperty ", (String)ELAssert.getELText(this._structuredDocument, 1398));
        LogicalAndTestCase.assertEquals((String)"null and myBean.booleanProperty ", (String)ELAssert.getELText(this._structuredDocument, 1462));
        LogicalAndTestCase.assertEquals((String)"'notTrue' && myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1527));
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty && false", (String)ELAssert.getELText(this._structuredDocument, 1598));
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty and false", (String)ELAssert.getELText(this._structuredDocument, 1662));
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty && null ", (String)ELAssert.getELText(this._structuredDocument, 1727));
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty and null", (String)ELAssert.getELText(this._structuredDocument, 1791));
        LogicalAndTestCase.assertEquals((String)"myBean.booleanProperty && 'notTrue'", (String)ELAssert.getELText(this._structuredDocument, 1855));
        LogicalAndTestCase.assertEquals((String)"true && false", (String)ELAssert.getELText(this._structuredDocument, 1922));
        LogicalAndTestCase.assertEquals((String)"null && true", (String)ELAssert.getELText(this._structuredDocument, 1965));
        LogicalAndTestCase.assertEquals((String)"myBean.integerProperty && true", (String)ELAssert.getELText(this._structuredDocument, 2037));
        LogicalAndTestCase.assertEquals((String)"true && myBean.integerProperty", (String)ELAssert.getELText(this._structuredDocument, 2100));
        LogicalAndTestCase.assertEquals((String)"4 && true", (String)ELAssert.getELText(this._structuredDocument, 2163));
    }

    public void testNoErrorExprs() {
        this.assertNoError(828, "Z");
        this.assertNoError(909, "Z");
        this.assertNoError(988, "Z");
        this.assertNoError(1049, "Z");
        this.assertNoError(1114, "Z");
        this.assertNoError(1180, "Z");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1269, "Z", 1);
        ELAssert.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(1333, "Z", 1);
        ELAssert.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(1398, "Z", 1);
        ELAssert.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(1462, "Z", 1);
        ELAssert.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(1527, "Z", 1);
        ELAssert.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(1598, "Z", 1);
        ELAssert.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(1662, "Z", 1);
        ELAssert.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(1727, "Z", 1);
        ELAssert.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(1791, "Z", 1);
        ELAssert.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(1855, "Z", 1);
        ELAssert.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(1922, "Z", 1);
        ELAssert.assertContainsProblem(list, 7);
        list = this.assertSemanticWarning(1965, "Z", 1);
        ELAssert.assertContainsProblem(list, 6);
    }

    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(2037, null, 1);
        ELAssert.assertContainsProblem(list, 5);
        list = this.assertSemanticError(2100, null, 1);
        ELAssert.assertContainsProblem(list, 5);
        list = this.assertSemanticError(2163, null, 1);
        ELAssert.assertContainsProblem(list, 5);
    }
}

