/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteFromClasspathChange;

public class AddToClasspathChange
extends JDTChange {
    private IJavaScriptProject fProjectHandle;
    private IIncludePathEntry fEntryToAdd;

    public AddToClasspathChange(IJavaScriptProject project, IIncludePathEntry entryToAdd) {
        this.fProjectHandle = project;
        this.fEntryToAdd = entryToAdd;
    }

    public AddToClasspathChange(IJavaScriptProject project, String sourceFolderName) {
        this(project, JavaScriptCore.newSourceEntry((IPath)project.getPath().append(sourceFolderName)));
    }

    public AddToClasspathChange(IJavaScriptProject project, IPath newProjectEntry) {
        this(project, JavaScriptCore.newProjectEntry((IPath)newProjectEntry));
    }

    public AddToClasspathChange(IJavaScriptProject project, int entryKind, IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) {
        this(project, AddToClasspathChange.createNewClasspathEntry(entryKind, path, sourceAttachmentPath, sourceAttachmentRootPath));
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 3);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        block3: {
            DeleteFromClasspathChange deleteFromClasspathChange;
            pm.beginTask(this.getName(), 1);
            try {
                if (!this.validateClasspath()) break block3;
                this.getJavaProject().setRawIncludepath(this.getNewClasspathEntries(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                IPath classpathEntryPath = JavaScriptCore.getResolvedIncludepathEntry((IIncludePathEntry)this.fEntryToAdd).getPath();
                deleteFromClasspathChange = new DeleteFromClasspathChange(classpathEntryPath, this.getJavaProject());
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return deleteFromClasspathChange;
        }
        NullChange nullChange = new NullChange();
        Object var3_6 = null;
        pm.done();
        return nullChange;
    }

    public boolean validateClasspath() throws JavaScriptModelException {
        IJavaScriptProject javaProject = this.getJavaProject();
        IIncludePathEntry[] newClasspathEntries = this.getNewClasspathEntries();
        return JavaScriptConventions.validateClasspath((IJavaScriptProject)javaProject, (IIncludePathEntry[])newClasspathEntries).isOK();
    }

    private IIncludePathEntry[] getNewClasspathEntries() throws JavaScriptModelException {
        IIncludePathEntry[] entries = this.getJavaProject().getRawIncludepath();
        ArrayList<IIncludePathEntry> cp = new ArrayList<IIncludePathEntry>(entries.length + 1);
        cp.addAll(Arrays.asList(entries));
        cp.add(this.fEntryToAdd);
        return cp.toArray(new IIncludePathEntry[cp.size()]);
    }

    private static IIncludePathEntry createNewClasspathEntry(int kind, IPath path, IPath sourceAttach, IPath sourceAttachRoot) {
        switch (kind) {
            case 1: {
                return JavaScriptCore.newLibraryEntry((IPath)path, (IPath)sourceAttach, (IPath)sourceAttachRoot);
            }
            case 2: {
                return JavaScriptCore.newProjectEntry((IPath)path);
            }
            case 3: {
                return JavaScriptCore.newSourceEntry((IPath)path);
            }
            case 4: {
                return JavaScriptCore.newVariableEntry((IPath)path, (IPath)sourceAttach, (IPath)sourceAttachRoot);
            }
            case 5: {
                return JavaScriptCore.newContainerEntry((IPath)path);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private IJavaScriptProject getJavaProject() {
        return this.fProjectHandle;
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.AddToClasspathChange_add) + this.getJavaProject().getElementName();
    }

    public Object getModifiedElement() {
        return this.getJavaProject();
    }

    public IIncludePathEntry getClasspathEntry() {
        return this.fEntryToAdd;
    }
}

