/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;

public class FnAdjustDateTimeToTimeZone
extends Function {
    private static Collection _expected_args = null;
    private static final XSDayTimeDuration minDuration = new XSDayTimeDuration(0, 14, 0, 0.0, true);
    private static final XSDayTimeDuration maxDuration = new XSDayTimeDuration(0, 14, 0, 0.0, false);

    public FnAdjustDateTimeToTimeZone() {
        super(new QName("adjust-dateTime-to-timezone"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        return FnAdjustDateTimeToTimeZone.adjustdateTime(args, ec.getDynamicContext());
    }

    public static ResultSequence adjustdateTime(Collection args, DynamicContext dynamicContext) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnAdjustDateTimeToTimeZone.expectedArgs());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        ResultSequence arg2 = null;
        if (argiter.hasNext()) {
            arg2 = (ResultSequence)argiter.next();
        }
        XSDateTime dateTime = (XSDateTime)arg1.item(0);
        XSDayTimeDuration timezone = null;
        if (arg2 != null && arg2.empty()) {
            if (dateTime.timezoned()) {
                XSDateTime localized = new XSDateTime(dateTime.calendar(), null);
                return localized;
            }
            return arg1;
        }
        if (arg2 == null) {
            XSDateTime localized = new XSDateTime(dateTime.normalizeCalendar(dateTime.calendar(), dateTime.tz()), null);
            return localized;
        }
        timezone = (XSDayTimeDuration)arg2.item(0);
        if (timezone.lt(minDuration, dynamicContext) || timezone.gt(maxDuration, dynamicContext)) {
            throw DynamicError.invalidTimezone();
        }
        if (dateTime.tz() == null) {
            return new XSDateTime(dateTime.calendar(), timezone);
        }
        XMLGregorianCalendar xmlCalendar = _datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)dateTime.normalizeCalendar(dateTime.calendar(), dateTime.tz()));
        Duration duration = _datatypeFactory.newDuration(timezone.getStringValue());
        xmlCalendar.add(duration);
        return new XSDateTime(xmlCalendar.toGregorianCalendar(), timezone);
    }

    public static synchronized Collection expectedArgs() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSDateTime(), 3));
            _expected_args.add(new SeqType(new XSDayTimeDuration(), 3));
        }
        return _expected_args;
    }
}

