/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui;

import java.io.File;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.launching.config.BaseLaunchHelper;

public class XSLDebugUILaunchListener
implements ILaunchesListener2 {
    public static final String XSL_LAUNCH_CONFIGURATION_TYPE = "org.eclipse.wst.xsl.launching.launchConfigurationType";

    public void start() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void stop() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            ILaunchConfigurationType configType = null;
            try {
                configType = launch.getLaunchConfiguration().getType();
            }
            catch (CoreException coreException) {}
            if (configType != null && XSL_LAUNCH_CONFIGURATION_TYPE.equals(configType.getIdentifier())) {
                try {
                    BaseLaunchHelper launchHelper = new BaseLaunchHelper(launch.getLaunchConfiguration());
                    File file = launchHelper.getTarget();
                    IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
                    if (ifile != null) {
                        try {
                            ifile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            XSLDebugUIPlugin.log(e);
                        }
                    }
                    this.openFileIfRequired(launchHelper);
                }
                catch (CoreException e) {
                    XSLDebugUIPlugin.log(e);
                }
            }
            ++n2;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    private void openFileIfRequired(final BaseLaunchHelper launchHelper) {
        if (launchHelper.getOpenFileOnCompletion()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        File file = launchHelper.getTarget();
                        Path path = new Path(file.getAbsolutePath());
                        IFileStore filestore = EFS.getLocalFileSystem().getStore((IPath)path);
                        IDE.openEditorOnFileStore((IWorkbenchPage)dw.getActivePage(), (IFileStore)filestore);
                        if (launchHelper.getFormatFileOnCompletion()) {
                            IHandlerService p = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                            p.executeCommand("org.eclipse.wst.sse.ui.format.document", null);
                        }
                    }
                    catch (PartInitException e) {
                        XSLDebugUIPlugin.log((CoreException)((Object)e));
                    }
                    catch (CommandException e) {
                        XSLDebugUIPlugin.log((Exception)((Object)e));
                    }
                }
            });
        }
    }
}

