/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.util.Collection;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.rhino.tests.RequestTest;
import org.eclipse.wst.jsdt.debug.rhino.tests.Util;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;

public class ThreadRequestTests
extends RequestTest {
    public void testThreadsWithNoThreads() throws Exception {
        RhinoRequest request = new RhinoRequest("threads");
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        ThreadRequestTests.assertTrue((boolean)response.isSuccess());
        Collection threads = (Collection)response.getBody().get("threads");
        ThreadRequestTests.assertNotNull((Object)threads);
        ThreadRequestTests.assertTrue((boolean)threads.isEmpty());
    }

    public void testInvalidThread() throws Exception {
        RhinoRequest request = new RhinoRequest("context");
        request.getArguments().put("threadId", new Integer("9999"));
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        ThreadRequestTests.assertFalse((boolean)response.isSuccess());
    }

    public void testThreads() throws Exception {
        this.eventHandler.addSubhandler((RequestTest)this.new RequestTest.SetBreakpointHandler(new int[]{16}));
        this.eventHandler.addSubhandler(new RequestTest.ThreadCheckHandler());
        String script = Util.getTestSource("scripts", "script1.js");
        ThreadRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        this.evalScript(script);
        this.waitForEvents(2);
    }
}

