/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.internal.swt.ComboModelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.DateTimeModelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.SpinnerModelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.TriStateCheckBoxModelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.bind.SWTBindTools;
import org.eclipse.jpt.common.ui.internal.swt.events.DisposeAdapter;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeBooleanPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.NullCheckPropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.PredicatePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pane<T extends Model> {
    private final Pane<?> parent;
    private final PropertyChangeListener aspectChangeListener;
    private final Composite container;
    private boolean populating;
    private final PropertyChangeListener subjectChangeListener;
    private final PropertyValueModel<? extends T> subjectModel;
    private final WidgetFactory widgetFactory;
    private final ResourceManager resourceManager;
    private final PropertyValueModel<Boolean> enabledModel;
    private final PropertyChangeListener enabledModelListener;
    private final DisposeListener controlDisposeListener;
    private static final String TRACE_OPTION = Pane.class.getSimpleName();

    protected Pane(Pane<? extends T> parent, Composite parentComposite) {
        this(parent, parent.getSubjectHolder(), parentComposite);
    }

    protected Pane(Pane<?> parent, PropertyValueModel<? extends T> subjectModel, Composite parentComposite) {
        this(parent, subjectModel, Pane.buildDefaultEnabledModel(), parentComposite);
    }

    protected Pane(Pane<? extends T> parent, Composite parentComposite, PropertyValueModel<Boolean> enabledModel) {
        this(parent, parent.getSubjectHolder(), enabledModel, parentComposite);
    }

    protected Pane(Pane<?> parent, PropertyValueModel<? extends T> subjectModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite) {
        this(parent, subjectModel, enabledModel, parentComposite, null, null);
    }

    protected Pane(PropertyValueModel<? extends T> subjectModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        this(subjectModel, Pane.buildIsNotNullModel(subjectModel), parentComposite, widgetFactory, resourceManager);
    }

    protected Pane(PropertyValueModel<? extends T> subjectModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        this(null, subjectModel, enabledModel, parentComposite, widgetFactory, resourceManager);
    }

    private Pane(Pane<?> parent, PropertyValueModel<? extends T> subjectModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        if (subjectModel == null || enabledModel == null || parentComposite == null) {
            throw new NullPointerException();
        }
        if (parent == null && (widgetFactory == null || resourceManager == null)) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.subjectModel = subjectModel;
        this.enabledModel = Pane.andEnabledModel(parent, enabledModel);
        this.enabledModelListener = this.buildEnabledModelListener();
        this.enabledModel.addPropertyChangeListener("value", this.enabledModelListener);
        this.widgetFactory = widgetFactory;
        this.resourceManager = resourceManager == null ? null : new LocalResourceManager(resourceManager);
        this.aspectChangeListener = this.buildAspectChangeListener();
        this.initialize();
        if (this.addsComposite()) {
            this.container = this.addComposite(parentComposite);
            this.initializeLayout(this.container);
        } else {
            this.container = null;
            this.initializeLayout(parentComposite);
        }
        this.controlDisposeListener = this.buildControlDisposeListener();
        this.getControl().addDisposeListener(this.controlDisposeListener);
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.subjectModel.addPropertyChangeListener("value", this.subjectChangeListener);
        this.engageListeners(this.getSubject());
        this.populate();
    }

    private static PropertyValueModel<Boolean> buildDefaultEnabledModel() {
        return new StaticPropertyValueModel((Object)Boolean.TRUE);
    }

    protected static PropertyValueModel<Boolean> buildIsNotNullModel(PropertyValueModel<?> valueModel) {
        return new PredicatePropertyValueModel(valueModel, PredicateTools.isNotNull());
    }

    protected PropertyValueModel<Boolean> buildSubjectIsNotNullModel() {
        return Pane.buildIsNotNullModel(this.subjectModel);
    }

    private static PropertyValueModel<Boolean> andEnabledModel(Pane<?> pane, PropertyValueModel<Boolean> enabledModel) {
        enabledModel = Pane.buildNonNullModel(enabledModel);
        return pane == null ? enabledModel : CompositeBooleanPropertyValueModel.and((PropertyValueModel[])new PropertyValueModel[]{pane.enabledModel, enabledModel});
    }

    private static PropertyValueModel<Boolean> buildNonNullModel(PropertyValueModel<Boolean> booleanModel) {
        return new NullCheckPropertyValueModelWrapper(booleanModel, (Object)Boolean.FALSE);
    }

    private PropertyChangeListener buildEnabledModelListener() {
        return new EnabledModelListener();
    }

    protected void enabledModelChanged(boolean oldEnabled, boolean newEnabled) {
    }

    private PropertyChangeListener buildSubjectChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSubjectChangeListener_());
    }

    private PropertyChangeListener buildSubjectChangeListener_() {
        return new SubjectChangeListener();
    }

    protected void initialize() {
    }

    protected abstract void initializeLayout(Composite var1);

    private DisposeListener buildControlDisposeListener() {
        return new ControlDisposeListener();
    }

    protected void addPropertyNames(Collection<String> propertyNames) {
    }

    private PropertyChangeListener buildAspectChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildAspectChangeListener_());
    }

    private PropertyChangeListener buildAspectChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (e.getSource() == Pane.this.getSubject()) {
                    Pane.this.updatePane(e.getPropertyName());
                }
            }
        };
    }

    protected final Button addButton(Composite container, String text, Runnable buttonAction) {
        return this.addButton(container, text, null, buttonAction);
    }

    protected final Button addButton(Composite container, String text, Runnable buttonAction, PropertyValueModel<Boolean> enabledModel) {
        return this.addButton(container, text, null, buttonAction, enabledModel);
    }

    protected final Button addUnmanagedButton(Composite container, String text, Runnable buttonAction) {
        return this.addUnmanagedButton(container, text, null, buttonAction);
    }

    protected final Button addButton(Composite container, String text, String helpId, Runnable buttonAction) {
        Button button = this.addUnmanagedButton(container, text, helpId, buttonAction);
        this.controlEnabledState(new Control[]{button});
        return button;
    }

    protected final Button addButton(Composite container, String text, String helpId, Runnable buttonAction, PropertyValueModel<Boolean> enabledModel) {
        Button button = this.addUnmanagedButton(container, text, helpId, buttonAction);
        this.controlEnabledState(enabledModel, new Control[]{button});
        return button;
    }

    private Button addUnmanagedButton(Composite container, String text, String helpId, final Runnable buttonAction) {
        Button button = this.getWidgetFactory().createButton(container, text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                buttonAction.run();
            }
        });
        if (helpId != null) {
            this.setHelp((Control)button, helpId);
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected GridData getFieldGridData() {
        int margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = 200 + margin;
        data.horizontalIndent = margin;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    protected final Button addCheckBox(Composite parent, String buttonText, ModifiablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        return this.addToggleButton(parent, buttonText, booleanHolder, helpId, 32);
    }

    protected final Button addCheckBox(Composite parent, String buttonText, ModifiablePropertyValueModel<Boolean> booleanHolder, String helpId, PropertyValueModel<Boolean> enabledModel) {
        Button button = this.addUnmanagedToggleButton(parent, buttonText, booleanHolder, helpId, 32);
        this.controlEnabledState(enabledModel, new Control[]{button});
        return button;
    }

    protected final Combo addCombo(Composite container) {
        Combo combo = this.addUnmanagedCombo(container);
        this.controlEnabledState(new Control[]{combo});
        return combo;
    }

    protected final Combo addCombo(Composite container, String helpId) {
        Combo combo = this.addUnmanagedCombo(container);
        if (helpId != null) {
            this.setHelp((Control)combo, helpId);
        }
        this.controlEnabledState(new Control[]{combo});
        return combo;
    }

    private Combo addUnmanagedCombo(Composite container) {
        Combo combo = this.getWidgetFactory().createCombo(container);
        combo.setLayoutData((Object)this.getFieldGridData());
        return combo;
    }

    protected final <V> Combo addCombo(Composite container, ListValueModel<V> listHolder, ModifiablePropertyValueModel<V> selectedItemHolder, Transformer<V, String> stringConverter, String helpId) {
        Combo combo = this.addCombo(container, helpId);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    private <V> Combo addUnmanagedCombo(Composite container, ListValueModel<V> listHolder, ModifiablePropertyValueModel<V> selectedItemHolder, Transformer<V, String> stringConverter) {
        Combo combo = this.addUnmanagedCombo(container);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    protected final <V> Combo addCombo(Composite container, ListValueModel<V> listHolder, ModifiablePropertyValueModel<V> selectedItemHolder, Transformer<V, String> stringConverter, PropertyValueModel<Boolean> enabledModel) {
        Combo combo = this.addUnmanagedCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.controlEnabledState(enabledModel, new Control[]{combo});
        return combo;
    }

    protected final ComboViewer addComboViewer(Composite container, IBaseLabelProvider labelProvider) {
        Combo combo = this.addCombo(container);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    protected final ComboViewer addComboViewer(Composite container, IBaseLabelProvider labelProvider, String helpId) {
        Combo combo = this.addCombo(container, helpId);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    protected Composite addComposite(Composite parent) {
        return this.addSubPane(parent);
    }

    protected boolean addsComposite() {
        return true;
    }

    protected final <V> Combo addEditableCombo(Composite container, ListValueModel<V> listHolder, ModifiablePropertyValueModel<V> selectedItemHolder, Transformer<V, String> stringConverter, PropertyValueModel<Boolean> enabledModel) {
        return this.addEditableCombo(container, listHolder, selectedItemHolder, stringConverter, enabledModel, null);
    }

    protected final <V> Combo addEditableCombo(Composite container, ListValueModel<V> listHolder, ModifiablePropertyValueModel<V> selectedItemHolder, Transformer<V, String> stringConverter, PropertyValueModel<Boolean> enabledModel, String helpId) {
        Combo combo = this.addUnmanagedEditableCombo(container, listHolder, selectedItemHolder, stringConverter, helpId);
        this.controlEnabledState(enabledModel, new Control[]{combo});
        return combo;
    }

    protected final Combo addEditableCombo(Composite container) {
        return this.addEditableCombo(container, null);
    }

    protected final Combo addEditableCombo(Composite container, String helpId) {
        Combo combo = this.getWidgetFactory().createEditableCombo(container);
        if (helpId != null) {
            this.setHelp((Control)combo, helpId);
        }
        combo.setLayoutData((Object)this.getFieldGridData());
        this.controlEnabledState(new Control[]{combo});
        return combo;
    }

    protected final <V> Combo addEditableCombo(Composite container, ListValueModel<V> listHolder, ModifiablePropertyValueModel<V> selectedItemHolder) {
        return this.addEditableCombo(container, listHolder, selectedItemHolder, (Transformer<V, String>)TransformerTools.objectToStringTransformer(), (String)null);
    }

    protected final <V> Combo addEditableCombo(Composite container, ListValueModel<V> listHolder, ModifiablePropertyValueModel<V> selectedItemHolder, Transformer<V, String> stringConverter, String helpId) {
        Combo combo = this.addEditableCombo(container, helpId);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    protected final ComboViewer addEditableComboViewer(Composite container, IBaseLabelProvider labelProvider) {
        Combo combo = this.addEditableCombo(container);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    protected final Hyperlink addHyperlink(Composite parent, String text, final Runnable hyperLinkAction) {
        Hyperlink link = this.getWidgetFactory().createHyperlink(parent, text);
        this.controlEnabledState(new Control[]{link});
        link.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Hyperlink hyperLink = (Hyperlink)e.widget;
                if (hyperLink.isEnabled()) {
                    hyperLinkAction.run();
                }
            }
        });
        return link;
    }

    protected final Hyperlink addHyperlink(Composite parent, String text) {
        Hyperlink link = this.getWidgetFactory().createHyperlink(parent, text);
        this.controlEnabledState(new Control[]{link});
        return link;
    }

    protected final Label addLabel(Composite container, String labelText) {
        Label label = this.addUnmanagedLabel(container, labelText);
        this.controlEnabledState(new Control[]{label});
        return label;
    }

    protected final Label addLabel(Composite container, String labelText, PropertyValueModel<Boolean> enabledModel) {
        Label label = this.addUnmanagedLabel(container, labelText);
        this.controlEnabledState(enabledModel, new Control[]{label});
        return label;
    }

    private Label addUnmanagedLabel(Composite container, String labelText) {
        return this.getWidgetFactory().createLabel(container, labelText);
    }

    protected final Spinner addSpinner(Composite parent, ModifiablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, String helpId) {
        Spinner spinner = this.addUnmanagedSpinner(parent, numberHolder, defaultValue, minimumValue, maximumValue, helpId);
        this.controlEnabledState(new Control[]{spinner});
        return spinner;
    }

    private Spinner addUnmanagedSpinner(Composite parent, ModifiablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, String helpId) {
        Spinner spinner = this.getWidgetFactory().createSpinner(parent);
        spinner.setMinimum(minimumValue);
        spinner.setMaximum(maximumValue);
        GridData gridData = this.getFieldGridData();
        gridData.grabExcessHorizontalSpace = false;
        spinner.setLayoutData((Object)gridData);
        SpinnerModelAdapter.adapt(numberHolder, spinner, defaultValue);
        if (helpId != null) {
            this.setHelp((Control)spinner, helpId);
        }
        return spinner;
    }

    protected final DateTime addDateTime(Composite parent, ModifiablePropertyValueModel<Integer> hoursHolder, ModifiablePropertyValueModel<Integer> minutesHolder, ModifiablePropertyValueModel<Integer> secondsHolder, String helpId) {
        DateTime dateTime = this.addUnmanagedDateTime(parent, hoursHolder, minutesHolder, secondsHolder, helpId);
        this.controlEnabledState(new Control[]{dateTime});
        return dateTime;
    }

    protected final DateTime addDateTime(Composite parent, ModifiablePropertyValueModel<Integer> hoursHolder, ModifiablePropertyValueModel<Integer> minutesHolder, ModifiablePropertyValueModel<Integer> secondsHolder, String helpId, PropertyValueModel<Boolean> enabledModel) {
        DateTime dateTime = this.addUnmanagedDateTime(parent, hoursHolder, minutesHolder, secondsHolder, helpId);
        this.controlEnabledState(enabledModel, new Control[]{dateTime});
        return dateTime;
    }

    private DateTime addUnmanagedDateTime(Composite parent, ModifiablePropertyValueModel<Integer> hoursHolder, ModifiablePropertyValueModel<Integer> minutesHolder, ModifiablePropertyValueModel<Integer> secondsHolder, String helpId) {
        DateTime dateTime = this.getWidgetFactory().createDateTime(parent, 128);
        DateTimeModelAdapter.adapt(hoursHolder, minutesHolder, secondsHolder, dateTime);
        if (helpId != null) {
            this.setHelp((Control)dateTime, helpId);
        }
        return dateTime;
    }

    private <V> Combo addUnmanagedEditableCombo(Composite container, ListValueModel<V> listHolder, ModifiablePropertyValueModel<V> selectedItemHolder, Transformer<V, String> stringConverter, String helpId) {
        Combo combo = this.addUnmanagedEditableCombo(container, helpId);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    private Combo addUnmanagedEditableCombo(Composite container, String helpId) {
        Combo combo = this.getWidgetFactory().createEditableCombo(container);
        combo.setLayoutData((Object)this.getFieldGridData());
        if (helpId != null) {
            this.setHelp((Control)container, helpId);
        }
        return combo;
    }

    protected final List addList(Composite container, String helpId) {
        return this.addList(container, (ModifiablePropertyValueModel<String>)new SimplePropertyValueModel(), helpId);
    }

    protected final List addList(Composite container, ModifiablePropertyValueModel<String> selectionHolder, String helpId) {
        List list = this.addUnmanagedList(container, selectionHolder, helpId);
        this.controlEnabledState(new Control[]{list});
        return list;
    }

    private List addUnmanagedList(Composite container, ModifiablePropertyValueModel<String> selectionHolder, String helpId) {
        List list = this.getWidgetFactory().createList(container, 2818);
        list.addSelectionListener(this.buildSelectionListener(selectionHolder));
        list.setLayoutData((Object)new GridData(1808));
        if (helpId != null) {
            this.setHelp((Control)list, helpId);
        }
        return list;
    }

    protected final Text addMultiLineText(Composite container) {
        Text text = this.getWidgetFactory().createMultiLineText(container);
        text.setLayoutData((Object)this.getFieldGridData());
        this.controlEnabledState(new Control[]{text});
        return text;
    }

    protected final Text addMultiLineText(Composite container, int lineCount, String helpId) {
        Text text = this.addMultiLineText(container);
        this.adjustMultiLineTextLayout(lineCount, (Control)text, text.getLineHeight());
        if (helpId != null) {
            this.setHelp((Control)text, helpId);
        }
        return text;
    }

    protected final Text addMultiLineText(Composite container, ModifiablePropertyValueModel<String> textHolder, int lineCount) {
        return this.addMultiLineText(container, textHolder, lineCount, null);
    }

    protected final Text addMultiLineText(Composite container, ModifiablePropertyValueModel<String> textModel, int lineCount, String helpId) {
        Text text = this.addMultiLineText(container, lineCount, helpId);
        SWTBindTools.bind(textModel, text);
        return text;
    }

    protected final void adjustMultiLineTextLayout(int lineCount, Control text, int lineHeight) {
        GridData gridData = (GridData)text.getLayoutData();
        if (gridData == null) {
            gridData = this.getFieldGridData();
            text.setLayoutData((Object)gridData);
        }
        gridData.heightHint = lineHeight * lineCount;
    }

    protected final PageBook addPageBook(Composite container) {
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        return pageBook;
    }

    protected final Composite addPane(Composite parent) {
        return this.getWidgetFactory().createComposite(parent);
    }

    protected final Composite addPane(Composite container, Layout layout) {
        container = this.addPane(container);
        container.setLayout(layout);
        container.setLayoutData((Object)new GridData(1808));
        return container;
    }

    protected final Text addPasswordText(Composite container, ModifiablePropertyValueModel<String> textModel) {
        Text text = this.addPasswordText(container);
        SWTBindTools.bind(textModel, text);
        return text;
    }

    protected final Text addPasswordText(Composite container) {
        Text text = this.getWidgetFactory().createPasswordText(container);
        text.setLayoutData((Object)this.getFieldGridData());
        this.controlEnabledState(new Control[]{text});
        return text;
    }

    protected final Button addPushButton(Composite parent, String buttonText, Runnable buttonAction) {
        return this.addPushButton(parent, buttonText, null, buttonAction);
    }

    protected final Button addPushButton(Composite parent, String buttonText, String helpId, final Runnable buttonAction) {
        Button button = this.getWidgetFactory().createPushButton(parent, buttonText);
        this.controlEnabledState(new Control[]{button});
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                buttonAction.run();
            }
        });
        button.setLayoutData((Object)new GridData());
        if (helpId != null) {
            this.setHelp((Control)button, helpId);
        }
        return button;
    }

    protected final Button addRadioButton(Composite parent, String buttonText, ModifiablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        return this.addToggleButton(parent, buttonText, booleanHolder, helpId, 16);
    }

    protected final Composite addSection(Composite container, String sectionText, String description) {
        return this.addSection(container, sectionText, description, 256);
    }

    private Composite addSection(Composite container, String sectionText, String description, int type) {
        Section section = this.getWidgetFactory().createSection(container, type | (description != null ? 128 : 0));
        section.setLayoutData((Object)new GridData(768));
        section.setText(sectionText);
        if (description != null) {
            section.setDescription(description);
        }
        Composite subPane = this.addSubPane((Composite)section);
        section.setClient((Control)subPane);
        return subPane;
    }

    private SelectionListener buildSelectionListener(final ModifiablePropertyValueModel<String> selectionHolder) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = (List)e.widget;
                String[] selectedItems = list.getSelection();
                if (selectedItems == null || selectedItems.length != 1) {
                    selectionHolder.setValue(null);
                } else {
                    selectionHolder.setValue((Object)selectedItems[0]);
                }
            }
        };
    }

    protected final Composite addSubPane(Composite container) {
        return this.addSubPane(container, 0);
    }

    protected final Composite addSubPane(Composite container, int topMargin) {
        return this.addSubPane(container, topMargin, 0);
    }

    protected final Composite addSubPane(Composite container, int topMargin, int leftMargin) {
        return this.addSubPane(container, topMargin, leftMargin, 0, 0);
    }

    protected final Composite addSubPane(Composite container, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        return this.addSubPane(container, 1, topMargin, leftMargin, bottomMargin, rightMargin);
    }

    protected final Composite addSubPane(Composite container, int columnCount, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        GridLayout layout = new GridLayout(columnCount, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = topMargin;
        layout.marginLeft = leftMargin;
        layout.marginBottom = bottomMargin;
        layout.marginRight = rightMargin;
        container = this.addPane(container, (Layout)layout);
        return container;
    }

    protected final Table addTable(Composite container, int style, String helpId) {
        Table table = this.addUnmanagedTable(container, style, helpId);
        this.controlEnabledState(new Control[]{table});
        return table;
    }

    protected final Table addUnmanagedTable(Composite container, int style, String helpId) {
        Table table = this.getWidgetFactory().createTable(container, style);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = table.getItemHeight() * 4;
        table.setLayoutData((Object)gridData);
        if (helpId != null) {
            this.setHelp((Control)table, helpId);
        }
        return table;
    }

    protected final Table addTable(Composite container, String helpId) {
        return this.addTable(container, 66306, helpId);
    }

    protected final Table addUnmanagedTable(Composite container, String helpId) {
        return this.addUnmanagedTable(container, 66306, helpId);
    }

    protected final Text addText(Composite container) {
        Text text = this.addUnmanagedText(container);
        this.controlEnabledState(new Control[]{text});
        return text;
    }

    private Text addUnmanagedText(Composite container) {
        Text text = this.getWidgetFactory().createText(container);
        text.setLayoutData((Object)this.getFieldGridData());
        return text;
    }

    protected final Text addText(Composite container, String helpId) {
        Text text = this.addText(container);
        if (helpId != null) {
            this.setHelp((Control)text, helpId);
        }
        return text;
    }

    private Text addUnmanagedText(Composite container, String helpId) {
        Text text = this.addUnmanagedText(container);
        if (helpId != null) {
            this.setHelp((Control)text, helpId);
        }
        return text;
    }

    protected final Text addText(Composite container, ModifiablePropertyValueModel<String> textHolder) {
        return this.addText(container, textHolder, null);
    }

    protected final Text addText(Composite container, ModifiablePropertyValueModel<String> textModel, String helpId) {
        Text text = this.addText(container, helpId);
        SWTBindTools.bind(textModel, text);
        return text;
    }

    protected final Text addText(Composite container, ModifiablePropertyValueModel<String> textHolder, String helpId, PropertyValueModel<Boolean> enabledModel) {
        Text text = this.addUnmanagedText(container, textHolder, helpId);
        this.controlEnabledState(enabledModel, new Control[]{text});
        return text;
    }

    private Text addUnmanagedText(Composite container, ModifiablePropertyValueModel<String> textModel, String helpId) {
        Text text = this.addUnmanagedText(container, helpId);
        SWTBindTools.bind(textModel, text);
        return text;
    }

    protected final Group addTitledGroup(Composite container, String title) {
        return this.addTitledGroup(container, title, null);
    }

    protected final Group addTitledGroup(Composite container, String title, String helpId) {
        return this.addTitledGroup(container, title, 1, helpId);
    }

    protected final Group addTitledGroup(Composite container, String title, int columnCount, String helpId) {
        Group group = this.getWidgetFactory().createGroup(container, title);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(columnCount, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginBottom = 5;
        layout.marginRight = 5;
        group.setLayout((Layout)layout);
        if (helpId != null) {
            this.setHelp((Control)group, helpId);
        }
        return group;
    }

    private Button addUnmanagedToggleButton(Composite parent, String buttonText, ModifiablePropertyValueModel<Boolean> booleanModel, String helpId, int toggleButtonType) {
        Button button = toggleButtonType == 8 ? this.getWidgetFactory().createPushButton(parent, buttonText) : (toggleButtonType == 16 ? this.getWidgetFactory().createRadioButton(parent, buttonText) : (toggleButtonType == 32 ? this.getWidgetFactory().createCheckBox(parent, buttonText) : this.getWidgetFactory().createButton(parent, buttonText)));
        button.setLayoutData((Object)new GridData());
        SWTBindTools.bind(booleanModel, button);
        if (helpId != null) {
            this.setHelp((Control)button, helpId);
        }
        return button;
    }

    private Button addToggleButton(Composite parent, String buttonText, ModifiablePropertyValueModel<Boolean> booleanHolder, String helpId, int toggleButtonType) {
        Button button = this.addUnmanagedToggleButton(parent, buttonText, booleanHolder, helpId, toggleButtonType);
        this.controlEnabledState(new Control[]{button});
        return button;
    }

    protected final TriStateCheckBox addTriStateCheckBox(Composite parent, String text, ModifiablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        TriStateCheckBox checkBox = this.addUnmanagedTriStateCheckBox(parent, text, booleanHolder, helpId);
        this.controlEnabledState(new Control[]{checkBox.getCheckBox()});
        return checkBox;
    }

    protected final TriStateCheckBox addUnmanagedTriStateCheckBox(Composite parent, String text, ModifiablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        TriStateCheckBox checkBox = new TriStateCheckBox(parent, text, this.getWidgetFactory());
        TriStateCheckBoxModelAdapter.adapt(booleanHolder, checkBox);
        if (helpId != null) {
            this.setHelp((Control)checkBox.getCheckBox(), helpId);
        }
        return checkBox;
    }

    protected final TriStateCheckBox addTriStateCheckBoxWithDefault(Composite parent, String text, ModifiablePropertyValueModel<Boolean> booleanHolder, PropertyValueModel<String> textModel, String helpId) {
        TriStateCheckBox checkBox = this.addTriStateCheckBox(parent, text, booleanHolder, helpId);
        SWTBindTools.bindTextLabel(textModel, checkBox.getCheckBox());
        return checkBox;
    }

    protected final TriStateCheckBox addTriStateCheckBoxWithDefault(Composite parent, String text, ModifiablePropertyValueModel<Boolean> booleanHolder, PropertyValueModel<String> textModel, PropertyValueModel<Boolean> enabledModel, String helpId) {
        TriStateCheckBox checkBox = this.addUnmanagedTriStateCheckBox(parent, text, booleanHolder, helpId);
        this.controlEnabledState(enabledModel, new Control[]{checkBox.getCheckBox()});
        SWTBindTools.bindTextLabel(textModel, checkBox.getCheckBox());
        return checkBox;
    }

    protected void doPopulate() {
        JptCommonUiPlugin.instance().trace(TRACE_OPTION, "doPopulate");
    }

    protected boolean isEnabled() {
        return (Boolean)this.enabledModel.getValue();
    }

    protected void controlEnabledState(Control ... controls) {
        SWTBindTools.controlEnabledState(this.enabledModel, controls);
    }

    protected void controlEnabledState(PropertyValueModel<Boolean> controlsEnabledModel, Control ... controls) {
        SWTBindTools.controlEnabledState(this.andEnabledModel(controlsEnabledModel), controls);
    }

    private PropertyValueModel<Boolean> andEnabledModel(PropertyValueModel<Boolean> booleanModel) {
        return Pane.andEnabledModel(this, booleanModel);
    }

    private void engageListeners(T subject) {
        if (subject != null) {
            this.engageListeners_(subject);
        }
    }

    protected void engageListeners_(T subject) {
        JptCommonUiPlugin.instance().trace(TRACE_OPTION, "engageListeners_({0})", new Object[]{subject});
        for (String propertyName : this.getPropertyNames()) {
            subject.addPropertyChangeListener(propertyName, this.aspectChangeListener);
        }
    }

    private void disengageListeners(T subject) {
        if (subject != null) {
            this.disengageListeners_(subject);
        }
    }

    protected void disengageListeners_(T subject) {
        JptCommonUiPlugin.instance().trace(TRACE_OPTION, "disengageListeners_({0})", new Object[]{subject});
        for (String propertyName : this.getPropertyNames()) {
            subject.removePropertyChangeListener(propertyName, this.aspectChangeListener);
        }
    }

    public Control getControl() {
        if (!this.addsComposite()) {
            throw new IllegalStateException("Must override getControl() if addsComposite() returns false");
        }
        return this.container;
    }

    protected final PropertyValueModel<? extends T> getSubjectHolder() {
        return this.subjectModel;
    }

    protected final WidgetFactory getWidgetFactory() {
        return this.parent == null ? this.widgetFactory : this.parent.getWidgetFactory();
    }

    public final ResourceManager getResourceManager() {
        return this.parent == null ? this.resourceManager : this.parent.getResourceManager();
    }

    protected final void setHelp(Control control, String contextID) {
        WorkbenchTools.setHelp(control, contextID);
    }

    protected final boolean isPopulating() {
        return this.populating;
    }

    private void populate() {
        if (!this.getControl().isDisposed()) {
            JptCommonUiPlugin.instance().trace(TRACE_OPTION, "populate");
            this.repopulate();
        }
    }

    protected void propertyChanged(String propertyName) {
    }

    private Collection<String> getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        this.addPropertyNames(propertyNames);
        return propertyNames;
    }

    protected final void repopulate() {
        JptCommonUiPlugin.instance().trace(TRACE_OPTION, "repopulate");
        try {
            this.setPopulating(true);
            this.doPopulate();
        }
        finally {
            this.setPopulating(false);
        }
    }

    protected final void setPopulating(boolean populating) {
        this.populating = populating;
    }

    public void setVisible(boolean visible) {
        if (this.container != null && !this.container.isDisposed()) {
            this.container.setVisible(visible);
        }
    }

    public final Shell getShell() {
        return this.getControl().getShell();
    }

    public T getSubject() {
        return (T)((Model)this.subjectModel.getValue());
    }

    final void subjectChanged(T oldSubject, T newSubject) {
        if (!this.getControl().isDisposed()) {
            JptCommonUiPlugin.instance().trace(TRACE_OPTION, "subjectChanged({0}, {1})", new Object[]{oldSubject, newSubject});
            this.disengageListeners(oldSubject);
            this.repopulate();
            this.engageListeners(newSubject);
        }
    }

    private void updatePane(String propertyName) {
        if (!this.isPopulating() && !this.getControl().isDisposed()) {
            this.populating = true;
            try {
                this.propertyChanged(propertyName);
            }
            finally {
                this.populating = false;
            }
        }
    }

    protected void controlDisposed() {
        JptCommonUiPlugin.instance().trace(TRACE_OPTION, "control disposed");
        this.disengageListeners(this.getSubject());
        this.subjectModel.removePropertyChangeListener("value", this.subjectChangeListener);
        this.enabledModel.removePropertyChangeListener("value", this.enabledModelListener);
        this.getControl().removeDisposeListener(this.controlDisposeListener);
        if (this.parent == null) {
            this.resourceManager.dispose();
        }
    }

    class ControlDisposeListener
    extends DisposeAdapter {
        ControlDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            Pane.this.controlDisposed();
        }
    }

    class EnabledModelListener
    extends PropertyChangeAdapter {
        EnabledModelListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            Pane.this.enabledModelChanged((Boolean)event.getOldValue(), (Boolean)event.getNewValue());
        }
    }

    class SubjectChangeListener
    extends PropertyChangeAdapter {
        SubjectChangeListener() {
        }

        public void propertyChanged(PropertyChangeEvent e) {
            Pane.this.subjectChanged((Model)e.getOldValue(), (Model)e.getNewValue());
        }
    }
}

