/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundExpressionStateObject
extends AbstractStateObject {
    private StateObject leftStateObject;
    private StateObject rightStateObject;
    public static final String LEFT_STATE_OBJECT_PROPERTY = "leftStateObject";
    public static final String RIGHT_STATE_OBJECT_PROPERTY = "rightStateObject";

    protected CompoundExpressionStateObject(StateObject parent) {
        super(parent);
    }

    protected CompoundExpressionStateObject(StateObject parent, StateObject leftStateObject, StateObject rightStateObject) {
        super(parent);
        this.leftStateObject = this.parent(leftStateObject);
        this.rightStateObject = this.parent(rightStateObject);
    }

    protected CompoundExpressionStateObject(StateObject parent, String leftJpqlFragment, String rightJpqlFragment) {
        super(parent);
        this.parseLeft(leftJpqlFragment);
        this.parseRight(rightJpqlFragment);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.leftStateObject != null) {
            children.add(this.leftStateObject);
        }
        if (this.rightStateObject != null) {
            children.add(this.rightStateObject);
        }
    }

    @Override
    public CompoundExpression getExpression() {
        return (CompoundExpression)super.getExpression();
    }

    public abstract String getIdentifier();

    public StateObject getLeft() {
        return this.leftStateObject;
    }

    protected abstract String getLeftQueryBNFId();

    public StateObject getRight() {
        return this.rightStateObject;
    }

    protected abstract String getRightQueryBNFId();

    public boolean hasLeft() {
        return this.leftStateObject != null;
    }

    public boolean hasRight() {
        return this.rightStateObject != null;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            CompoundExpressionStateObject compound = (CompoundExpressionStateObject)stateObject;
            return this.areEquivalent(this.leftStateObject, compound.leftStateObject) && this.areEquivalent(this.rightStateObject, compound.rightStateObject);
        }
        return false;
    }

    public void parseLeft(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, this.getLeftQueryBNFId());
        this.setLeft((StateObject)stateObject);
    }

    public void parseRight(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, this.getRightQueryBNFId());
        this.setLeft((StateObject)stateObject);
    }

    public void setLeft(StateObject leftStateObject) {
        StateObject oldLeftStateObject = this.leftStateObject;
        this.leftStateObject = this.parent(leftStateObject);
        this.firePropertyChanged(LEFT_STATE_OBJECT_PROPERTY, oldLeftStateObject, leftStateObject);
    }

    public void setRight(StateObject rightStateObject) {
        StateObject oldRightStateObject = this.rightStateObject;
        this.rightStateObject = this.parent(rightStateObject);
        this.firePropertyChanged(RIGHT_STATE_OBJECT_PROPERTY, oldRightStateObject, rightStateObject);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.leftStateObject != null) {
            this.leftStateObject.toString(writer);
        }
        writer.append(' ');
        writer.append(this.getIdentifier());
        writer.append(' ');
        if (this.rightStateObject != null) {
            this.rightStateObject.toString(writer);
        }
    }
}

