/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.OrderByItemStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateFieldPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByClauseStateObject
extends AbstractListHolderStateObject<OrderByItemStateObject> {
    public static final String ORDER_BY_ITEMS_LIST = "orderByItems";

    public OrderByClauseStateObject(SelectStatementStateObject parent) {
        super(parent);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public OrderByItemStateObject addItem() {
        return this.addItem(OrderByItem.Ordering.DEFAULT);
    }

    @Override
    public OrderByItemStateObject addItem(OrderByItem.Ordering ordering) {
        OrderByItemStateObject updateItem = new OrderByItemStateObject(this, ordering);
        this.addItem(updateItem);
        return updateItem;
    }

    @Override
    public OrderByItemStateObject addItem(String ... paths) {
        return this.addOrderByItem(paths, OrderByItem.Ordering.DEFAULT);
    }

    @Override
    public OrderByItemStateObject addItem(String variable) {
        return this.addItem(variable, OrderByItem.Ordering.DEFAULT);
    }

    public OrderByItemStateObject addItem(String path, OrderByItem.Ordering ordering) {
        OrderByItemStateObject orderByItem = this.addItem(ordering);
        orderByItem.setStateObject((StateObject)this.buildStateObject(path, "internal_orderby_item"));
        return orderByItem;
    }

    public OrderByItemStateObject addItemAsc(String variable) {
        return this.addItem(variable, OrderByItem.Ordering.ASC);
    }

    public OrderByItemStateObject addItemDesc(String variable) {
        return this.addItem(variable, OrderByItem.Ordering.DESC);
    }

    public OrderByItemStateObject addOrderByItem(String[] paths, OrderByItem.Ordering ordering) {
        StateFieldPathExpressionStateObject stateField = new StateFieldPathExpressionStateObject(this);
        stateField.setPaths(paths);
        OrderByItemStateObject updateItem = new OrderByItemStateObject(this, stateField, ordering);
        this.addItem(updateItem);
        return updateItem;
    }

    @Override
    public OrderByClause getExpression() {
        return (OrderByClause)super.getExpression();
    }

    @Override
    public SelectStatementStateObject getParent() {
        return (SelectStatementStateObject)super.getParent();
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        return super.isEquivalent(stateObject) && this.areChildrenEquivalent((OrderByClauseStateObject)stateObject);
    }

    @Override
    protected String listName() {
        return ORDER_BY_ITEMS_LIST;
    }

    public void parse(String jpqlFragment) {
        this.buildStateObjects(jpqlFragment, "orderby_item");
    }

    public void setExpression(OrderByClause expression) {
        super.setExpression(expression);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        writer.append("ORDER BY");
        if (this.hasItems()) {
            writer.append(' ');
            this.toStringItems(writer, true);
        }
    }
}

