/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableValidator
implements JpaValidator {
    protected final PersistentAttribute persistentAttribute;
    protected final Table table;

    protected AbstractTableValidator(Table table) {
        this(null, table);
    }

    protected AbstractTableValidator(PersistentAttribute persistentAttribute, Table table) {
        this.persistentAttribute = persistentAttribute;
        this.table = table;
    }

    @Override
    public boolean validate(List<IMessage> messages, IReporter reporter) {
        return this.validatesAgainstDatabase() && this.validateAgainstDatabase(messages);
    }

    protected boolean validatesAgainstDatabase() {
        return this.table.validatesAgainstDatabase();
    }

    protected boolean validateAgainstDatabase(List<IMessage> messages) {
        if (!this.table.catalogIsResolved()) {
            messages.add(this.buildUnresolvedCatalogMessage());
            return false;
        }
        if (!this.table.schemaIsResolved()) {
            messages.add(this.buildUnresolvedSchemaMessage());
            return false;
        }
        if (!this.table.isResolved()) {
            if (this.table.getName() != null) {
                messages.add(this.buildUnresolvedNameMessage());
            }
            return false;
        }
        return true;
    }

    protected IMessage buildUnresolvedCatalogMessage() {
        return this.tableIsPartOfVirtualAttribute() ? this.buildVirtualAttributeUnresolvedCatalogMessage() : this.buildUnresolvedCatalogMessage(this.getUnresolvedCatalogMessage());
    }

    protected abstract ValidationMessage getUnresolvedCatalogMessage();

    protected IMessage buildUnresolvedCatalogMessage(ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)this.table.getResource(), (TextRange)this.table.getCatalogValidationTextRange(), (ValidationMessage)message, (Object[])new Object[]{this.table.getCatalog(), this.table.getName()});
    }

    protected IMessage buildVirtualAttributeUnresolvedCatalogMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.table.getResource(), (TextRange)this.getVirtualAttributeValidationTextRange(), (ValidationMessage)this.getVirtualAttributeUnresolvedCatalogMessage(), (Object[])new Object[]{this.persistentAttribute.getName(), this.table.getCatalog(), this.table.getName()});
    }

    protected TextRange getVirtualAttributeValidationTextRange() {
        return this.persistentAttribute.getValidationTextRange();
    }

    protected abstract ValidationMessage getVirtualAttributeUnresolvedCatalogMessage();

    protected IMessage buildUnresolvedSchemaMessage() {
        return this.tableIsPartOfVirtualAttribute() ? this.buildVirtualAttributeUnresolvedSchemaMessage() : this.buildUnresolvedSchemaMessage(this.getUnresolvedSchemaMessage());
    }

    protected abstract ValidationMessage getUnresolvedSchemaMessage();

    protected IMessage buildUnresolvedSchemaMessage(ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)this.table.getResource(), (TextRange)this.table.getSchemaValidationTextRange(), (ValidationMessage)message, (Object[])new Object[]{this.table.getSchema(), this.table.getName()});
    }

    protected IMessage buildVirtualAttributeUnresolvedSchemaMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.table.getResource(), (TextRange)this.getVirtualAttributeValidationTextRange(), (ValidationMessage)this.getVirtualAttributeUnresolvedSchemaMessage(), (Object[])new Object[]{this.persistentAttribute.getName(), this.table.getSchema(), this.table.getName()});
    }

    protected abstract ValidationMessage getVirtualAttributeUnresolvedSchemaMessage();

    protected IMessage buildUnresolvedNameMessage() {
        return this.tableIsPartOfVirtualAttribute() ? this.buildVirtualAttributeUnresolvedNameMessage() : this.buildUnresolvedNameMessage(this.getUnresolvedNameMessage());
    }

    protected abstract ValidationMessage getUnresolvedNameMessage();

    protected IMessage buildUnresolvedNameMessage(ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)this.table.getResource(), (TextRange)this.table.getNameValidationTextRange(), (ValidationMessage)message, (Object[])new Object[]{this.table.getName()});
    }

    protected IMessage buildVirtualAttributeUnresolvedNameMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.table.getResource(), (TextRange)this.getVirtualAttributeValidationTextRange(), (ValidationMessage)this.getVirtualAttributeUnresolvedNameMessage(), (Object[])new Object[]{this.persistentAttribute.getName(), this.table.getName()});
    }

    protected abstract ValidationMessage getVirtualAttributeUnresolvedNameMessage();

    protected boolean tableIsPartOfVirtualAttribute() {
        return this.persistentAttribute != null && this.persistentAttribute.isVirtual();
    }
}

