/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.BaseEnumeratedAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EnumType;

public abstract class SourceBaseEnumeratedAnnotation
extends SourceAnnotation
implements BaseEnumeratedAnnotation {
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private EnumType value;
    private TextRange valueTextRange;

    protected SourceBaseEnumeratedAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
        this.valueDeclarationAdapter = new EnumDeclarationAnnotationElementAdapter(daa, this.getValueElementName());
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.valueDeclarationAdapter);
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.value = this.buildValue(astAnnotation);
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncValue(this.buildValue(astAnnotation));
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.value);
    }

    public EnumType getValue() {
        return this.value;
    }

    public void setValue(EnumType value) {
        if (this.attributeValueHasChanged((Object)this.value, (Object)value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)EnumType.toJavaAnnotationValue(value));
        }
    }

    private void syncValue(EnumType astValue) {
        EnumType old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", (Object)old, (Object)astValue);
    }

    private EnumType buildValue(Annotation astAnnotation) {
        return EnumType.fromJavaAnnotationValue(this.valueAdapter.getValue(astAnnotation));
    }

    public TextRange getValueTextRange() {
        return this.valueTextRange;
    }

    private TextRange buildValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astAnnotation);
    }

    protected abstract String getValueElementName();
}

