/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.resource.orm;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.xml.EBaseObjectImpl;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.resource.orm.OrmPackage;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManagedType;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public abstract class AbstractXmlManagedType
extends EBaseObjectImpl
implements XmlManagedType {
    protected static final String CLASS_NAME_EDEFAULT = null;
    protected String className = CLASS_NAME_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;

    protected AbstractXmlManagedType() {
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.ABSTRACT_XML_MANAGED_TYPE;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String newClassName) {
        String oldClassName = this.className;
        this.className = newClassName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldClassName, (Object)this.className));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDescription, (Object)this.description));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getClassName();
            }
            case 1: {
                return this.getDescription();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setClassName((String)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setClassName(CLASS_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return CLASS_NAME_EDEFAULT == null ? this.className != null : !CLASS_NAME_EDEFAULT.equals(this.className);
            }
            case 1: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (className: ");
        result.append(this.className);
        result.append(", description: ");
        result.append(this.description);
        result.append(')');
        return result.toString();
    }

    public TextRange getClassTextRange() {
        return this.getAttributeTextRange("class");
    }

    protected static Translator buildDescriptionTranslator() {
        return new Translator("description", (EStructuralFeature)OrmPackage.eINSTANCE.getXmlManagedType_Description());
    }

    protected static Translator buildClassTranslator() {
        return new Translator("class", (EStructuralFeature)OrmPackage.eINSTANCE.getXmlManagedType_ClassName(), 1);
    }

    public ReplaceEdit createRenameTypeEdit(IType originalType, String newName) {
        String originalName = originalType.getTypeQualifiedName();
        int nameIndex = this.className.lastIndexOf(originalName);
        int offset = this.getAttributeNode("class").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset + nameIndex, originalName.length(), newName);
    }

    public ReplaceEdit createRenamePackageEdit(String newPackageName) {
        int packageLength = this.className.lastIndexOf(46);
        if (newPackageName == "") {
            ++packageLength;
        }
        if (packageLength == -1) {
            packageLength = 0;
            newPackageName = String.valueOf(newPackageName) + '.';
        }
        int offset = this.getAttributeNode("class").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset, packageLength, newPackageName);
    }

    protected TextRange getClassNameCodeAssistTextRange() {
        return this.getAttributeCodeAssistTextRange("class");
    }

    public boolean classNameTouches(int pos) {
        TextRange textRange = this.getClassNameCodeAssistTextRange();
        return textRange != null && textRange.touches(pos);
    }
}

