/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.SimpleJavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleMethodSignature
implements MethodSignature,
Cloneable,
Serializable {
    private final String name;
    private final JavaType[] parameterTypes;
    public static final JavaType[] EMPTY_PARAMETER_TYPES = new JavaType[0];
    private static final String PARAMETER_SEPARATOR = ", ";
    private static final long serialVersionUID = 1L;

    public SimpleMethodSignature(String name) {
        this(name, EMPTY_PARAMETER_TYPES);
    }

    public SimpleMethodSignature(String name, JavaType ... parameterTypes) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name is required.");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("The parameter types are required.");
        }
        SimpleMethodSignature.checkParameterTypes(parameterTypes);
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    private static void checkParameterTypes(JavaType[] parameterTypes) {
        int i = 0;
        while (i < parameterTypes.length) {
            if (parameterTypes[i] == null) {
                throw new IllegalArgumentException("Missing parameter type: " + i);
            }
            if (parameterTypes[i].getElementTypeName().equals(Void.TYPE.getName())) {
                throw new IllegalArgumentException("A parameter type of 'void' is not allowed: " + i);
            }
            ++i;
        }
    }

    public SimpleMethodSignature(String name, String ... parameterTypeNames) {
        this(name, SimpleMethodSignature.buildParameterTypes(parameterTypeNames));
    }

    private static JavaType[] buildParameterTypes(String[] parameterTypeNames) {
        if (parameterTypeNames == null) {
            throw new IllegalArgumentException("The parameter type names are required.");
        }
        JavaType[] parameterTypes = new JavaType[parameterTypeNames.length];
        int i = 0;
        while (i < parameterTypeNames.length) {
            if (parameterTypeNames[i] == null) {
                throw new IllegalArgumentException("Missing parameter type name: " + i);
            }
            parameterTypes[i] = new SimpleJavaType(parameterTypeNames[i]);
            ++i;
        }
        return parameterTypes;
    }

    public SimpleMethodSignature(String name, Class<?> ... parameterJavaClasses) {
        this(name, SimpleMethodSignature.buildParameterTypeNames(parameterJavaClasses));
    }

    private static String[] buildParameterTypeNames(Class<?>[] parameterJavaClasses) {
        if (parameterJavaClasses == null) {
            throw new IllegalArgumentException("The parameter Java classes are required.");
        }
        String[] parameterTypeNames = new String[parameterJavaClasses.length];
        int i = 0;
        while (i < parameterJavaClasses.length) {
            if (parameterJavaClasses[i] == null) {
                throw new IllegalArgumentException("Missing parameter Java class: " + i);
            }
            parameterTypeNames[i] = parameterJavaClasses[i].getName();
            ++i;
        }
        return parameterTypeNames;
    }

    public SimpleMethodSignature(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JavaType[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean describes(Method method) {
        return this.name.equals(method.getName()) && this.parameterTypesDescribe(method.getParameterTypes());
    }

    private boolean parameterTypesDescribe(Class<?>[] otherParameterTypes) {
        JavaType[] localParameterTypes = this.parameterTypes;
        int len = localParameterTypes.length;
        if (otherParameterTypes.length != len) {
            return false;
        }
        int i = len;
        while (i-- > 0) {
            if (localParameterTypes[i].describes(otherParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(String otherName, JavaType[] otherParameterTypes) {
        return this.name.equals(otherName) && Arrays.equals(this.parameterTypes, otherParameterTypes);
    }

    @Override
    public boolean equals(MethodSignature other) {
        return this.equals(other.getName(), other.getParameterTypes());
    }

    public boolean equals(Object o) {
        return this == o ? true : (o instanceof MethodSignature ? this.equals((MethodSignature)o) : false);
    }

    public int hashCode() {
        return this.name.hashCode() ^ Arrays.hashCode(this.parameterTypes);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(200);
        this.appendSignatureTo(sb);
        return sb.toString();
    }

    @Override
    public void appendSignatureTo(StringBuilder sb) {
        sb.append(this.name);
        sb.append('(');
        if (this.parameterTypes.length > 0) {
            JavaType[] javaTypeArray = this.parameterTypes;
            int n = this.parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                JavaType parameterType = javaTypeArray[n2];
                parameterType.appendDeclarationTo(sb);
                sb.append(PARAMETER_SEPARATOR);
                ++n2;
            }
            sb.setLength(sb.length() - PARAMETER_SEPARATOR.length());
        }
        sb.append(')');
    }

    @Override
    public void printSignatureOn(PrintWriter pw) {
        pw.print(this.name);
        pw.print('(');
        JavaType[] localParameterTypes = this.parameterTypes;
        int len = localParameterTypes.length;
        int i = 0;
        while (i < len) {
            if (i != 0) {
                pw.print(PARAMETER_SEPARATOR);
            }
            localParameterTypes[i].printDeclarationOn(pw);
            ++i;
        }
        pw.print(')');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        this.appendSignatureTo(sb);
        sb.append(')');
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

