/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.prefs;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.prefs.PreferencePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesCollectionValueModel<P>
extends AspectAdapter<Preferences, Object>
implements CollectionValueModel<PreferencePropertyValueModel<P>> {
    protected final HashMap<String, PreferencePropertyValueModel<P>> preferenceModels = new HashMap();
    protected final PreferenceChangeListener preferenceChangeListener;
    protected final Adapter<P> adapter;

    public PreferencesCollectionValueModel(Preferences preferences, Adapter<P> adapter) {
        this(new StaticPropertyValueModel<Preferences>(preferences), adapter);
    }

    public PreferencesCollectionValueModel(PropertyValueModel<? extends Preferences> preferencesModel, Adapter<P> adapter) {
        super(preferencesModel);
        if (adapter == null) {
            throw new NullPointerException();
        }
        this.preferenceChangeListener = this.buildPreferenceChangeListener();
        this.adapter = adapter;
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new LocalPreferenceChangeListener();
    }

    @Override
    public synchronized Iterator<PreferencePropertyValueModel<P>> iterator() {
        return this.preferenceModels.values().iterator();
    }

    @Override
    public synchronized int size() {
        return this.preferenceModels.size();
    }

    @Override
    protected Object getAspectValue() {
        return this.iterator();
    }

    @Override
    protected Class<? extends EventListener> getListenerClass() {
        return CollectionChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    @Override
    protected void fireAspectChanged(Object oldValue, Object newValue) {
        Iterator iterator = (Iterator)newValue;
        this.fireCollectionChanged("values", CollectionTools.collection(iterator));
    }

    @Override
    protected void engageSubject_() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        for (PreferencePropertyValueModel<P> preferenceModel : this.getPreferenceModels()) {
            this.preferenceModels.put(preferenceModel.getKey(), preferenceModel);
        }
    }

    @Override
    protected void disengageSubject_() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Node has been removed.")) break block2;
                throw ex;
            }
        }
        this.preferenceModels.clear();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.subject);
    }

    protected Iterable<PreferencePropertyValueModel<P>> getPreferenceModels() {
        return new TransformationIterable(this.getPreferenceKeys(), new PreferenceKeyTransformer());
    }

    protected Iterable<String> getPreferenceKeys() {
        return IterableTools.iterable(this.getPreferenceKeys_());
    }

    protected String[] getPreferenceKeys_() {
        try {
            return ((Preferences)this.subject).keys();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected PreferencePropertyValueModel<P> buildPreferenceModel(String key) {
        return this.adapter.buildPreferenceModel(this.subjectModel, key);
    }

    protected synchronized void preferenceChanged(String key, String newValue) {
        if (newValue == null) {
            PreferencePropertyValueModel<P> preferenceModel = this.preferenceModels.remove(key);
            this.fireItemRemoved("values", preferenceModel);
        } else if (!this.preferenceModels.containsKey(key)) {
            PreferencePropertyValueModel<P> preferenceModel = this.buildPreferenceModel(key);
            this.preferenceModels.put(key, preferenceModel);
            this.fireItemAdded("values", preferenceModel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter<P> {
        public PreferencePropertyValueModel<P> buildPreferenceModel(PropertyValueModel<? extends Preferences> var1, String var2);
    }

    protected class LocalPreferenceChangeListener
    implements PreferenceChangeListener {
        protected LocalPreferenceChangeListener() {
        }

        public void preferenceChange(PreferenceChangeEvent event) {
            PreferencesCollectionValueModel.this.preferenceChanged(event.getKey(), event.getNewValue());
        }

        public String toString() {
            return ObjectTools.toString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PreferenceKeyTransformer
    extends TransformerAdapter<String, PreferencePropertyValueModel<P>> {
        protected PreferenceKeyTransformer() {
        }

        @Override
        public PreferencePropertyValueModel<P> transform(String key) {
            return PreferencesCollectionValueModel.this.buildPreferenceModel(key);
        }
    }
}

