/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.gen.internal.Association;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.AssociationFigure;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TableAssociationsWizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationsListComposite
extends FigureCanvas {
    List<Association> associations;
    AssociationToggleSelectionListener listener;
    TableAssociationsWizardPage tableAssociationsWizardPage;
    AssociationFigure selectedAssociationFigure;
    private final DisposeListener disposeListener;
    protected final ResourceManager resourceManager;

    public AssociationsListComposite(Composite parent, TableAssociationsWizardPage tableAssociationsWizardPage, ResourceManager resourceManager) {
        super(parent);
        this.tableAssociationsWizardPage = tableAssociationsWizardPage;
        this.resourceManager = resourceManager;
        this.setBounds(10, 10, 500, 200);
        Color backgroundColor = new Color((Device)this.getDisplay(), 255, 255, 255);
        this.setBackground(backgroundColor);
        backgroundColor.dispose();
        Figure figure = new Figure();
        figure.setLayoutManager((LayoutManager)new ToolbarLayout());
        figure.setBorder((Border)new LineBorder(1));
        this.listener = new AssociationToggleSelectionListener();
        this.disposeListener = new ControlDisposeListener();
        this.addDisposeListener(this.disposeListener);
        this.setContents((IFigure)figure);
    }

    public void updateAssociations(List<Association> associations) {
        Figure figure = (Figure)this.getContents();
        this.disposeFigure(figure);
        this.associations = associations;
        if (associations != null) {
            int i = 0;
            while (i < associations.size()) {
                Association association = associations.get(i);
                AssociationFigure assocFigure = new AssociationFigure(association, this.resourceManager);
                assocFigure.addActionListener(this.listener);
                figure.add((IFigure)assocFigure);
                ++i;
            }
        }
    }

    public Association getSelectedAssociation() {
        return this.selectedAssociationFigure.getAssociation();
    }

    public void updateSelectedAssociation() {
        Figure figure = (Figure)this.getContents();
        List associationFigures = figure.getChildren();
        for (AssociationFigure assocFig : associationFigures) {
            if (assocFig != this.selectedAssociationFigure) continue;
            assocFig.update();
        }
    }

    public Association getPreviousAssociation() {
        Figure figure = (Figure)this.getContents();
        List associationFigures = figure.getChildren();
        AssociationFigure ret = null;
        for (AssociationFigure assocFig : associationFigures) {
            if (assocFig.isSelected()) break;
            ret = assocFig;
        }
        return ret == null ? null : ret.getAssociation();
    }

    protected void controlDisposed() {
        this.disposeFigure((Figure)this.getContents());
        this.removeDisposeListener(this.disposeListener);
    }

    protected void disposeFigure(Figure figure) {
        for (AssociationFigure associationFigure : figure.getChildren()) {
            associationFigure.removeActionListener(this.listener);
            associationFigure.dispose();
        }
        figure.removeAll();
        this.selectedAssociationFigure = null;
    }

    class AssociationToggleSelectionListener
    implements ActionListener {
        AssociationToggleSelectionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            AssociationFigure figure = (AssociationFigure)((Object)event.getSource());
            figure.setSelected(true);
            Association association = figure.getAssociation();
            AssociationsListComposite.this.tableAssociationsWizardPage.updateAssociationEditPanel(association);
            if (AssociationsListComposite.this.selectedAssociationFigure != null && AssociationsListComposite.this.selectedAssociationFigure != figure) {
                AssociationsListComposite.this.selectedAssociationFigure.setSelected(false);
            }
            AssociationsListComposite.this.selectedAssociationFigure = figure;
            AssociationsListComposite.this.selectedAssociationFigure.setSelected(true);
        }
    }

    private class ControlDisposeListener
    implements DisposeListener {
        private ControlDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            AssociationsListComposite.this.controlDisposed();
        }

        public String toString() {
            return "control dispose listener";
        }
    }
}

