/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlInverseReferenceAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java.ELJaxbJavaResourceModelTestCase;

public class XmlInverseReferenceAnnotationTests
extends ELJaxbJavaResourceModelTestCase {
    public XmlInverseReferenceAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlInverseReference() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlInverseReference"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlInverseReference");
            }
        });
    }

    private ICompilationUnit createTestXmlInverseReferenceWithMappedBy() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlInverseReference"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlInverseReference(mappedBy = \"foo\")");
            }
        });
    }

    private XmlInverseReferenceAnnotation getXmlInverseReferenceAnnotation(JavaResourceAttribute resourceAttribute) {
        return (XmlInverseReferenceAnnotation)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlInverseReference");
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlInverseReference();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlInverseReferenceAnnotation annotation = this.getXmlInverseReferenceAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlInverseReferenceAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlInverseReferenceAnnotationTests.assertNull((Object)annotation.getMappedBy());
    }

    public void testGetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestXmlInverseReferenceWithMappedBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlInverseReferenceAnnotation annotation = this.getXmlInverseReferenceAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlInverseReferenceAnnotationTests.assertEquals((String)"foo", (String)annotation.getMappedBy());
    }

    public void testSetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestXmlInverseReference();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlInverseReferenceAnnotation annotation = this.getXmlInverseReferenceAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlInverseReferenceAnnotationTests.assertNull((Object)annotation.getMappedBy());
        annotation.setMappedBy("bar");
        XmlInverseReferenceAnnotationTests.assertEquals((String)"bar", (String)annotation.getMappedBy());
        this.assertSourceContains("@XmlInverseReference(mappedBy = \"bar\")", cu);
        annotation.setMappedBy("");
        XmlInverseReferenceAnnotationTests.assertEquals((String)"", (String)annotation.getMappedBy());
        this.assertSourceContains("@XmlInverseReference(mappedBy = \"\")", cu);
        annotation.setMappedBy(null);
        XmlInverseReferenceAnnotationTests.assertNull((Object)annotation.getMappedBy());
        this.assertSourceContains("@XmlInverseReference", cu);
        this.assertSourceDoesNotContain("mappedBy", cu);
    }
}

