/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlDerivedId_2_0;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToOneMapping2_0;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0OrmOneToOneMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0OrmOneToOneMappingTests(String name) {
        super(name);
    }

    private void createTestEntityWithIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @Id").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private void createTestEntityWithOneToOneMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, orphanRemoval = true, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    @PrivateOwned)");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestTypeWithOneToOneAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("    private Foo oneToOne;").append(CR);
            }
        });
    }

    public void testUpdateDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.FALSE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.TRUE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(null);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("bar");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId(null);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("bar");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName(null);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute contextAttribute = (OrmSpecifiedPersistentAttribute)contextType.getAttributeNamed("oneToOne");
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        resourceOneToOne.setMapsId("foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceOneToOne.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("manyToOne");
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceManyToOne.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceManyToOne.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("oneToOne");
        resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getId());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)resourceOneToOne.getMapsId());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "oneToOne");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "oneToOne");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private OrphanRemovable2_0 getOrphanRemovalOf(OneToOneMapping2_0 oneToOneMapping) {
        return oneToOneMapping.getOrphanRemoval();
    }

    public void testUpdateSpecifiedOrphanRemoval() throws Exception {
        this.createTestTypeWithOneToOneAttribute();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToOne"), "oneToOne");
        OneToOneMapping2_0 ormOneToOneMapping = (OneToOneMapping2_0)ormPersistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(ormOneToOneMapping);
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)oneToOneResource.getOrphanRemoval());
        oneToOneResource.setOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOrphanRemoval());
        oneToOneResource.setOrphanRemoval(Boolean.FALSE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOrphanRemoval());
    }

    public void testModifySpecifiedOrphanRemoval() throws Exception {
        this.createTestTypeWithOneToOneAttribute();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToOne"), "oneToOne");
        OneToOneMapping2_0 ormOneToOneMapping = (OneToOneMapping2_0)ormPersistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(ormOneToOneMapping);
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)oneToOneResource.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.FALSE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOrphanRemoval());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        OneToOneMapping2_0 javaOneToOneMapping = (OneToOneMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        OneToOneMapping2_0 virtualOneToOneMapping = (OneToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).setStrategyToJoinTable();
        SpecifiedJoinTable virtualJoinTable = ((OneToOneRelationship2_0)virtualOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (String)virtualJoinTable.getSpecifiedName());
        this.createTestTargetEntityAddress();
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinTable.getName());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)virtualJoinTable.getSpecifiedCatalog());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)virtualJoinTable.getSpecifiedSchema());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)0, (int)virtualJoinTable.getSpecifiedJoinColumnsSize());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)0, (int)virtualJoinTable.getSpecifiedInverseJoinColumnsSize());
        SpecifiedJoinColumn virtualJoinColumn = virtualJoinTable.getDefaultJoinColumn();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinColumn.getDefaultTableName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_id", (String)virtualJoinColumn.getDefaultName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)virtualJoinColumn.getDefaultReferencedColumnName());
        SpecifiedJoinColumn virtualInverseOrmJoinColumn = virtualJoinTable.getDefaultInverseJoinColumn();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)virtualInverseOrmJoinColumn.getDefaultTableName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"address_id", (String)virtualInverseOrmJoinColumn.getDefaultName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"id", (String)virtualInverseOrmJoinColumn.getDefaultReferencedColumnName());
        JavaSpecifiedJoinTable javaJoinTable = ((JavaOneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaSpecifiedJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaSpecifiedJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)virtualJoinTable.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"CATALOG", (String)virtualJoinTable.getSpecifiedCatalog());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"SCHEMA", (String)virtualJoinTable.getSpecifiedSchema());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)1, (int)virtualJoinTable.getSpecifiedJoinColumnsSize());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)1, (int)virtualJoinTable.getSpecifiedInverseJoinColumnsSize());
        virtualJoinColumn = (SpecifiedJoinColumn)virtualJoinTable.getSpecifiedJoinColumns().iterator().next();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"NAME", (String)virtualJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"REFERENCED_NAME", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
        virtualInverseOrmJoinColumn = (SpecifiedJoinColumn)virtualJoinTable.getSpecifiedInverseJoinColumns().iterator().next();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"INVERSE_NAME", (String)virtualInverseOrmJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)virtualInverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "oneToOne");
        OneToOneMapping2_0 ormOneToOneMapping = (OneToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((OneToOneRelationship2_0)ormOneToOneMapping.getRelationship()).setStrategyToJoinTable();
        OrmSpecifiedJoinTable ormJoinTable = ((OrmOneToOneRelationship2_0)ormOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTestTargetEntityAddress();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        OneToOneMapping2_0 javaOneToOneMapping = (OneToOneMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("address").getMapping();
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).setStrategyToJoinTable();
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.removeFromXml();
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("address");
        OneToOneMapping2_0 virtualOneToOneMapping = (OneToOneMapping2_0)ormPersistentAttribute2.getMapping();
        SpecifiedJoinTable virtualJoinTable = ((OneToOneRelationship2_0)virtualOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)ormPersistentAttribute2.isVirtual());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)virtualJoinTable.getSpecifiedName());
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).getJoinTableStrategy().removeStrategy();
        virtualJoinTable = ((OneToOneRelationship2_0)virtualOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)virtualJoinTable);
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).setStrategyToJoinTable();
        virtualJoinTable = ((OneToOneRelationship2_0)virtualOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"BAR_FOO", (String)virtualJoinTable.getName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"BAR_FOO", (String)virtualJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)virtualJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)virtualJoinTable.getDefaultName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        OrmOneToOneRelationship2_0 rel = (OrmOneToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToMappedBy();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToPrimaryKeyJoinColumn();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        OrmOneToOneRelationship2_0 rel = (OrmOneToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getPrimaryKeyJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EclipseLinkOneToOneMapping2_0 virtualOneToOneMapping = (EclipseLinkOneToOneMapping2_0)virtualPersistentAttribute.getMapping();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"address", (String)virtualOneToOneMapping.getName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)virtualOneToOneMapping.getSpecifiedFetch());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualOneToOneMapping.getSpecifiedOptional());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"Address", (String)virtualOneToOneMapping.getSpecifiedTargetEntity());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)virtualOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        SpecifiedJoinColumn ormJoinColumn = (SpecifiedJoinColumn)virtualOneToOneMapping.getRelationship().getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)ormJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormJoinColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"MY_TABLE", (String)ormJoinColumn.getSpecifiedTableName());
        Cascade2_0 cascade = virtualOneToOneMapping.getCascade();
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)cascade.isDetach());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)virtualOneToOneMapping.getJoinFetch().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)virtualOneToOneMapping.getPrivateOwned().isPrivateOwned());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)virtualOneToOneMapping.getOrphanRemoval().isOrphanRemoval());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)virtualPersistentAttribute.getMappingKey());
        EclipseLink2_0OrmOneToOneMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        EclipseLinkOneToOneMapping2_0 ormOneToOneMapping = (EclipseLinkOneToOneMapping2_0)virtualPersistentAttribute.getMapping();
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals((String)"test.Address", (String)ormOneToOneMapping.getTargetEntity());
        EclipseLink2_0OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade2_0 cascade = ormOneToOneMapping.getCascade();
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)cascade.isDetach());
        EclipseLink2_0OrmOneToOneMappingTests.assertEquals(null, (Object)ormOneToOneMapping.getJoinFetch().getValue());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)ormOneToOneMapping.getPrivateOwned().isPrivateOwned());
        EclipseLink2_0OrmOneToOneMappingTests.assertFalse((boolean)ormOneToOneMapping.getOrphanRemoval().isOrphanRemoval());
    }
}

