/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.context.JpaContextModelRoot;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationOperation;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.tests.internal.projects.TestJpaProject;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class ContextModelTestCase
extends AnnotationTestCase {
    protected static final String BASE_PROJECT_NAME = "ContextModelTestProject";
    protected JptXmlResource persistenceXmlResource;
    protected JptXmlResource ormXmlResource;

    protected ContextModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.persistenceXmlResource = this.getJpaProject().getPersistenceXmlResource();
        this.ormXmlResource = this.getJpaProject().getDefaultOrmXmlResource();
        this.waitForWorkspaceJobsToFinish();
    }

    protected void tearDown() throws Exception {
        this.persistenceXmlResource = null;
        this.ormXmlResource = null;
        JpaPreferences.removePreferences();
        this.waitForWorkspaceJobsToFinish();
        super.tearDown();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return this.buildJpaProject(BASE_PROJECT_NAME, autoBuild, this.buildJpaConfigDataModel());
    }

    protected TestJpaProject buildJpaProject(String projectName, boolean autoBuild, IDataModel jpaConfig) throws Exception {
        TestJpaProject testJpaProject = TestJpaProject.buildJpaProject(projectName, autoBuild, jpaConfig);
        if (this.createOrmXml()) {
            OrmFileCreationOperation operation = new OrmFileCreationOperation(this.buildGenericOrmConfig(testJpaProject));
            operation.execute(null, null);
        }
        return testJpaProject;
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
        dataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)this.getJpaFacetVersionString());
        dataModel.setProperty("JpaFacetDataModelProperties.PLATFORM", (Object)this.getJpaPlatformConfig());
        return dataModel;
    }

    protected IDataModel buildGenericOrmConfig(TestJpaProject testJpaProject) {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)testJpaProject.getProject().getFolder("src/META-INF").getFullPath());
        return config;
    }

    protected String getJpaFacetVersionString() {
        return "1.0";
    }

    protected final JpaPlatform.Config getJpaPlatformConfig() {
        return this.getJpaPlatformManager().getJpaPlatformConfig(this.getJpaPlatformID());
    }

    protected String getJpaPlatformID() {
        return "generic";
    }

    protected JpaPlatformManager getJpaPlatformManager() {
        return this.getJpaWorkspace().getJpaPlatformManager();
    }

    protected JpaWorkspace getJpaWorkspace() {
        return (JpaWorkspace)ResourcesPlugin.getWorkspace().getAdapter(JpaWorkspace.class);
    }

    protected boolean createOrmXml() {
        return true;
    }

    protected JpaProject getJpaProject() {
        return this.getJavaProject().getJpaProject();
    }

    protected void waitForWorkspaceJobsToFinish() throws InterruptedException {
        Job waitJob = new Job("Wait job"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        waitJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        waitJob.schedule();
        waitJob.join();
    }

    protected JptXmlResource getPersistenceXmlResource() {
        return this.persistenceXmlResource;
    }

    protected JptXmlResource getOrmXmlResource() {
        return this.ormXmlResource;
    }

    protected void saveXmlFiles() {
        try {
            this.saveXmlFiles_();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void saveXmlFiles_() throws Exception {
        this.persistenceXmlResource.saveIfNecessary();
        this.ormXmlResource.saveIfNecessary();
    }

    protected XmlEntityMappings getXmlEntityMappings() {
        return (XmlEntityMappings)this.getOrmXmlResource().getRootObject();
    }

    protected XmlPersistence getXmlPersistence() {
        return (XmlPersistence)this.getPersistenceXmlResource().getRootObject();
    }

    protected MappingFile getMappingFile() {
        return ((MappingFileRef)this.getPersistenceUnit().getMappingFileRefs().iterator().next()).getMappingFile();
    }

    protected EntityMappings getEntityMappings() {
        MappingFile mappingFile = this.getMappingFile();
        return mappingFile == null ? null : (EntityMappings)mappingFile.getRoot();
    }

    protected XmlPersistenceUnit getXmlPersistenceUnit() {
        return (XmlPersistenceUnit)this.getXmlPersistence().getPersistenceUnits().get(0);
    }

    protected PersistenceUnit getPersistenceUnit() {
        return (PersistenceUnit)this.getContextModelRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
    }

    protected ClassRef getSpecifiedClassRef() {
        return (ClassRef)this.getPersistenceUnit().getSpecifiedClassRefs().iterator().next();
    }

    protected JavaPersistentType getJavaPersistentType() {
        return this.getSpecifiedClassRef().getJavaPersistentType();
    }

    protected JavaEntity getJavaEntity() {
        return (JavaEntity)this.getJavaPersistentType().getMapping();
    }

    protected void addXmlClassRef(String className) {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass(className);
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
    }

    protected void removeXmlClassRef(String className) {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlJavaClassRef xmlJavaClassRefToRemove = null;
        for (XmlJavaClassRef xmlJavaClassRef : xmlPersistenceUnit.getClasses()) {
            if (!xmlJavaClassRef.getJavaClass().equals(className)) continue;
            xmlJavaClassRefToRemove = xmlJavaClassRef;
        }
        if (xmlJavaClassRefToRemove == null) {
            throw new IllegalArgumentException();
        }
        xmlPersistenceUnit.getClasses().remove(xmlJavaClassRefToRemove);
    }

    protected void addXmlMappingFileRef(String fileName) {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName(fileName);
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
    }

    protected JpaContextModelRoot getContextModelRoot() {
        return this.getJavaProject().getJpaProject().getContextModelRoot();
    }

    protected TestJpaProject getJavaProject() {
        return (TestJpaProject)super.getJavaProject();
    }

    protected void deleteResource(Resource resource) throws CoreException {
        WorkbenchResourceHelper.deleteResource((Resource)resource);
    }
}

