/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTransientMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTransient;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmTransientMappingTests
extends ContextModelTestCase {
    public OrmTransientMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityTransientMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Transient"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transient");
            }
        });
    }

    public void testUpdateName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        OrmTransientMapping xmlTransientMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        XmlTransient transientResource = (XmlTransient)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getTransients().get(0);
        OrmTransientMappingTests.assertEquals((String)"id", (String)xmlTransientMapping.getName());
        OrmTransientMappingTests.assertEquals((String)"id", (String)transientResource.getName());
        transientResource.setName("newName");
        OrmTransientMappingTests.assertEquals((String)"newName", (String)xmlTransientMapping.getName());
        OrmTransientMappingTests.assertEquals((String)"newName", (String)transientResource.getName());
        transientResource.setName(null);
        OrmTransientMappingTests.assertNull((Object)xmlTransientMapping.getName());
        OrmTransientMappingTests.assertNull((Object)transientResource.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        OrmTransientMapping xmlTransientnMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        XmlTransient transientResource = (XmlTransient)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getTransients().get(0);
        OrmTransientMappingTests.assertEquals((String)"id", (String)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertEquals((String)"id", (String)transientResource.getName());
        xmlTransientnMapping.setName("newName");
        OrmTransientMappingTests.assertEquals((String)"newName", (String)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertEquals((String)"newName", (String)transientResource.getName());
        xmlTransientnMapping.setName(null);
        OrmTransientMappingTests.assertNull((Object)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertNull((Object)transientResource.getName());
    }

    public void testTransientMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmTransientMapping ormTransientMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        ormTransientMapping.setName("foo");
        OrmTransientMappingTests.assertEquals((String)"foo", (String)ormTransientMapping.getName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmTransientMappingTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertEquals((String)"id", (String)transientMapping.getName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmTransientMappingTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmTransientMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        OrmTransientMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.addToXml("transient");
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmTransientMapping ormTransientMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormTransientMapping.getName());
        OrmTransientMappingTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmTransientMapping ormTransientMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormTransientMapping.getName());
    }

    public void testTransientMorphToIdMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToVersionMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToTransientMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToOneToOneMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToOneToManyMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToManyToOneMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToManyToManyMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }
}

