/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class SequenceGeneratorTests
extends JpaJavaResourceModelTestCase {
    private static final String GENERATOR_NAME = "MY_GENERATOR";
    private static final String GENERATOR_SEQUENCE_NAME = "MY_SEQUENCE";
    private static final Integer GENERATOR_ALLOCATION_SIZE = 5;
    private static final Integer GENERATOR_INITIAL_VALUE = 5;

    public SequenceGeneratorTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestSequenceGeneratorOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SequenceGenerator"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@SequenceGenerator");
            }
        });
    }

    private ICompilationUnit createTestSequenceGeneratorOnType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SequenceGenerator"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SequenceGenerator");
            }
        });
    }

    private ICompilationUnit createTestSequenceGeneratorWithName() throws Exception {
        return this.createTestSequenceGeneratorWithStringElement("name", GENERATOR_NAME);
    }

    private ICompilationUnit createTestSequenceGeneratorWithSequenceName() throws Exception {
        return this.createTestSequenceGeneratorWithStringElement("sequenceName", GENERATOR_SEQUENCE_NAME);
    }

    protected ICompilationUnit createTestSequenceGeneratorWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SequenceGenerator"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@SequenceGenerator(" + elementName + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestSequenceGeneratorWithAllocationSize() throws Exception {
        return this.createTestSequenceGeneratorWithIntElement("allocationSize", GENERATOR_ALLOCATION_SIZE);
    }

    private ICompilationUnit createTestSequenceGeneratorWithInitialValue() throws Exception {
        return this.createTestSequenceGeneratorWithIntElement("initialValue", GENERATOR_INITIAL_VALUE);
    }

    private ICompilationUnit createTestSequenceGeneratorWithIntElement(final String elementName, final int value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SequenceGenerator"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@SequenceGenerator(" + elementName + " = " + value + ")");
            }
        });
    }

    public void testSequenceGeneratorOnField() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertNotNull((Object)sequenceGenerator);
    }

    public void testSequenceGeneratorOnType() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorOnType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceType.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertNotNull((Object)sequenceGenerator);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertEquals((String)GENERATOR_NAME, (String)sequenceGenerator.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertEquals((String)GENERATOR_NAME, (String)sequenceGenerator.getName());
        sequenceGenerator.setName("foo");
        SequenceGeneratorTests.assertEquals((String)"foo", (String)sequenceGenerator.getName());
        this.assertSourceContains("@SequenceGenerator(name = \"foo\")", cu);
        sequenceGenerator.setName(null);
        SequenceGeneratorTests.assertNull((Object)sequenceGenerator.getName());
        this.assertSourceDoesNotContain("@SequenceGenerator(", cu);
    }

    public void testGetSequenceName() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithSequenceName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertEquals((String)GENERATOR_SEQUENCE_NAME, (String)sequenceGenerator.getSequenceName());
    }

    public void testSetSequenceName() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithSequenceName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertEquals((String)GENERATOR_SEQUENCE_NAME, (String)sequenceGenerator.getSequenceName());
        sequenceGenerator.setSequenceName("foo");
        SequenceGeneratorTests.assertEquals((String)"foo", (String)sequenceGenerator.getSequenceName());
        this.assertSourceContains("@SequenceGenerator(sequenceName = \"foo\")", cu);
        sequenceGenerator.setSequenceName(null);
        SequenceGeneratorTests.assertNull((Object)sequenceGenerator.getSequenceName());
        this.assertSourceDoesNotContain("@SequenceGenerator(", cu);
    }

    public void testGetAllocationSize() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithAllocationSize();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertEquals((Object)GENERATOR_ALLOCATION_SIZE, (Object)sequenceGenerator.getAllocationSize());
    }

    public void testSetAllocationSize() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithAllocationSize();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertEquals((Object)GENERATOR_ALLOCATION_SIZE, (Object)sequenceGenerator.getAllocationSize());
        sequenceGenerator.setAllocationSize(Integer.valueOf(500));
        SequenceGeneratorTests.assertEquals((Object)500, (Object)sequenceGenerator.getAllocationSize());
        this.assertSourceContains("@SequenceGenerator(allocationSize = 500)", cu);
        sequenceGenerator.setAllocationSize(null);
        this.assertSourceDoesNotContain("@SequenceGenerator(", cu);
        sequenceGenerator.setAllocationSize(Integer.valueOf(0));
        this.assertSourceContains("@SequenceGenerator(allocationSize = 0)", cu);
    }

    public void testGetInitialValue() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithInitialValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertEquals((Object)GENERATOR_INITIAL_VALUE, (Object)sequenceGenerator.getInitialValue());
    }

    public void testSetInitialValue() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithInitialValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGeneratorTests.assertEquals((Object)GENERATOR_INITIAL_VALUE, (Object)sequenceGenerator.getInitialValue());
        sequenceGenerator.setInitialValue(Integer.valueOf(500));
        SequenceGeneratorTests.assertEquals((Object)500, (Object)sequenceGenerator.getInitialValue());
        this.assertSourceContains("@SequenceGenerator(initialValue = 500)", cu);
        sequenceGenerator.setInitialValue(null);
        this.assertSourceDoesNotContain("@SequenceGenerator(", cu);
        sequenceGenerator.setInitialValue(Integer.valueOf(0));
        this.assertSourceContains("@SequenceGenerator(initialValue = 0)", cu);
    }
}

