/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.tests.internal.JaxbTestCase;

public abstract class JaxbContextModelTestCase
extends JaxbTestCase {
    protected static final String BASE_PROJECT_NAME = "JaxbContextModelTestProject";

    protected JaxbContextModelTestCase(String name) {
        super(name);
    }

    @Override
    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return this.buildJaxbProject(BASE_PROJECT_NAME, autoBuild, this.buildJaxbFacetInstallConfig());
    }

    protected JaxbContextRoot getContextRoot() {
        return this.getJaxbProject().getContextRoot();
    }

    protected AnnotatedElement annotatedElement(JavaResourceAnnotatedElement resource) {
        return (AnnotatedElement)ObjectTools.get((Object)resource, (String)"annotatedElement");
    }

    protected ICompilationUnit createUnannotatedPackageInfo(String packageName) throws CoreException {
        return this.createTestPackageInfo(packageName);
    }

    protected ICompilationUnit createClassWithXmlType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }
        });
    }

    protected ICompilationUnit createClassWithXmlRegistry() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlRegistry"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlRegistry");
            }
        });
    }

    protected ICompilationUnit createUnannotatedClassNamed(String typeName) throws Exception {
        return this.createTestType("test", String.valueOf(typeName) + ".java", typeName, (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter());
    }

    protected ICompilationUnit createEnumWithXmlType() throws Exception {
        return this.createTestEnum((AnnotationTestCase.EnumAnnotationWriter)new AnnotationTestCase.DefaultEnumAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendEnumAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }
        });
    }

    protected ICompilationUnit createUnannotatedEnumNamed(String enumName) throws Exception {
        return this.createTestEnum("test", String.valueOf(enumName) + ".java", enumName, (AnnotationTestCase.EnumAnnotationWriter)new AnnotationTestCase.DefaultEnumAnnotationWriter());
    }
}

