/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlAccessorTypeTypeAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlAccessorTypeTypeAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlAccessorType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAccessorType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAccessorType");
            }
        });
    }

    private ICompilationUnit createTestXmlAccessorTypeWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAccessorType(value = XmlAccessType.FIELD)");
            }
        });
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlAccessorType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlAccessorTypeAnnotation xmlAccessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        XmlAccessorTypeTypeAnnotationTests.assertTrue((xmlAccessorTypeAnnotation != null ? 1 : 0) != 0);
        XmlAccessorTypeTypeAnnotationTests.assertNull((Object)xmlAccessorTypeAnnotation.getValue());
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlAccessorTypeWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlAccessorTypeAnnotation xmlAccessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        XmlAccessorTypeTypeAnnotationTests.assertEquals((Object)XmlAccessType.FIELD, (Object)xmlAccessorTypeAnnotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlAccessorType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlAccessorTypeAnnotation xmlAccessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        XmlAccessorTypeTypeAnnotationTests.assertEquals(null, (Object)xmlAccessorTypeAnnotation.getValue());
        xmlAccessorTypeAnnotation.setValue(XmlAccessType.PUBLIC_MEMBER);
        XmlAccessorTypeTypeAnnotationTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)xmlAccessorTypeAnnotation.getValue());
        this.assertSourceContains("@XmlAccessorType(PUBLIC_MEMBER)", cu);
        xmlAccessorTypeAnnotation.setValue(XmlAccessType.PROPERTY);
        XmlAccessorTypeTypeAnnotationTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)xmlAccessorTypeAnnotation.getValue());
        this.assertSourceContains("@XmlAccessorType(PROPERTY)", cu);
        xmlAccessorTypeAnnotation.setValue(XmlAccessType.NONE);
        XmlAccessorTypeTypeAnnotationTests.assertEquals((Object)XmlAccessType.NONE, (Object)xmlAccessorTypeAnnotation.getValue());
        this.assertSourceContains("@XmlAccessorType(NONE)", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlAccessorTypeWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlAccessorTypeAnnotation xmlAccessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        XmlAccessorTypeTypeAnnotationTests.assertEquals((Object)XmlAccessType.FIELD, (Object)xmlAccessorTypeAnnotation.getValue());
        xmlAccessorTypeAnnotation.setValue(null);
        XmlAccessorTypeTypeAnnotationTests.assertNull((Object)xmlAccessorTypeAnnotation.getValue());
        this.assertSourceDoesNotContain("@XmlAccessorType(", cu);
    }
}

