/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlTypeAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_TYPE_NAME = "XmlTypeName";
    private static final String XML_TYPE_NAMESPACE = "XmlTypeNamespace";
    private static final String XML_TYPE_FACTORY_METHOD = "myFactoryMethod";
    private static final String XML_TYPE_FACTORY_CLASS = "MyFactoryClass";

    public XmlTypeAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }
        });
    }

    private ICompilationUnit createTestXmlTypeWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType(name = \"XmlTypeName\")");
            }
        });
    }

    private ICompilationUnit createTestXmlTypeWithNamespace() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType(namespace = \"XmlTypeNamespace\")");
            }
        });
    }

    private ICompilationUnit createTestXmlTypeWithFactoryMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType(factoryMethod = \"myFactoryMethod\")");
            }
        });
    }

    private ICompilationUnit createTestXmlTypeWithFactoryClass() throws Exception {
        this.createTestFactoryClass();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType(factoryClass = MyFactoryClass.class)");
            }
        });
    }

    private void createTestFactoryClass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append(XmlTypeAnnotationTests.XML_TYPE_FACTORY_CLASS).append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyFactoryClass.java", sourceWriter);
    }

    private ICompilationUnit createTestXmlTypeWithPropOrder() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType(propOrder = {\"foo\", \"bar\"})");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlTypeWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        XmlTypeAnnotationTests.assertEquals((String)XML_TYPE_NAME, (String)xmlTypeAnnotation.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getName());
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getNamespace());
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getFactoryClass());
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getFullyQualifiedFactoryClassName());
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getFactoryMethod());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getName());
        xmlTypeAnnotation.setName(XML_TYPE_NAME);
        XmlTypeAnnotationTests.assertEquals((String)XML_TYPE_NAME, (String)xmlTypeAnnotation.getName());
        this.assertSourceContains("@XmlType(name = \"XmlTypeName\")", cu);
        xmlTypeAnnotation.setName(null);
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getName());
        this.assertSourceContains("@XmlType", cu);
        this.assertSourceDoesNotContain("@XmlType(name = \"XmlTypeName\")", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlTypeWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        XmlTypeAnnotationTests.assertEquals((String)XML_TYPE_NAMESPACE, (String)xmlTypeAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getNamespace());
        xmlTypeAnnotation.setNamespace(XML_TYPE_NAMESPACE);
        XmlTypeAnnotationTests.assertEquals((String)XML_TYPE_NAMESPACE, (String)xmlTypeAnnotation.getNamespace());
        this.assertSourceContains("@XmlType(namespace = \"XmlTypeNamespace\")", cu);
        xmlTypeAnnotation.setNamespace(null);
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getNamespace());
        this.assertSourceContains("@XmlType", cu);
        this.assertSourceDoesNotContain("@XmlType(namespace = \"XmlTypeNamespace\")", cu);
    }

    public void testGetFactoryMethod() throws Exception {
        ICompilationUnit cu = this.createTestXmlTypeWithFactoryMethod();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        XmlTypeAnnotationTests.assertEquals((String)XML_TYPE_FACTORY_METHOD, (String)xmlTypeAnnotation.getFactoryMethod());
    }

    public void testSetFactoryMethod() throws Exception {
        ICompilationUnit cu = this.createTestXmlType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getFactoryMethod());
        xmlTypeAnnotation.setFactoryMethod(XML_TYPE_FACTORY_METHOD);
        XmlTypeAnnotationTests.assertEquals((String)XML_TYPE_FACTORY_METHOD, (String)xmlTypeAnnotation.getFactoryMethod());
        this.assertSourceContains("@XmlType(factoryMethod = \"myFactoryMethod\")", cu);
        xmlTypeAnnotation.setFactoryMethod(null);
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getFactoryMethod());
        this.assertSourceContains("@XmlType", cu);
        this.assertSourceDoesNotContain("@XmlType(factoryMethod = \"myFactoryMethod\")", cu);
    }

    public void testGetFactoryClass() throws Exception {
        ICompilationUnit cu = this.createTestXmlTypeWithFactoryClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        XmlTypeAnnotationTests.assertEquals((String)XML_TYPE_FACTORY_CLASS, (String)xmlTypeAnnotation.getFactoryClass());
        XmlTypeAnnotationTests.assertEquals((String)"test.MyFactoryClass", (String)xmlTypeAnnotation.getFullyQualifiedFactoryClassName());
    }

    public void testSetFactoryClass() throws Exception {
        ICompilationUnit cu = this.createTestXmlType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getFactoryClass());
        xmlTypeAnnotation.setFactoryClass(XML_TYPE_FACTORY_CLASS);
        XmlTypeAnnotationTests.assertEquals((String)XML_TYPE_FACTORY_CLASS, (String)xmlTypeAnnotation.getFactoryClass());
        this.assertSourceContains("@XmlType(factoryClass = MyFactoryClass.class", cu);
        xmlTypeAnnotation.setFactoryClass(null);
        XmlTypeAnnotationTests.assertNull((Object)xmlTypeAnnotation.getFactoryClass());
        this.assertSourceContains("@XmlType", cu);
        this.assertSourceDoesNotContain("@XmlType(factoryClass = MyFactoryClass.class", cu);
    }

    public void testGetPropOrder() throws Exception {
        ICompilationUnit cu = this.createTestXmlTypeWithPropOrder();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        ListIterator propOrder = xmlTypeAnnotation.getPropOrder().iterator();
        XmlTypeAnnotationTests.assertEquals((String)"foo", (String)((String)propOrder.next()));
        XmlTypeAnnotationTests.assertEquals((String)"bar", (String)((String)propOrder.next()));
    }

    public void testGetPropOrderSize() throws Exception {
        ICompilationUnit cu = this.createTestXmlTypeWithPropOrder();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        XmlTypeAnnotationTests.assertEquals((int)2, (int)xmlTypeAnnotation.getPropOrderSize());
    }

    public void testAddProp() throws Exception {
        ICompilationUnit cu = this.createTestXmlType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        xmlTypeAnnotation.addProp("fooo");
        xmlTypeAnnotation.addProp("barr");
        this.assertSourceContains("@XmlType(propOrder = { \"fooo\", \"barr\" })", cu);
    }

    public void testAddPropIndex() throws Exception {
        ICompilationUnit cu = this.createTestXmlType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        xmlTypeAnnotation.addProp(0, "fooo");
        xmlTypeAnnotation.addProp(0, "barr");
        xmlTypeAnnotation.addProp(1, "blah");
        this.assertSourceContains("@XmlType(propOrder = { \"barr\", \"blah\", \"fooo\" })", cu);
    }

    public void testRemoveProp() throws Exception {
        ICompilationUnit cu = this.createTestXmlTypeWithPropOrder();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        xmlTypeAnnotation.removeProp("foo");
        this.assertSourceContains("@XmlType(propOrder = \"bar\")", cu);
        xmlTypeAnnotation.removeProp("bar");
        this.assertSourceContains("@XmlType", cu);
        this.assertSourceDoesNotContain("propOrder", cu);
    }

    public void testRemovePropIndex() throws Exception {
        ICompilationUnit cu = this.createTestXmlTypeWithPropOrder();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        xmlTypeAnnotation.removeProp(0);
        this.assertSourceContains("@XmlType(propOrder = \"bar\")", cu);
        xmlTypeAnnotation.removeProp(0);
        this.assertSourceContains("@XmlType", cu);
        this.assertSourceDoesNotContain("propOrder", cu);
    }

    public void testMoveProp() throws Exception {
        ICompilationUnit cu = this.createTestXmlType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        XmlTypeAnnotationTests.assertTrue((xmlTypeAnnotation != null ? 1 : 0) != 0);
        xmlTypeAnnotation.addProp("fooo");
        xmlTypeAnnotation.addProp("barr");
        xmlTypeAnnotation.addProp("blah");
        this.assertSourceContains("@XmlType(propOrder = { \"fooo\", \"barr\", \"blah\" })", cu);
        xmlTypeAnnotation.moveProp(0, 1);
        this.assertSourceContains("@XmlType(propOrder = { \"barr\", \"fooo\", \"blah\" })", cu);
        xmlTypeAnnotation.moveProp(2, 1);
        this.assertSourceContains("@XmlType(propOrder = { \"barr\", \"blah\", \"fooo\" })", cu);
    }
}

