/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.base;

import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.ConfigurableTestCase;
import org.eclipse.jst.jsf.validation.el.tests.ELValidationTestPlugin;
import org.eclipse.jst.jsf.validation.el.tests.base.BaseTestCase;

public class JSPTestCase
extends BaseTestCase {
    public static final String FACES_CONFIG_FILE = "facesConfigFile";
    private MyConfiguration _myConfig;
    private final JSFVersion _defaultJSFVersion;
    private final String _defaultFacesConfigFile;

    public JSPTestCase(JSFVersion defaultJSFVersion, String defaultFacesConfigFile) {
        super(defaultJSFVersion);
        this._defaultJSFVersion = defaultJSFVersion;
        this._defaultFacesConfigFile = defaultFacesConfigFile;
    }

    protected void doStandaloneSetup() {
        super.doStandaloneSetup();
        this._myConfig = new MyConfiguration(this._defaultJSFVersion, this._defaultFacesConfigFile);
    }

    protected void doTestSuiteSetup() {
        super.doTestSuiteSetup();
        this._myConfig = new MyConfiguration(this._testConfiguration);
    }

    protected JSFFacetedTestEnvironment configureJSFEnvironment() throws Exception {
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize(this._myConfig.getFacetVersion().toString());
        this._testEnv.loadResourceInWebRoot(ELValidationTestPlugin.getDefault().getBundle(), this._myConfig.getFacesConfigFile(), "/WEB-INF/faces-config.xml");
        return jsfFacedEnv;
    }

    protected IFile loadJSP(String srcFileName, String destFileName) throws Exception {
        return (IFile)this._testEnv.loadResourceInWebRoot(ELValidationTestPlugin.getDefault().getBundle(), srcFileName, destFileName);
    }

    protected static class MyConfiguration {
        private final JSFVersion _facetVersion;
        private final String _facesConfigFile;

        MyConfiguration(JSFVersion facetVersion, String facesConfigFile) {
            this._facetVersion = facetVersion;
            this._facesConfigFile = facesConfigFile;
        }

        MyConfiguration(ConfigurableTestCase.TestConfiguration testConfiguration) {
            this._facetVersion = JSFVersion.valueOfString((String)((String)testConfiguration.get((Object)"jsfFacetVersion")));
            this._facesConfigFile = (String)testConfiguration.get((Object)JSPTestCase.FACES_CONFIG_FILE);
        }

        public JSFVersion getFacetVersion() {
            return this._facetVersion;
        }

        public String getFacesConfigFile() {
            return this._facesConfigFile;
        }
    }
}

