/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferOptions;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;

public class InferTypesTests
extends AbstractRegressionTest {
    public InferTypesTests(String name) {
        super(name);
    }

    protected InferOptions getDefaultOptions() {
        InferOptions inferOptions = new InferOptions();
        inferOptions.setDefaultOptions();
        return inferOptions;
    }

    private void verifySourceRangeWithContents(CompilationUnitDeclaration declaration, String typeName, String precursorToBodyStart, String precursorToBodyEnd) {
        InferredType testType = (InferredType)declaration.inferredTypesHash.get(typeName.toCharArray());
        InferTypesTests.assertNotNull((String)(String.valueOf(typeName) + " not found in CompilationUnitDeclaration"), (Object)testType);
        char[] contents = declaration.compilationResult.compilationUnit.getContents();
        InferTypesTests.assertNotNull((Object)contents);
        InferTypesTests.assertTrue((contents.length > 0 ? 1 : 0) != 0);
        char[] precursor = precursorToBodyStart.toCharArray();
        InferTypesTests.assertTrue((String)"precursorToBodyStart not found", (CharOperation.indexOf((char[])precursorToBodyStart.toCharArray(), (char[])contents, (boolean)true) >= 0 ? 1 : 0) != 0);
        int expectedStart = CharOperation.indexOf((char[])precursor, (char[])contents, (boolean)true) + precursor.length - 1;
        InferTypesTests.assertTrue((String)"precursorToBodyStart not unique", (CharOperation.indexOf((char[])precursor, (char[])contents, (boolean)true, (int)expectedStart, (int)(contents.length - 1)) < 0 ? 1 : 0) != 0);
        InferTypesTests.assertTrue((String)"precursorToBodyEnd not found", (CharOperation.indexOf((char[])precursorToBodyEnd.toCharArray(), (char[])contents, (boolean)true) >= 0 ? 1 : 0) != 0);
        int expectedEnd = CharOperation.indexOf((char[])precursorToBodyEnd.toCharArray(), (char[])contents, (boolean)true) + precursorToBodyEnd.length() - 1;
        InferTypesTests.assertTrue((String)"precursorToBodyEnd not unique", (CharOperation.indexOf((char[])precursorToBodyEnd.toCharArray(), (char[])contents, (boolean)true, (int)expectedEnd, (int)(contents.length - 1)) < 0 ? 1 : 0) != 0);
        InferTypesTests.assertEquals((String)("Wrong sourceStart for " + new String(testType.getName())), (int)expectedStart, (int)testType.sourceStart());
        InferTypesTests.assertEquals((String)("Wrong sourceEnd for " + new String(testType.getName())), (int)expectedEnd, (int)testType.sourceEnd());
    }

    public void test001() {
        this.runInferTest("function MyClass() {\n  this.url = \"\";\n  this.activate = function(){}\n}\nvar myClassObj = new MyClass();\n\n", "X.js", "class MyClass extends Object{\n  String url;\n  void activate()\n  MyClass()\n}\n", this.getDefaultOptions());
    }

    public void test002() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape(){}function Shape_GetArea(){ var area = 5;  return area;}", "X.js", "class Shape extends Object{\n  Number GetArea()\n  Shape()\n}\n", this.getDefaultOptions());
    }

    public void test003() {
        this.runInferTest("Shape.prototype.GetArea = function(a){};function Shape(){}\n", "X.js", "class Shape extends Object{\n  void GetArea(a)\n  Shape()\n}\n", this.getDefaultOptions());
    }

    public void test004() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape(){}function Shape_GetArea(){return this.area;}Circle.prototype = new Shape();Circle.prototype.constructor = Circle;Circle.prototype.GetArea = Circle_GetArea;function Circle_GetArea(){}", "X.js", "class Shape extends Object{\n  ?? GetArea()\n  Shape()\n}\nclass Circle extends Shape{\n  Circle constructor;\n  void GetArea()\n}\n", this.getDefaultOptions());
    }

    public void test010() {
        this.runInferTest("function Bob(firstname, lastname) {\n   this.Firstname = firstname;\n   this.Lastname = lastname;\n}\nBob.prototype.name = function () {return this.Firstname + this.Lastname;};\n", "X.js", "class Bob extends Object{\n  ?? Firstname;\n  ?? Lastname;\n  ?? name()\n  Bob(firstname, lastname)\n}\n", this.getDefaultOptions());
    }

    public void test011() {
        this.runInferTest("function X() {\n  this.h=1;\n  this.i=[];\n}\nfunction X_foo() {\n}\nX.prototype.foo=X_foo;\n", "X.js", "class X extends Object{\n  Number h;\n  Array i;\n  void foo()\n  X()\n}\n", this.getDefaultOptions());
    }

    public void test011b() {
        this.runInferTest("P.prototype=new Object();\nP.prototype.f=1;\nfunction P(){}\nfunction a(){}\nfunction m() {\n                this.f++;\n                var p= new P();\n                    a();}\nP.prototype.mm=m;\n", "X.js", "class P extends Object{\n  Number f;\n  void mm()\n  P()\n}\n", this.getDefaultOptions());
    }

    public void test012() {
        this.runInferTest("Test.prototype=new Object();\nTest.x=1;\n", "X.js", "class Test extends Object{\n  static Number x;\n}\n", this.getDefaultOptions());
    }

    public void test013() {
        this.runInferTest("function MyClass() {\n  this.arr = [1];\n}\nvar myClassObj = new MyClass();\n\n", "X.js", "class MyClass extends Object{\n  Array(Number) arr;\n  MyClass()\n}\n", this.getDefaultOptions());
    }

    public void test020() {
        this.runInferTest("var foo;\n  foo.onMouseDown = function () { return 1; };\n\n", "X.js", "class ___anonymous_foo extends Object{\n  Number onMouseDown()\n}\n", this.getDefaultOptions());
    }

    public void test040() {
        this.runInferTest("/**\n * @constructor \n */\nfunction MyClass(){}/**\n * @memberOf MyClass \n * @type String \n */\nvar s;/**\n * @memberOf MyClass \n * @type Number \n */\nfunction numValue(){};\n", "X.js", "class MyClass extends Object{\n  String s;\n  MyClass()\n  Number numValue()\n}\n", this.getDefaultOptions());
    }

    public void test041() {
        this.runInferTest(" i= { \n/**\n   * @memberOf MyClass\n   * @type Number\n */\n a: 2 ,\n/**\n   * @memberOf MyClass\n   * @type String\n */\n b: function(){}};\n", "X.js", "class MyClass extends Object{\n  Number a;\n  String b()\n}\n", this.getDefaultOptions());
    }

    public void test041a() {
        this.runInferTest(" i= { \n/**\n   * @memberOf jsns.MyClass\n   * @type jsns.Number\n */\n a: 2 ,\n/**\n   * @memberOf jsns.MyClass\n   * @type jsns.String\n */\n b: function(){}};\n", "X.js", "class jsns.MyClass extends Object{\n  jsns.Number a;\n  jsns.String b()\n}\n", this.getDefaultOptions());
    }

    public void test042() {
        this.runInferTest("/**\n * @constructor \n * @extends String \n */\nfunction MyClass(){}MyClass.prototype = { \n/**\n   * @memberOf MyClass\n   * @type Number\n */\n a: 2 ,\n/**\n   * @memberOf MyClass\n   * @type String\n */\n b: function(){}};\n", "X.js", "class MyClass extends String{\n  Number a;\n  MyClass()\n  String b()\n}\n", this.getDefaultOptions());
    }

    public void test042a() {
        this.runInferTest("/**\n * @constructor \n * @extends String \n */\nfunction MyClass(){}MyClass.prototype = { \n/**\n   * @memberOf MyClass\n   * @type jsns.Number\n */\n a: 2 ,\n/**\n   * @memberOf MyClass\n   * @type jsns.String\n */\n b: function(){}};\n", "X.js", "class MyClass extends String{\n  jsns.Number a;\n  MyClass()\n  jsns.String b()\n}\n", this.getDefaultOptions());
    }

    public void test043() {
        this.runInferTest("/**\n * @constructor \n */\nfunction MyClass(){}/**\n * @memberOf MyClass \n * @param {Number} p1\n * @type String \n */\nfunction foo(p1){};\n", "X.js", "class MyClass extends Object{\n  MyClass()\n  String foo(Number p1)\n}\n", this.getDefaultOptions());
    }

    public void test043a() {
        this.runInferTest("/**\n * @constructor \n */\nfunction MyClass(){}/**\n * @memberOf MyClass \n * @param {jsns2.Number} p1\n * @type jsns.String \n */\nfunction foo(p1){};\n", "X.js", "class MyClass extends Object{\n  MyClass()\n  jsns.String foo(jsns2.Number p1)\n}\n", this.getDefaultOptions());
    }

    public void test060() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape_GetArea(){ var str=\"\";return str;}", "X.js", "class Shape extends Object{\n  String GetArea()\n}\n", this.getDefaultOptions());
    }

    public void test061() {
        this.runInferTest("var foo = {  bar: \"bar\",  bar2: function(){}}", "X.js", "class ___anonymous_foo extends Object{\n  String bar;\n  void bar2()\n}\n", this.getDefaultOptions());
    }

    public void test062() {
        this.runInferTest("var foo;foo = {  bar: \"bar\",  bar2: function(){}}", "X.js", "class ___anonymous_foo extends Object{\n  String bar;\n  void bar2()\n}\n", this.getDefaultOptions());
    }

    public void test063() {
        this.runInferTest("var foo = {  bar: \"bar\",  bar2: {    bar3: \"bar3\"  }}", "X.js", "class ___anonymous_foo extends Object{\n  String bar;\n  ___anonymous32_51 bar2;\n}\nclass ___anonymous32_51 extends Object{\n  String bar3;\n}\n", this.getDefaultOptions());
    }

    public void test064() {
        this.runInferTest("var ns = {};ns.foo = \"\";ns.bar = function(){  return \"\";}", "X.js", "class ___anonymous_ns extends Object{\n  String foo;\n  String bar()\n}\n", this.getDefaultOptions());
    }

    public void test065() {
        this.runInferTest("var ns = {};ns.foo = {  bar: \"\"};", "X.js", "class ___anonymous_ns extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  String bar;\n}\n", this.getDefaultOptions());
    }

    public void test066() {
        this.runInferTest("function foo(){};foo.prototype = {  bar: \"\"}", "X.js", "class foo extends Object{\n  String bar;\n  foo()\n}\n", this.getDefaultOptions());
    }

    public void test067() {
        this.runInferTest("function foo(){};foo.prototype.bar = {  bar2: \"\"}", "X.js", "class foo extends Object{\n  ___anonymous37_48 bar;\n  foo()\n}\nclass ___anonymous37_48 extends Object{\n  String bar2;\n}\n", this.getDefaultOptions());
    }

    public void test068() {
        this.runInferTest("var ns = {};ns.foo = function(){};ns.foo.prototype.bar = \"\";ns.foo.prototype.bar2 = function(){  return \"\";}", "X.js", "class ___anonymous_ns extends Object{\n  void foo()\n}\nclass ns.foo extends Object{\n  String bar;\n  String bar2()\n  ns.foo()\n}\n", this.getDefaultOptions());
    }

    public void test068b() {
        this.runInferTest("var ns = {};ns.foo = function(){};function abc(){};ns.foo2 = abc;", "X.js", "class ___anonymous_ns extends Object{\n  void foo()\n  void foo2()\n}\n", this.getDefaultOptions());
    }

    public void test068c() {
        this.runInferTest("var ns = {};ns.foo = function(){};ns.foo2 = ns.foo;", "X.js", "class ___anonymous_ns extends Object{\n  void foo()\n  void foo2()\n}\n", this.getDefaultOptions());
    }

    public void test069() {
        this.runInferTest("var ns1 = {  ns2: {}};ns1.ns2.foo = function(){};ns1.ns2.foo.prototype.bar = \"\";ns1.ns2.foo.prototype.bar2 = function(){  return \"\";}", "X.js", "class ___anonymous_ns1 extends Object{\n  ___anonymous18_19 ns2;\n}\nclass ___anonymous18_19 extends Object{\n  void foo()\n}\nclass ns1.ns2.foo extends Object{\n  String bar;\n  String bar2()\n  ns1.ns2.foo()\n}\n", this.getDefaultOptions());
    }

    public void test070() {
        this.runInferTest("var foo = {  a: \"\",  b: function(){    return \"\";  }};foo.c = \"\";foo.d = function(x, y, z) {  return { x : \"\", y : \"\", z : \"\" };};", "X.js", "class ___anonymous_foo extends Object{\n  String a;\n  String c;\n  String b()\n  ___anonymous101_126 d(x, y, z)\n}\nclass ___anonymous101_126 extends Object{\n  String x;\n  String y;\n  String z;\n}\n", this.getDefaultOptions());
    }

    public void test071() {
        this.runInferTest("if( true ){  var foo = {};}foo.bar = \"\"", "X.js", "class ___anonymous_foo extends Object{\n  String bar;\n}\n", this.getDefaultOptions());
    }

    public void test072() {
        this.runInferTest("var foo = function(){\treturn {\t\tx: \"\",\t\ty: \"\"\t}};", "X.js", "class ___anonymous29_46 extends Object{\n  String x;\n  String y;\n}\n", this.getDefaultOptions());
    }

    public void test073() {
        this.runInferTest("var foo = function(){\tvar bar = {\t\tx: \"\",\t\ty: \"\"\t}};", "X.js", "class ___anonymous32_49 extends Object{\n  String x;\n  String y;\n}\n", this.getDefaultOptions());
    }

    public void test074() {
        this.runInferTest("/**\n  * Object Node()\n  * @super Object\n  * @constructor\n  * @class Node\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nfunction Node(){};\n/**\n  * Property firstChild\n  * @type Node\n  * @class Node\n  * @see Node\n\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nNode.prototype.firstChild=new Node();\n/**\n  * function insertBefore(newChild, refChild)\n  * @type Node\n  * @class Node\n  * @param newChilds Node\n  * @param refChild Node\n  * @return Node\n  * @throws DOMException\n  * @see Node\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nNode.prototype.insertBefore = function(newChild, refChild){};\n", "X.js", "class Node extends Object{\n  Node firstChild;\n  Node()\n  Node insertBefore(newChild, refChild)\n}\n", this.getDefaultOptions());
    }

    public void test075() {
        this.runInferTest("var x = function(){};x.prototype = {};x.foo = \"\";x.bar = function(){  return \"\";}", "X.js", "class x extends Object{\n  static String foo;\n  static String bar()\n  x()\n}\n", this.getDefaultOptions());
    }

    public void test075b() {
        this.runInferTest("function x(){};x.foo = \"\";x.bar = function(){  return \"\";}", "X.js", "class x extends Object{\n  static String foo;\n  static String bar()\n  x()\n}\n", this.getDefaultOptions());
    }

    public void test080() {
        this.runInferTest("(function(){this.someField = 1;})();", "X.js", "class @G extends Object{\n  Number someField;\n}\n", this.getDefaultOptions());
    }

    public void test081() {
        this.runInferTest("String.foo = \"\";String.bar = function(){  return \"\";}", "X.js", "class String extends Object{\n  static String foo;\n  static String bar()\n}\n", this.getDefaultOptions());
    }

    public void test082() {
        this.runInferTest("String.foo = \"\";String.bar1 = String.bar2 = function(){  return \"\";}", "X.js", "class String extends Object{\n  static String foo;\n  static String bar1()\n  static String bar2()\n}\n", this.getDefaultOptions());
    }

    public void test083() {
        this.runInferTest("function Car() {\tthis.color = 'red';\tthis.Move = function() { return \"I'm moving\"; };};Car.Stop = function() { return \"I'm not moving\"; };Car.engine = 'diesel';", "X.js", "class Car extends Object{\n  String color;\n  static String engine;\n  String Move()\n  static String Stop()\n  Car()\n}\n", this.getDefaultOptions());
    }

    public void test084() {
        this.runInferTest("function Car() {\tthis.color = 'red';\tthis.Move = function() { return \"I'm moving\"; };};", "X.js", "class Car extends Object{\n  String color;\n  String Move()\n  Car()\n}\n", this.getDefaultOptions());
    }

    public void test085() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test086() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;\treturn this.length * this.width;}", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test087() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}var s = new Shape(2, 3);s.area = function() {\treturn this.length * this.width;};", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Shape(l, w)\n}\nclass ___anonymous_s extends Shape{\n  Number area()\n}\n", this.getDefaultOptions());
    }

    public void test088() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;\tthis.area = function() {return this.length * this.width;};}", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Number area()\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test089() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}Shape.prototype.area = function() {return this.length * this.width;};", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Number area()\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test090() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}Shape.CONSTANT = 3;", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  static Number CONSTANT;\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test091() {
        this.runInferTest("function Round(r){\tthis.rad = r;}Round.PI = 3.14;Round.prototype.area = function() {return Round.PI * this.rad * this.rad;};Round.equal = function(a, b) {if(a == b) return true;return false;};", "X.js", "class Round extends Object{\n  ?? rad;\n  static Number PI;\n  Number area()\n  static Boolean equal(a, b)\n  Round(r)\n}\n", this.getDefaultOptions());
    }

    public void test092() {
        this.runInferTest("function Com(r, i){\tthis.r1 = r;\tthis.i1 = i;}Com.prototype.meth1 = function() {return 1;};Com.prototype.meth2 = function() {return new Com(1, 2);};Com.prototype.meth3 = function(that) {return new Com(that+1, that-1);};Com.prototype.toString = function() {return \"hi\"};Com.classMeth1 = function(a, b) {return new Com(a, b);};Com.classMeth2 = function(a, b) {return new Com(a, b);};Com.ZERO = new Com(0,0);Com.ONE = new Com(1,0);", "X.js", "class Com extends Object{\n  ?? r1;\n  ?? i1;\n  static Com ZERO;\n  static Com ONE;\n  Number meth1()\n  Com meth2()\n  Com meth3(that)\n  String toString()\n  static Com classMeth1(a, b)\n  static Com classMeth2(a, b)\n  Com(r, i)\n}\n", this.getDefaultOptions());
    }

    public void test093() {
        this.runInferTest("function Shape(l, w){\tthis.length = function() {return l;};\tthis.width = function() {return w;};}Shape.prototype.perimeter = function() {return (this.length * 2) + (this.width * 2);};", "X.js", "class Shape extends Object{\n  ?? length()\n  ?? width()\n  Number perimeter()\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test094() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}Shape.prototype.area = function() {return this.length * this.width;};function SubShape(l, w, x) {Shape.call(this, l, w);this.x = y;}SubShape.prototype = new Shape();SubShape.prototype.meth = function() {return 1};", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Number area()\n  Shape(l, w)\n}\nclass SubShape extends Shape{\n  ?? x;\n  Number meth()\n  SubShape(l, w, x)\n}\n", this.getDefaultOptions());
    }

    public void test095() {
        this.runInferTest("function Abc(){\tthis.mult = function(a, b){return a * b;};\tthis.div = function(a, b){return a / b;};\tthis.rem = function(a, b){return a % b;};\tthis.sub = function(a, b){return a - b;};}", "X.js", "class Abc extends Object{\n  Number mult(a, b)\n  Number div(a, b)\n  Number rem(a, b)\n  Number sub(a, b)\n  Abc()\n}\n", this.getDefaultOptions());
    }

    public void test096() {
        this.runInferTest("function Plus(){\tthis.strings = function(){return \"a\" + \"b\";};\tthis.oneStringOneNumber = function(){return \"a\" + 1;};\tthis.oneStringOneNumber2 = function(){return \"3\" + 1;};\tthis.numbers = function(){return 1 + 2;};\tthis.unknownString = function(a){return a + \"b\";};\tthis.unknownNumber = function(a){return a + 3;};\tthis.unknownUnknown = function(a, b){return a + b;};}", "X.js", "class Plus extends Object{\n  String strings()\n  String oneStringOneNumber()\n  String oneStringOneNumber2()\n  Number numbers()\n  String unknownString(a)\n  ?? unknownNumber(a)\n  ?? unknownUnknown(a, b)\n  Plus()\n}\n", this.getDefaultOptions());
    }

    public void test097() {
        this.runInferTest("function Equality(){\tthis.equalsEquals = function(){return \"a\" == \"b\";};\tthis.equalsEqualsEquals = function(){return \"a\" === \"b\";};\tthis.notEquals = function(){return \"a\" != \"b\";};\tthis.notEqualsEquals = function(){return \"a\" !== \"b\";};}", "X.js", "class Equality extends Object{\n  Boolean equalsEquals()\n  Boolean equalsEqualsEquals()\n  Boolean notEquals()\n  Boolean notEqualsEquals()\n  Equality()\n}\n", this.getDefaultOptions());
    }

    public void test098() {
        this.runInferTest("var MyFunc = function () {};\nMyFunc.myMeth = function () {};", "X.js", "class MyFunc extends Function{\n  static void myMeth()\n  MyFunc()\n}\n", this.getDefaultOptions());
    }

    public void test099() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\n", "X.js", "class MyType extends Object{\n  Number length;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test099a() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\nMyType.prototype.name = \"\";\n", "X.js", "class MyType extends Object{\n  Number length;\n  String name;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test099b() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\nMyType.prototype.name = \"\";\nMyType.prototype.date = new Date();\n", "X.js", "class MyType extends Object{\n  Number length;\n  String name;\n  Date date;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test099c() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @type    String\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.time = 1;\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\nMyType.prototype.name = \"\";\nMyType.prototype.date = new Date();\n", "X.js", "class MyType extends Object{\n  String time;\n  Number length;\n  String name;\n  Date date;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test100() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\n", "X.js", "class MyType extends Object{\n  String length;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test101() {
        this.runInferTest("MyType = {\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nlength : \"value\"\n};", "X.js", "class MyType extends Object{\n  Number length;\n}\n", this.getDefaultOptions());
    }

    public void test102() {
        this.runInferTest("MyType = {\n/**\n  * Property length\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nlength : \"value\"\n};", "X.js", "class MyType extends Object{\n  String length;\n}\n", this.getDefaultOptions());
    }

    public void test103() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : \"\"\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  MyTypeInner events;\n}\n", this.getDefaultOptions());
    }

    public void test104() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  MyTypeInner events;\n}\n", this.getDefaultOptions());
    }

    public void test105() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : \"\",\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : 7\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  String a;\n  MyTypeInner events;\n  Number b;\n}\n", this.getDefaultOptions());
    }

    public void test106() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : {},\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  ___anonymous80_81 a;\n  MyTypeInner events;\n  ___anonymous220_221 b;\n}\nclass ___anonymous80_81 extends Object{\n}\nclass ___anonymous220_221 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test107() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : {},\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\n/**\n  * Property b\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    String\n  * @since   WTP 3.2.2\n */\nb : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  ___anonymous80_81 a;\n  MyTypeInner events;\n  String b;\n}\nclass ___anonymous80_81 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test108() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : {},\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  ___anonymous80_81 a;\n  MyTypeInner events;\n  ___anonymous220_221 b;\n}\nclass ___anonymous80_81 extends Object{\n}\nclass ___anonymous220_221 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test108a() {
        this.runInferTest("MyType = {\n/**\n  * Property events\n  * @memberOf   MyType\n  * @type    MyOwnNamespace.String\n */\nevents : {},\nb : \"\"\n};", "X.js", "class MyType extends Object{\n  MyOwnNamespace.String events;\n  String b;\n}\n", this.getDefaultOptions());
    }

    public void test108d() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : {},\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : 5\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  ___anonymous80_81 a;\n  MyTypeInner events;\n  Number b;\n}\nclass ___anonymous80_81 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test108b() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : \"\"\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  MyTypeInner events;\n  String b;\n}\n", this.getDefaultOptions());
    }

    public void test108c() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\n/**\n  * Property a\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\na : 5,\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  Number a;\n  MyTypeInner events;\n  ___anonymous308_309 b;\n}\nclass ___anonymous308_309 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void testBug329803_1() {
        this.runInferTest("var fun1 = function() {\tthis.abc = 1}", "X.js", "class fun1 extends Object{\n  Number abc;\n  fun1()\n}\n", this.getDefaultOptions());
    }

    public void test201() {
        this.runInferTest("foo.bar.Awesome = function(){\nthis.test = \"\";\nthis.func = function(){}\n}\n", "X.js", "class foo.bar.Awesome extends Object{\n  String test;\n  void func()\n  foo.bar.Awesome()\n}\n", this.getDefaultOptions());
    }

    public void test201_1() {
        this.runInferTest("var foo = {\n  bar : {}\n}\nfoo.bar.Awesome = function(){\nthis.test = \"\";\nthis.func = function(){}\n}\n", "X.js", "class ___anonymous_foo extends Object{\n  ___anonymous20_21 bar;\n}\nclass ___anonymous20_21 extends Object{\n  void Awesome()\n}\nclass foo.bar.Awesome extends Object{\n  String test;\n  void func()\n  foo.bar.Awesome()\n}\n", this.getDefaultOptions());
    }

    public void test202() {
        this.runInferTest("Test = function(/** String */ arg1){\n/**@type String */\nthis.test = arg1;\n}\n", "X.js", "class Test extends Object{\n  String test;\n  Test(arg1)\n}\n", this.getDefaultOptions());
    }

    public void testBUG317281() {
        this.runInferTest("function A$b(){\n}\nA$b.prototype.fun1 = function() {};\n", "X.js", "class A$b extends Object{\n  void fun1()\n  A$b()\n}\n", this.getDefaultOptions());
    }

    public void testBUG343691() {
        this.runInferTest("function $(){\n}\n$.hasData = function(element) {};\n$.prototype.jquery = \"\";\n", "X.js", "class $ extends Object{\n  String jquery;\n  $()\n  static void hasData(element)\n}\n", this.getDefaultOptions());
    }

    public void testHierarchyLoop1() {
        this.runInferTest("Test = function(){\nthis.test = \"\";\n}\nTest2 = function() {\nthis.test2 = \"\"}\nTest.prototype = new Test2();\nTest2.prototype = new Test();\n", "X.js", "class Test extends Test2{\n  String test;\n  Test()\n}\nclass Test2 extends Object{\n  String test2;\n  Test2()\n}\n", this.getDefaultOptions());
    }

    public void testHierarchyLoop2() {
        this.runInferTest("Test = function(){\nthis.test = 5.0;\n}\nTest.prototype = new Test();\n", "X.js", "class Test extends Object{\n  Number test;\n  Test()\n}\n", this.getDefaultOptions());
    }

    public void testPrototypeAssignmentNotTreatedAsPartOfFunctionName() {
        this.runInferTest("function testPrototypeNotTreatedAsPartOfName(){};\ntestPrototypeNotTreatedAsPartOfName.prototype.toString = function(){return \"\";};\n", "X.js", "class testPrototypeNotTreatedAsPartOfName extends Object{\n  String toString()\n  testPrototypeNotTreatedAsPartOfName()\n}\n", this.getDefaultOptions());
    }

    public void testFunctionNamed_Function_ShouldNotBecomeConstructorForFunctionType() {
        CompilationUnitDeclaration declaration = this.runInferTest("var test0 = function() {};var test1 = {\tFunction : function(test) {}}", "X.js", "class ___anonymous_test1 extends Object{\n  void Function(test)\n}\n", this.getDefaultOptions());
        this.verifySourceRangeWithContents(declaration, "___anonymous_test1", "test1 = {", "}}");
    }

    public void testAssigningToFieldsOnGlobals_0() {
        this.runInferTest("foo.bar = 42;", "X.js", "class ___anonymous_foo extends Object{\n  Number bar;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_1() {
        this.runInferTest("foo = {}foo.bar = 42;", "X.js", "class ___anonymous_foo extends Object{\n  Number bar;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_2() {
        CompilationUnitDeclaration declaration = this.runInferTest("var foo = {}foo.bar = 42;", "X.js", "class ___anonymous_foo extends Object{\n  Number bar;\n}\n", this.getDefaultOptions());
        this.verifySourceRangeWithContents(declaration, "___anonymous_foo", "foo = {", "{}");
    }

    public void testAssigningToFieldsOnGlobals_3() {
        this.runInferTest("foo.bar.awesome = 42;", "X.js", "class ___anonymous0_6 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_4() {
        this.runInferTest("foo = {}foo.bar.awesome = 42;", "X.js", "class ___anonymous_foo extends Object{\n  ___anonymous8_14 bar;\n}\nclass ___anonymous8_14 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_5() {
        this.runInferTest("foo = {  bar : {}}foo.bar.awesome = 42;", "X.js", "class ___anonymous_foo extends Object{\n  ___anonymous15_16 bar;\n}\nclass ___anonymous15_16 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_6() {
        this.runInferTest("var foo = {}foo.bar.awesome = 42;", "X.js", "class ___anonymous_foo extends Object{\n  ___anonymous12_18 bar;\n}\nclass ___anonymous12_18 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_7() {
        this.runInferTest("var foo = {  bar : {}}foo.bar.awesome = 42;", "X.js", "class ___anonymous_foo extends Object{\n  ___anonymous19_20 bar;\n}\nclass ___anonymous19_20 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_8() {
        this.runInferTest("(function() {  foo.bar = 42;})();", "X.js", "class @G extends Object{\n}\nclass ___anonymous_foo extends Object{\n  Number bar;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_9() {
        this.runInferTest("(function() {  this.foo.bar = 42;})();", "X.js", "class @G extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  Number bar;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_10() {
        this.runInferTest("(function() {  foo = {};  foo.bar = 42;})();", "X.js", "class @G extends Object{\n}\nclass ___anonymous_foo extends Object{\n  Number bar;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_11() {
        this.runInferTest("(function() {  this.foo = {}  foo.bar = 42;})();", "X.js", "class @G extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  Number bar;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_12() {
        this.runInferTest("(function() {  this.foo = {}  this.foo.bar = 42;})();", "X.js", "class @G extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  Number bar;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_13() {
        this.runInferTest("(function() {  foo.bar.awesome = 42;})();", "X.js", "class @G extends Object{\n}\nclass ___anonymous15_21 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_14() {
        this.runInferTest("(function() {  this.foo.bar.awesome = 42;})();", "X.js", "class @G extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  ___anonymous15_26 bar;\n}\nclass ___anonymous15_26 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_15() {
        this.runInferTest("(function() {  foo = {}  foo.bar.awesome = 42;})();", "X.js", "class @G extends Object{\n}\nclass ___anonymous_foo extends Object{\n  ___anonymous25_31 bar;\n}\nclass ___anonymous25_31 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_16() {
        this.runInferTest("(function() {  this.foo = {}  foo.bar.awesome = 42;})();", "X.js", "class @G extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  ___anonymous30_36 bar;\n}\nclass ___anonymous30_36 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_17() {
        this.runInferTest("(function() {  this.foo = {}  this.foo.bar.awesome = 42;})();", "X.js", "class @G extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  ___anonymous30_41 bar;\n}\nclass ___anonymous30_41 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_18() {
        this.runInferTest("(function() {  foo = {    bar : {}  }  foo.bar.awesome = 42;})();", "X.js", "class @G extends Object{\n}\nclass ___anonymous_foo extends Object{\n  ___anonymous32_33 bar;\n}\nclass ___anonymous32_33 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_19() {
        this.runInferTest("(function() {  this.foo = {    bar : {}  }  foo.bar.awesome = 42;})();", "X.js", "class @G extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  ___anonymous37_38 bar;\n}\nclass ___anonymous37_38 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_20() {
        this.runInferTest("(function() {  this.foo = {    bar : {}  }  this.foo.bar.awesome = 42;})();", "X.js", "class @G extends Object{\n  ___anonymous_foo foo;\n}\nclass ___anonymous_foo extends Object{\n  ___anonymous37_38 bar;\n}\nclass ___anonymous37_38 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToFieldsOnGlobals_21() {
        this.runInferTest("foo.bar['awesome'] = 42;", "X.js", "class ___anonymous0_6 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToReferenceToType_0() {
        this.runInferTest("function Foo() {\tthis.test0 = \"\";}Foo.prototype.test1 = 53;Foo.test2 = \"test\";var ReferenceToFoo = Foo;ReferenceToFoo.addedToReference0 = \"test\";ReferenceToFoo.prototype.addedToReference1 = \"test\";", "X.js", "class Foo extends Object{\n  String test0;\n  Number test1;\n  static String test2;\n  static String addedToReference0;\n  String addedToReference1;\n  Foo()\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToReferenceToType_1() {
        this.runInferTest("var Foo = function() {\tthis.test0 = \"\";}Foo.prototype.test1 = 53;Foo.test2 = \"test\";var ReferenceToFoo = Foo;ReferenceToFoo.addedToReference0 = \"test\";ReferenceToFoo.prototype.addedToReference1 = \"test\";", "X.js", "class Foo extends Object{\n  String test0;\n  Number test1;\n  static String test2;\n  static String addedToReference0;\n  String addedToReference1;\n  Foo()\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToReferenceToType_2() {
        this.runInferTest("Foo = function() {\tthis.test0 = \"\";}Foo.prototype.test1 = 53;Foo.test2 = \"test\";var ReferenceToFoo = Foo;ReferenceToFoo.addedToReference0 = \"test\";ReferenceToFoo.prototype.addedToReference1 = \"test\";", "X.js", "class Foo extends Object{\n  String test0;\n  Number test1;\n  static String test2;\n  static String addedToReference0;\n  String addedToReference1;\n  Foo()\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToReferenceToType_3() {
        this.runInferTest("function Foo() {\tthis.test0 = \"\";}Foo.prototype.test1 = 53;Foo.test2 = \"test\";ReferenceToFoo = Foo;ReferenceToFoo.addedToReference0 = \"test\";ReferenceToFoo.prototype.addedToReference1 = \"test\";", "X.js", "class Foo extends Object{\n  String test0;\n  Number test1;\n  static String test2;\n  static String addedToReference0;\n  String addedToReference1;\n  Foo()\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToReferenceToType_4() {
        this.runInferTest("var Foo = function() {\tthis.test0 = \"\";}Foo.prototype.test1 = 53;Foo.test2 = \"test\";ReferenceToFoo = Foo;ReferenceToFoo.addedToReference0 = \"test\";ReferenceToFoo.prototype.addedToReference1 = \"test\";", "X.js", "class Foo extends Object{\n  String test0;\n  Number test1;\n  static String test2;\n  static String addedToReference0;\n  String addedToReference1;\n  Foo()\n}\n", this.getDefaultOptions());
    }

    public void testAssigningToReferenceToType_5() {
        this.runInferTest("Foo = function() {\tthis.test0 = \"\";}Foo.prototype.test1 = 53;Foo.test2 = \"test\";ReferenceToFoo = Foo;ReferenceToFoo.addedToReference0 = \"test\";ReferenceToFoo.prototype.addedToReference1 = \"test\";", "X.js", "class Foo extends Object{\n  String test0;\n  Number test1;\n  static String test2;\n  static String addedToReference0;\n  String addedToReference1;\n  Foo()\n}\n", this.getDefaultOptions());
    }

    public void test_FieldOnGlobalAssignedToGlobal() {
        this.runInferTest("var b = foo.bar;", "X.js", "", this.getDefaultOptions());
    }

    public void test_FieldOnGlobalAssignedToFieldOnAnotherGlobal() {
        this.runInferTest("b.bar = foo.bar;", "X.js", "class ___anonymous_b extends Object{\n  ?? bar;\n}\n", this.getDefaultOptions());
    }

    public void test_TwoDifferentAssignmentsToSameGlobal() {
        this.runInferTest("var global0 = \"Test\";global0 = {\tfeild0 : 0};", "X.js", "class ___anonymous31_43 extends Object{\n  Number feild0;\n}\nclass ___anonymous_global0 extends Object{\n  Number feild0;\n}\n", this.getDefaultOptions());
    }

    public void test_AssignFieldToGlobalVariable() {
        this.runInferTest("var foo = new Object()foo.bar = {};", "X.js", "class ___anonymous_foo extends Object{\n  ___anonymous_bar bar;\n}\nclass ___anonymous_bar extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test_AssignFieldToFieldOnGlobalVariable() {
        this.runInferTest("var foo = new Object()foo.bar.awesome = 42;", "X.js", "class ___anonymous_foo extends Object{\n  ___anonymous22_28 bar;\n}\nclass ___anonymous22_28 extends Object{\n  Number awesome;\n}\n", this.getDefaultOptions());
    }

    public void test_TwoConstructorFunctions() {
        this.runInferTest("function Mixer1() {\tthis.mixAtt1 = 3;\tthis.mixMeth1 = function() {\t};}function Mixer2() {\tthis.mixAtt2 = true;\tthis.mixMeth2 = function(a) {\t\treturn true;\t};}", "X.js", "class Mixer1 extends Object{\n  Number mixAtt1;\n  void mixMeth1()\n  Mixer1()\n}\nclass Mixer2 extends Object{\n  Boolean mixAtt2;\n  Boolean mixMeth2(a)\n  Mixer2()\n}\n", this.getDefaultOptions());
    }

    public void test_LocalTypeShouldNotGetGlobalTypeName() {
        this.runInferTest("(function(){\n\tvar ta = {};\n\tta.UnderlineAnnotation = function(foo){\n\t\tthis.transform={dx:0,dy:0};\n\t};\n\tta.UnderlineAnnotation.prototype = new ta.Annotation;\n\tvar p = ta.UnderlineAnnotation.prototype;\n\tp.constructor=ta.UnderlineAnnotation;\n})();", "X.js", "class @G extends Object{\n}\nclass ___anonymous23_24 extends Object{\n  ___anonymous85_95 transform;\n  void UnderlineAnnotation(foo)\n}\nclass ta.UnderlineAnnotation extends ta.Annotation{\n  ___anonymous85_95 transform;\n  ta.UnderlineAnnotation(foo)\n}\nclass ___anonymous85_95 extends Object{\n  Number dx;\n  Number dy;\n}\nclass ___anonymous201_201 extends Object{\n  void constructor(foo)\n}\n", this.getDefaultOptions());
    }

    public void testClosureArgumentIsGlobalWithAddedProperty() {
        this.runInferTest("(function(window, undefined){\n\tvar t = {};\n\twindow.jChris = t;\n})(window);\nwindow.ta = 4;\n", "X.js", "class ___anonymous_window extends Object{\n  ___anonymous_jChris jChris;\n  Number ta;\n}\nclass @G extends Object{\n}\nclass ___anonymous_jChris extends Object{\n}\n", this.getDefaultOptions());
    }

    public void testClosureArgumentNamedWindowButLocalDeclarationPassedIn() {
        this.runInferTest("var s = 5;\n(function(window, undefined){\n\tvar t = {};\n\twindow.jChris = t;\n})(s);\n", "X.js", "class @G extends Object{\n}\nclass ___anonymous50_51 extends Object{\n}\nclass ___anonymous55_60 extends Number{\n  ___anonymous50_51 jChris;\n}\n", this.getDefaultOptions());
    }

    public void testClosureArgumentIsLocalDeclaration() {
        this.runInferTest("var s = 5;\n(function(x, undefined){\n\tvar t = {};\n\tx.jChris = t;\n})(s);\n", "X.js", "class @G extends Object{\n}\nclass ___anonymous45_46 extends Object{\n}\nclass ___anonymous50_50 extends Number{\n  ___anonymous45_46 jChris;\n}\n", this.getDefaultOptions());
    }

    public void testClosureArgumentIsAssignment() {
        this.runInferTest("s = 5;\n(function(x, undefined){\n\tvar t = {};\n\tx.jChris = t;\n})(s);\n", "X.js", "class @G extends Object{\n}\nclass ___anonymous41_42 extends Object{\n}\nclass ___anonymous46_46 extends Number{\n  ___anonymous41_42 jChris;\n}\n", this.getDefaultOptions());
    }

    public void testClosureArgumentIsGlobal() {
        this.runInferTest("(function(window, undefined){\n\tvar t = {};\n\twindow.jChris = t;\n})(window);\n", "X.js", "class ___anonymous_window extends Object{\n  ___anonymous_jChris jChris;\n}\nclass @G extends Object{\n}\nclass ___anonymous_jChris extends Object{\n}\n", this.getDefaultOptions());
    }

    public void testClosureArgumentIsGlobalType() {
        this.runInferTest("(function(window, undefined){\n\tvar jChris = function(){};\n\tjChris.fn = jChris.prototype = {hop: 1};\n   window.jChris = jChris;\n})(window);\n", "X.js", "class ___anonymous_window extends Object{\n  ___anonymous_jChris jChris;\n  void jChris()\n}\nclass @G extends Object{\n}\nclass ___anonymous_jChris extends Function{\n  ___anonymous90_97 fn;\n}\nclass ___anonymous90_97 extends Object{\n  Number hop;\n}\nclass jChris extends Object{\n  static ___anonymous90_97 fn;\n  jChris()\n}\n", this.getDefaultOptions());
    }

    public void testWI97616() {
        this.runInferTest("/** @memberOf Number */\nvar hiliteSearchTerm = \"hi\";", "X.js", "class Number extends Object{\n  String hiliteSearchTerm;\n}\n", this.getDefaultOptions());
    }

    public void testWI97616_2() {
        this.runInferTest("/** @memberOf Number */\nvar hiliteSearchTerm = (function() {\nreturn \"hi\";})();", "X.js", "class Number extends Object{\n  String hiliteSearchTerm;\n}\n", this.getDefaultOptions());
    }

    public void testClosureReturnsFunction() {
        this.runInferTest("(function( window) {\n\tvar jChris = (function() {\n\tvar jChris = function( selector, context ) {return new jChris.fn.init();};\n\tjChris.fn = jChris.prototype = {};\n\tjChris.fn.init.prototype = jChris.fn;\n\treturn jChris;})();\tjChris.extend({\n\tdata: function() {var internalKey = jChris.expando;}\n\t});\n\twindow.jChris = jChris;})( window );", "X.js", "class ___anonymous_window extends Object{\n  ___anonymous_jChris jChris;\n  jChris.fn.init jChris(selector, context)\n}\nclass @G extends Object{\n}\nclass ___anonymous105_113 extends Object{\n}\nclass jChris.fn.init extends ___anonymous157_158{\n}\nclass ___anonymous_jChris extends Function{\n  ___anonymous157_158 fn;\n  ___anonymous157_158 prototype;\n}\nclass ___anonymous157_158 extends Object{\n}\nclass ___anonymous235_292 extends Object{\n  void data()\n}\n", this.getDefaultOptions());
    }

    public void testWI98919() {
        this.runInferTest("(function( window) {\n\tvar jChris = (function() {\n\tvar jChris = function( selector, context ) {return new jChris.fn.init();};\n\tjChris.fn = jChris.prototype = {init: function() {}, ready: function(fn) {}};\n\tjChris.fn.init.prototype = jChris.fn;\n\treturn jChris;})();\twindow.jChris = jChris;})( window );", "X.js", "class ___anonymous_window extends Object{\n  ___anonymous_jChris jChris;\n  jChris.fn.init jChris(selector, context)\n}\nclass @G extends Object{\n}\nclass ___anonymous105_113 extends Object{\n}\nclass jChris.fn.init extends ___anonymous157_201{\n}\nclass ___anonymous_jChris extends Function{\n  ___anonymous157_201 fn;\n  ___anonymous157_201 prototype;\n}\nclass ___anonymous157_201 extends Object{\n  void init()\n  void ready(fn)\n}\n", this.getDefaultOptions());
    }

    public void testWI99473() {
        CompilationUnitDeclaration declaration = this.runInferTest("foo.prototype.bar = /**\n */\nfunction (e) {\n  this.baz = true;\n  return true;\n}", "X.js", "class foo extends Object{\n  Boolean baz;\n  Boolean bar(e)\n}\n", this.getDefaultOptions());
        InferTypesTests.assertFalse((String)"There shouldn't be a type named 'foo.prototype.bar'", (declaration.findInferredType("foo.prototype.bar".toCharArray()) != null ? 1 : 0) != 0);
    }

    public void testAssignAsThisInClosure() {
        CompilationUnitDeclaration declaration = this.runInferTest("(function(\n userConfig,\n defaultConfig\n)\n{\nvar noop = function(){\n},\nglobal=this;\nvar def = function(\nmid,\t\t  //(commonjs.moduleId, optional) list of modules to be loaded before running factory\ndependencies, //(array of commonjs.moduleId, optional)\nfactory\t\t  //(any)\n){};\n  global.define = def;\n}){}", "X.js", "class @G extends Object{\n  Function define;\n}\n", this.getDefaultOptions());
        InferTypesTests.assertNull((String)"There should not be a global function def()", (Object)declaration.findInferredType("@G".toCharArray()).findMethod("def".toCharArray(), null));
    }

    public void testDeclareAsThisInClosure() {
        CompilationUnitDeclaration declaration = this.runInferTest("(function(\n userConfig,\n defaultConfig\n)\n{\nvar noop = function(){\n},\nglobal=this;\nvar def = function(\nmid,\t\t  //(commonjs.moduleId, optional) list of modules to be loaded before running factory\ndependencies, //(array of commonjs.moduleId, optional)\nfactory\t\t  //(any)\n){};\n  global.define = def;\n}){}", "X.js", "class @G extends Object{\n  Function define;\n}\n", this.getDefaultOptions());
        InferTypesTests.assertNull((String)"There should not be a global function def()", (Object)declaration.findInferredType("@G".toCharArray()).findMethod("def".toCharArray(), null));
    }
}

