/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.search;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;

public class AbstractSearchTest
extends TestCase {
    private String fRootProjectName;

    protected String getRootProjectName() {
        if (this.fRootProjectName == null) {
            this.fRootProjectName = String.valueOf(new String(CharOperation.lastSegment((char[])((Object)((Object)this)).getClass().getName().toCharArray(), (char)'.'))) + "_";
        }
        return this.fRootProjectName;
    }

    protected JavaProject setupMinimalProject(String name, String[] fileNames, String[] sources) throws CoreException {
        IProjectDescription desc;
        ArrayList<String> natures;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!(natures = new ArrayList<String>(Arrays.asList((desc = project.getDescription()).getNatureIds()))).contains("org.eclipse.wst.jsdt.core.jsNature")) {
            natures.add("org.eclipse.wst.jsdt.core.jsNature");
        }
        desc.setNatureIds(natures.toArray(new String[0]));
        project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
        JavaProject jsProject = (JavaProject)JavaScriptCore.create((IProject)project);
        jsProject.setRawIncludepath(new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)project.getFullPath()), JavaScriptCore.newContainerEntry((IPath)new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER"))}, null);
        jsProject.setOutputLocation(project.getFullPath(), null);
        int i = 0;
        while (i < sources.length) {
            project.getFile(fileNames[i]).create((InputStream)new ByteArrayInputStream(sources[i].getBytes()), true, null);
            ++i;
        }
        long time0 = System.currentTimeMillis();
        while (JavaModelManager.getJavaModelManager().getIndexManager().awaitingJobsCount() > 0 && System.currentTimeMillis() - time0 < 2000L) {
            Thread.yield();
        }
        return jsProject;
    }

    public SearchMatch[] runSearchTest(String queryString, IJavaScriptElement[] elementsInScope, int searchFor, int limitTo, int matchRule) throws Exception {
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])elementsInScope);
        final ArrayList results = new ArrayList();
        SearchEngine searchEngine = new SearchEngine();
        SearchPattern searchPattern = SearchPattern.createPattern((String)queryString, (int)searchFor, (int)limitTo, (int)matchRule);
        AbstractSearchTest.assertNotNull((String)"search pattern was not created", (Object)searchPattern);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                results.add(match);
            }
        };
        searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        return results.toArray(new SearchMatch[results.size()]);
    }

    protected SearchMatch[] runSearchTest(String projectQualifier, String queryString, String[] fileNames, String[] fileSources, int searchFor, int limitTo, int matchRule) throws Exception {
        JavaProject project = this.setupMinimalProject(String.valueOf(this.getRootProjectName()) + projectQualifier, fileNames, fileSources);
        return this.runSearchTest(queryString, new IJavaScriptElement[]{project}, searchFor, limitTo, matchRule);
    }

    public void verifyMatches(String expected, SearchMatch[] matches) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < matches.length) {
            char[] value = CharOperation.replace((char[])matches[i].toString().toCharArray(), (char[])new char[]{'\r', '\n'}, (char[])new char[]{'\n'});
            value = CharOperation.replace((char[])value, (char[])new char[]{'\r'}, (char[])new char[]{'\n'});
            b.append(value);
            ++i;
        }
        AbstractSearchTest.assertEquals((String)"Unexpected search results", (String)expected, (String)b.toString());
    }
}

