/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.search.AbstractSearchTest;

public class TestConstructorSearch
extends AbstractSearchTest {
    private int runSearchTest(String testName, String[] fileNames, String[] fileSources, int limitTo) throws Exception {
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.setupMinimalProject(String.valueOf(this.getRootProjectName()) + testName, fileNames, fileSources)});
        final int[] resultCount = new int[1];
        SearchEngine searchEngine = new SearchEngine();
        SearchPattern constructorPattern = SearchPattern.createPattern((String)testName, (int)3, (int)limitTo, (int)0);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                resultCount[0] = resultCount[0] + 1;
            }
        };
        searchEngine.search(constructorPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        return resultCount[0];
    }

    public void testDeclarationSearch01() throws Exception {
        int count = this.runSearchTest(this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"function " + this.getName() + "() {\n" + "\tthis.s = 5;\n" + "}\n", ""}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch02() throws Exception {
        int count = this.runSearchTest(this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"function " + this.getName() + "() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new " + this.getName() + "();\n"}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch03() throws Exception {
        int count = this.runSearchTest(this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"function " + this.getName() + "() {\n" + "\tthis.s = 5;\n" + "}\n", "function " + this.getName() + "2() {\n" + "\tthis.s = 5;\n" + "}\n" + this.getName() + "2.prototype = new " + this.getName() + "();\n"}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch04() throws Exception {
        int count = this.runSearchTest("pkg." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", ""}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch05() throws Exception {
        int count = this.runSearchTest("pkg." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new pkg." + this.getName() + "();\n"}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch06() throws Exception {
        int count = this.runSearchTest("pkg." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "pkg2." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n" + "pkg2." + this.getName() + ".prototype = new " + "pkg." + this.getName() + "();\n"}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch07() throws Exception {
        int count = this.runSearchTest("PKG." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new pkg." + this.getName() + "();\n"}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch08() throws Exception {
        int count = this.runSearchTest("pkg." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"PKG." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new pkg." + this.getName() + "();\n"}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch09() throws Exception {
        int count = this.runSearchTest("pkg." + this.getName(), new String[]{"X.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "};\n" + "pkg." + this.getName() + "2 = function() {\n" + "\tthis.s = 5;\n" + "};\n"}, 0);
        TestConstructorSearch.assertEquals((String)"wrong number of declarations found", (int)1, (int)count);
    }

    public void testDeclarationSearch10() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "tDS", new String[]{"X.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "};\n" + "pkg." + this.getName() + "2 = function() {\n" + "\tthis.s = 5;\n" + "};\n" + "pkg." + this.getName() + "3 = function() {\n" + "\tthis.s = 5;\n" + "};\n"}, 3, 0, 128);
        TestConstructorSearch.assertEquals((String)"wrong number of files containing references found", (int)3, (int)results.length);
    }

    public void testReferenceSearch01() throws Exception {
        int count = this.runSearchTest(this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"function " + this.getName() + "() {\n" + "\tthis.s = 5;\n" + "}\n" + "function x() {\n" + " var a = new " + this.getName() + "();\n" + " var b = new " + this.getName() + "();\n" + "}", ""}, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of references found", (int)2, (int)count);
    }

    public void testReferenceSearch02() throws Exception {
        int count = this.runSearchTest(this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"function " + this.getName() + "() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new " + this.getName() + "();\n"}, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of files containing references found", (int)1, (int)count);
    }

    public void testReferenceSearch03() throws Exception {
        int count = this.runSearchTest("pkg." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n" + "function x() {\n" + " var a = new " + "pkg." + this.getName() + "();\n" + " var b = new " + "pkg." + this.getName() + "();\n" + "}", ""}, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of references found", (int)2, (int)count);
    }

    public void testReferenceSearch04() throws Exception {
        int count = this.runSearchTest("pkg." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new pkg." + this.getName() + "();\n"}, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of files containing references found", (int)1, (int)count);
    }

    public void testReferenceSearch05() throws Exception {
        int count = this.runSearchTest("pkg." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n" + "function x() {\n" + " var a = new " + "pkg." + this.getName() + "();\n" + " var b = new " + "pkg." + this.getName() + "();\n" + "}", "c = new pkg." + this.getName() + "();\n"}, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of references found", (int)3, (int)count);
    }

    public void testReferenceSearch06() throws Exception {
        SearchMatch[] results = this.runSearchTest("pkg." + this.getName(), String.valueOf(this.getName().substring(0, 5)) + "*", new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new pkg." + this.getName() + "();\n"}, 3, 2, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of files containing references found", (int)1, (int)results.length);
    }

    public void testReferenceSearch07() throws Exception {
        SearchMatch[] results = this.runSearchTest("pkg." + this.getName(), String.valueOf(this.getName().substring(0, 7)) + "*", new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new pkg." + this.getName() + "();\n"}, 3, 2, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of files containing references found", (int)1, (int)results.length);
    }

    public void testReferenceSearch08() throws Exception {
        SearchMatch[] results = this.runSearchTest("pkg." + this.getName(), "*." + this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n" + "pkg2." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new pkg." + this.getName() + "();\n" + "var b = new " + "pkg2." + this.getName() + "();\n"}, 3, 2, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of files containing references found", (int)2, (int)results.length);
    }

    public void testOccurrencesSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest("pkg." + this.getName(), String.valueOf(this.getName().substring(0, 7)) + "*", new String[]{"X.js", "Y.js"}, new String[]{"function " + this.getName() + "() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new " + this.getName() + "();\n"}, 3, 3, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of files containing references found", (int)2, (int)results.length);
    }

    public void testOccurrencesSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest("pkg." + this.getName(), "p*.*", new String[]{"X.js", "Y.js"}, new String[]{"pkg." + this.getName() + " = function() {\n" + "\tthis.s = 5;\n" + "}\n", "var a = new pkg." + this.getName() + "();\n"}, 3, 3, 2);
        TestConstructorSearch.assertEquals((String)"wrong number of files containing references found", (int)2, (int)results.length);
    }
}

