/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.search;

import junit.framework.TestCase;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;

public class TestMethodPattern
extends TestCase {
    public void testCreateIndexKey_0() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/////", "myFunction".toCharArray(), null, null, null, null, 0);
    }

    public void testCreateIndexKey_1() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/////", "myFunction".toCharArray(), null, null, null, null, 0);
    }

    public void testCreateIndexKey_2() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction///String//", "myFunction".toCharArray(), null, null, null, "String".toCharArray(), 0);
    }

    public void testCreateIndexKey_3() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction////foo.bar.Type/", "myFunction".toCharArray(), null, null, "foo.bar.Type".toCharArray(), null, 8);
    }

    public void testCreateIndexKey_4() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction///String/foo.bar.Type/", "myFunction".toCharArray(), null, null, "foo.bar.Type".toCharArray(), "String".toCharArray(), 8);
    }

    public void testCreateIndexKey_5() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction//param1,param2///", "myFunction".toCharArray(), null, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, null, 0);
    }

    public void testCreateIndexKey_6() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction//param1,param2/String//", "myFunction".toCharArray(), null, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, "String".toCharArray(), 0);
    }

    public void testCreateIndexKey_7() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction//param1,param2//foo.bar.Type/", "myFunction".toCharArray(), null, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), null, 8);
    }

    public void testCreateIndexKey_8() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction//param1,param2/String/foo.bar.Type/", "myFunction".toCharArray(), null, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), "String".toCharArray(), 8);
    }

    public void testCreateIndexKey_9() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,Number/param1,param2///", "myFunction".toCharArray(), new char[][]{"String".toCharArray(), "Number".toCharArray()}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, null, 0);
    }

    public void testCreateIndexKey_10() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,Number/param1,param2/String//", "myFunction".toCharArray(), new char[][]{"String".toCharArray(), "Number".toCharArray()}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, "String".toCharArray(), 0);
    }

    public void testCreateIndexKey_11() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,Number/param1,param2//foo.bar.Type/", "myFunction".toCharArray(), new char[][]{"String".toCharArray(), "Number".toCharArray()}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), null, 8);
    }

    public void testCreateIndexKey_12() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,Number/param1,param2/String/foo.bar.Type/", "myFunction".toCharArray(), new char[][]{"String".toCharArray(), "Number".toCharArray()}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), "String".toCharArray(), 8);
    }

    public void testCreateIndexKey_13() {
        char[][] cArrayArray = new char[2][];
        cArrayArray[1] = "Number".toCharArray();
        TestMethodPattern.runCreateIndexKeyTest("myFunction/,Number/param1,param2///", "myFunction".toCharArray(), cArrayArray, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, null, 0);
    }

    public void testCreateIndexKey_14() {
        char[][] cArrayArray = new char[2][];
        cArrayArray[1] = "Number".toCharArray();
        TestMethodPattern.runCreateIndexKeyTest("myFunction/,Number/param1,param2/String//", "myFunction".toCharArray(), cArrayArray, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, "String".toCharArray(), 0);
    }

    public void testCreateIndexKey_15() {
        char[][] cArrayArray = new char[2][];
        cArrayArray[1] = "Number".toCharArray();
        TestMethodPattern.runCreateIndexKeyTest("myFunction/,Number/param1,param2//foo.bar.Type/", "myFunction".toCharArray(), cArrayArray, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), null, 8);
    }

    public void testCreateIndexKey_16() {
        char[][] cArrayArray = new char[2][];
        cArrayArray[1] = "Number".toCharArray();
        TestMethodPattern.runCreateIndexKeyTest("myFunction/,Number/param1,param2/String/foo.bar.Type/", "myFunction".toCharArray(), cArrayArray, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), "String".toCharArray(), 8);
    }

    public void testCreateIndexKey_17() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/,Number/param1,param2///", "myFunction".toCharArray(), new char[][]{new char[0], "Number".toCharArray()}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, null, 0);
    }

    public void testCreateIndexKey_18() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/,Number/param1,param2/String//", "myFunction".toCharArray(), new char[][]{new char[0], "Number".toCharArray()}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, "String".toCharArray(), 0);
    }

    public void testCreateIndexKey_19() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/,Number/param1,param2//foo.bar.Type/", "myFunction".toCharArray(), new char[][]{new char[0], "Number".toCharArray()}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), null, 8);
    }

    public void testCreateIndexKey_20() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/,Number/param1,param2/String/foo.bar.Type/", "myFunction".toCharArray(), new char[][]{new char[0], "Number".toCharArray()}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), "String".toCharArray(), 8);
    }

    public void testCreateIndexKey_21() {
        char[][] cArrayArray = new char[2][];
        cArrayArray[0] = "String".toCharArray();
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,/param1,param2///", "myFunction".toCharArray(), cArrayArray, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, null, 0);
    }

    public void testCreateIndexKey_22() {
        char[][] cArrayArray = new char[2][];
        cArrayArray[0] = "String".toCharArray();
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,/param1,param2/String//", "myFunction".toCharArray(), cArrayArray, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, "String".toCharArray(), 0);
    }

    public void testCreateIndexKey_23() {
        char[][] cArrayArray = new char[2][];
        cArrayArray[0] = "String".toCharArray();
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,/param1,param2//foo.bar.Type/", "myFunction".toCharArray(), cArrayArray, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), null, 8);
    }

    public void testCreateIndexKey_24() {
        char[][] cArrayArray = new char[2][];
        cArrayArray[0] = "String".toCharArray();
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,/param1,param2/String/foo.bar.Type/", "myFunction".toCharArray(), cArrayArray, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), "String".toCharArray(), 8);
    }

    public void testCreateIndexKey_25() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,/param1,param2///", "myFunction".toCharArray(), new char[][]{"String".toCharArray(), new char[0]}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, null, 0);
    }

    public void testCreateIndexKey_26() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,/param1,param2/String//", "myFunction".toCharArray(), new char[][]{"String".toCharArray(), new char[0]}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, null, "String".toCharArray(), 0);
    }

    public void testCreateIndexKey_27() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,/param1,param2//foo.bar.Type/", "myFunction".toCharArray(), new char[][]{"String".toCharArray(), new char[0]}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), null, 8);
    }

    public void testCreateIndexKey_28() {
        TestMethodPattern.runCreateIndexKeyTest("myFunction/String,/param1,param2/String/foo.bar.Type/", "myFunction".toCharArray(), new char[][]{"String".toCharArray(), new char[0]}, new char[][]{"param1".toCharArray(), "param2".toCharArray()}, "foo.bar.Type".toCharArray(), "String".toCharArray(), 8);
    }

    public void testCreateIndexKey_29() {
        char[] keyChars = MethodPattern.createIndexKey((char[])"".toCharArray(), (char[][])new char[][]{"String".toCharArray(), new char[0]}, (char[][])new char[][]{"param1".toCharArray(), "param2".toCharArray()}, (char[])"foo.bar.Type".toCharArray(), (char[])"String".toCharArray(), (int)8);
        String key = null;
        if (keyChars != null) {
            key = new String(keyChars);
        }
        TestMethodPattern.assertNull((String)("If selector is empty the key should be null.\nWAS:\n" + key), (Object)key);
    }

    public void testCreateIndexKey_30() {
        char[] keyChars = MethodPattern.createIndexKey(null, (char[][])new char[][]{"String".toCharArray(), new char[0]}, (char[][])new char[][]{"param1".toCharArray(), "param2".toCharArray()}, (char[])"foo.bar.Type".toCharArray(), (char[])"String".toCharArray(), (int)8);
        String key = null;
        if (keyChars != null) {
            key = new String(keyChars);
        }
        TestMethodPattern.assertNull((String)("If selector is empty the key should be null.\nWAS:\n" + key), (Object)key);
    }

    public void testDecodeIndexKey_0() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction////", "myFunction", null, null, null, null, null, null, null, 0);
    }

    public void testDecodeIndexKey_2() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction///String/", "myFunction", null, null, null, null, "String", null, null, 0);
    }

    public void testDecodeIndexKey_3() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction////foo.bar.Type", "myFunction", null, null, null, null, null, "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_4() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction///String/foo.bar.Type", "myFunction", null, null, null, null, "String", "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_5() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction//param1,param2//", "myFunction", new String[2], new String[2], new String[]{"param1", "param2"}, null, null, null, null, 0);
    }

    public void testDecodeIndexKey_6() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction//param1,param2/String/", "myFunction", new String[2], new String[2], new String[]{"param1", "param2"}, null, "String", null, null, 0);
    }

    public void testDecodeIndexKey_7() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction//param1,param2//foo.bar.Type", "myFunction", new String[2], new String[2], new String[]{"param1", "param2"}, null, null, "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_8() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction//param1,param2/String/foo.bar.Type", "myFunction", new String[2], new String[2], new String[]{"param1", "param2"}, null, "String", "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_9() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/String,Number/param1,param2//", "myFunction", new String[2], new String[]{"String", "Number"}, new String[]{"param1", "param2"}, null, null, null, null, 0);
    }

    public void testDecodeIndexKey_10() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/String,Number/param1,param2/String/", "myFunction", new String[2], new String[]{"String", "Number"}, new String[]{"param1", "param2"}, null, "String", null, null, 0);
    }

    public void testDecodeIndexKey_11() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/String,Number/param1,param2//foo.bar.Type", "myFunction", new String[2], new String[]{"String", "Number"}, new String[]{"param1", "param2"}, null, null, "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_12() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/String,Number/param1,param2/String/foo.bar.Type", "myFunction", new String[2], new String[]{"String", "Number"}, new String[]{"param1", "param2"}, null, "String", "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_13() {
        String[] stringArray = new String[2];
        stringArray[1] = "Number";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/,Number/param1,param2//", "myFunction", new String[2], stringArray, new String[]{"param1", "param2"}, null, null, null, null, 0);
    }

    public void testDecodeIndexKey_14() {
        String[] stringArray = new String[2];
        stringArray[1] = "Number";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/,Number/param1,param2/String/", "myFunction", new String[2], stringArray, new String[]{"param1", "param2"}, null, "String", null, null, 0);
    }

    public void testDecodeIndexKey_15() {
        String[] stringArray = new String[2];
        stringArray[1] = "Number";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/,Number/param1,param2//foo.bar.Type", "myFunction", new String[2], stringArray, new String[]{"param1", "param2"}, null, null, "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_16() {
        String[] stringArray = new String[2];
        stringArray[1] = "Number";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/,Number/param1,param2/String/foo.bar.Type", "myFunction", new String[2], stringArray, new String[]{"param1", "param2"}, null, "String", "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_17() {
        String[] stringArray = new String[2];
        stringArray[0] = "String";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/String,/param1,param2//", "myFunction", new String[2], stringArray, new String[]{"param1", "param2"}, null, null, null, null, 0);
    }

    public void testDecodeIndexKey_18() {
        String[] stringArray = new String[2];
        stringArray[0] = "String";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/String,/param1,param2/String/", "myFunction", new String[2], stringArray, new String[]{"param1", "param2"}, null, "String", null, null, 0);
    }

    public void testDecodeIndexKey_19() {
        String[] stringArray = new String[2];
        stringArray[0] = "String";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/String,/param1,param2//foo.bar.Type", "myFunction", new String[2], stringArray, new String[]{"param1", "param2"}, null, null, "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_20() {
        String[] stringArray = new String[2];
        stringArray[0] = "String";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/String,/param1,param2/String/foo.bar.Type", "myFunction", new String[2], stringArray, new String[]{"param1", "param2"}, null, "String", "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_21() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/bar.foo.String,neto.crazy.Number/param1,param2//", "myFunction", new String[]{"bar.foo", "neto.crazy"}, new String[]{"String", "Number"}, new String[]{"param1", "param2"}, null, null, null, null, 0);
    }

    public void testDecodeIndexKey_22() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/bar.foo.String,neto.crazy.Number/param1,param2/String/", "myFunction", new String[]{"bar.foo", "neto.crazy"}, new String[]{"String", "Number"}, new String[]{"param1", "param2"}, null, "String", null, null, 0);
    }

    public void testDecodeIndexKey_23() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/bar.foo.String,neto.crazy.Number/param1,param2//foo.bar.Type", "myFunction", new String[]{"bar.foo", "neto.crazy"}, new String[]{"String", "Number"}, new String[]{"param1", "param2"}, null, null, "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_24() {
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/bar.foo.String,neto.crazy.Number/param1,param2/String/foo.bar.Type", "myFunction", new String[]{"bar.foo", "neto.crazy"}, new String[]{"String", "Number"}, new String[]{"param1", "param2"}, null, "String", "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_25() {
        String[] stringArray = new String[2];
        stringArray[1] = "neto.crazy";
        String[] stringArray2 = new String[2];
        stringArray2[1] = "Number";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/,neto.crazy.Number/param1,param2//", "myFunction", stringArray, stringArray2, new String[]{"param1", "param2"}, null, null, null, null, 0);
    }

    public void testDecodeIndexKey_26() {
        String[] stringArray = new String[2];
        stringArray[1] = "neto.crazy";
        String[] stringArray2 = new String[2];
        stringArray2[1] = "Number";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/,neto.crazy.Number/param1,param2/String/", "myFunction", stringArray, stringArray2, new String[]{"param1", "param2"}, null, "String", null, null, 0);
    }

    public void testDecodeIndexKey_27() {
        String[] stringArray = new String[2];
        stringArray[1] = "neto.crazy";
        String[] stringArray2 = new String[2];
        stringArray2[1] = "Number";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/,neto.crazy.Number/param1,param2//foo.bar.Type", "myFunction", stringArray, stringArray2, new String[]{"param1", "param2"}, null, null, "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_28() {
        String[] stringArray = new String[2];
        stringArray[1] = "neto.crazy";
        String[] stringArray2 = new String[2];
        stringArray2[1] = "Number";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/,neto.crazy.Number/param1,param2/String/foo.bar.Type", "myFunction", stringArray, stringArray2, new String[]{"param1", "param2"}, null, "String", "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_29() {
        String[] stringArray = new String[2];
        stringArray[0] = "bar.foo";
        String[] stringArray2 = new String[2];
        stringArray2[0] = "String";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/bar.foo.String,/param1,param2//", "myFunction", stringArray, stringArray2, new String[]{"param1", "param2"}, null, null, null, null, 0);
    }

    public void testDecodeIndexKey_30() {
        String[] stringArray = new String[2];
        stringArray[0] = "bar.foo";
        String[] stringArray2 = new String[2];
        stringArray2[0] = "String";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/bar.foo.String,/param1,param2/String/", "myFunction", stringArray, stringArray2, new String[]{"param1", "param2"}, null, "String", null, null, 0);
    }

    public void testDecodeIndexKey_31() {
        String[] stringArray = new String[2];
        stringArray[0] = "bar.foo";
        String[] stringArray2 = new String[2];
        stringArray2[0] = "String";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/bar.foo.String,/param1,param2//foo.bar.Type", "myFunction", stringArray, stringArray2, new String[]{"param1", "param2"}, null, null, "foo.bar", "Type", 0);
    }

    public void testDecodeIndexKey_32() {
        String[] stringArray = new String[2];
        stringArray[0] = "bar.foo";
        String[] stringArray2 = new String[2];
        stringArray2[0] = "String";
        TestMethodPattern.runDecodeIndexKeyTest("myFunction/bar.foo.String,/param1,param2/String/foo.bar.Type", "myFunction", stringArray, stringArray2, new String[]{"param1", "param2"}, null, "String", "foo.bar", "Type", 0);
    }

    private static void runCreateIndexKeyTest(String expected, char[] selector, char[][] parameterFullTypeNames, char[][] parameterNames, char[] declaringFullTypeName, char[] returnFullTypeName, int modifiers) {
        char[] indexKey = MethodPattern.createIndexKey((char[])selector, (char[][])parameterFullTypeNames, (char[][])parameterNames, (char[])declaringFullTypeName, (char[])returnFullTypeName, (int)modifiers);
        String expectedWithModifiers = String.valueOf(expected) + (char)modifiers + (char)(modifiers >> 16);
        TestMethodPattern.assertNotNull((String)("The created index key should not be null.\nEXPECTED:\n" + expectedWithModifiers), (Object)indexKey);
        TestMethodPattern.assertTrue((String)("The expected index key does not match the generated index key.\nWAS:\n" + new String(indexKey) + "\nEXPECTED:\n" + expected), (boolean)CharOperation.equals((char[])indexKey, (char[])expectedWithModifiers.toCharArray()));
    }

    private static void runDecodeIndexKeyTest(String key, String selector, String[] parameterQualifications, String[] parameterSimpleNames, String[] parameterNames, String returnQualification, String returnSimpleName, String declaringQualification, String declaringSimpleName, int modifiers) {
        char[] keyWithModifiers = new char[key.length() + 3];
        System.arraycopy(key.toCharArray(), 0, keyWithModifiers, 0, key.length());
        keyWithModifiers[keyWithModifiers.length - 3] = 47;
        keyWithModifiers[keyWithModifiers.length - 2] = (char)modifiers;
        keyWithModifiers[keyWithModifiers.length - 1] = (char)(modifiers >> 16);
        MethodPattern pattern = new MethodPattern(false, false, false, null, 0);
        pattern = (MethodPattern)pattern.getBlankPattern();
        pattern.decodeIndexKey(keyWithModifiers);
        TestMethodPattern.assertEquals("Expected selector does not equal decoded selector.", selector, pattern.selector);
        TestMethodPattern.assertEquals("Expected parameter qualifications does not equal decoded parameter qualifications.", parameterQualifications, pattern.parameterQualifications);
        TestMethodPattern.assertEquals("Expected parameter simple names does not equal decoded parameter simple names.", parameterSimpleNames, pattern.parameterSimpleNames);
        TestMethodPattern.assertEquals("Expected parameter names does not equal decoded parameter names.", parameterNames, pattern.parameterNames);
        TestMethodPattern.assertEquals("Expected return qualification does not equal decoded return wualification.", returnQualification, pattern.returnQualification);
        TestMethodPattern.assertEquals("Expected return simple name does not equal decoded return simple name.", returnSimpleName, pattern.returnSimpleName);
        TestMethodPattern.assertEquals("Expected declaring qualification does not equal decoded declaring qualification.", declaringQualification, pattern.getDeclaringQualification());
        TestMethodPattern.assertEquals("Expected declaring simple name does not equal decoded declaring simple name.", declaringSimpleName, pattern.getDeclaringSimpleName());
    }

    private static void assertEquals(String message, String expected, char[] chars) {
        String actual = null;
        if (chars != null) {
            actual = new String(chars);
        }
        TestMethodPattern.assertEquals((String)message, (String)expected, actual);
    }

    private static void assertEquals(String message, String[] expected, char[][] actual) {
        char[] actualColappsedChars;
        String expectedColappsed = null;
        String actualColappsed = null;
        if (actual != null && (actualColappsedChars = CharOperation.concatWith((char[][])actual, (char)',', (boolean)false)) != null) {
            actualColappsed = new String(actualColappsedChars);
        }
        if (expected != null) {
            expectedColappsed = "";
            int i = 0;
            while (i < expected.length) {
                if (i > 0) {
                    expectedColappsed = String.valueOf(expectedColappsed) + ",";
                }
                if (expected[i] != null) {
                    expectedColappsed = String.valueOf(expectedColappsed) + expected[i];
                }
                ++i;
            }
        }
        TestMethodPattern.assertEquals((String)message, (String)expectedColappsed, actualColappsed);
    }
}

