/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceManipulation;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.CopyMoveTests;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CopyMoveResourcesTests
extends CopyMoveTests {
    static /* synthetic */ Class class$0;

    public CopyMoveResourcesTests(String name) {
        super(name);
    }

    public IJavaScriptElement copyPositive(IJavaScriptElement element, IJavaScriptElement container, IJavaScriptElement sibling, String rename, boolean force) throws JavaScriptModelException {
        IJavaScriptElement iJavaScriptElement;
        try {
            IJavaScriptElementDelta destDelta;
            this.startDeltas();
            if (force) {
                IJavaScriptElement collision = this.generateHandle(element, rename, container);
                CopyMoveResourcesTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
            }
            ((ISourceManipulation)element).copy(container, sibling, rename, force, null);
            CopyMoveResourcesTests.assertTrue((String)"The original element must still exist", (boolean)element.exists());
            IJavaScriptElement copy = this.generateHandle(element, rename, container);
            CopyMoveResourcesTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
            if (element.getElementType() > 5) {
                this.ensureCorrectPositioning((IParent)container, sibling, copy);
            }
            CopyMoveResourcesTests.assertTrue((String)"Destination container not changed", ((destDelta = this.getDeltaFor(container, true)) != null && destDelta.getKind() == 4 ? 1 : 0) != 0);
            IJavaScriptElementDelta[] deltas = destDelta.getAddedChildren();
            boolean found = false;
            int i = 0;
            while (i < deltas.length) {
                if (deltas[i].getElement().equals(copy)) {
                    found = true;
                }
                ++i;
            }
            CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)found);
            iJavaScriptElement = copy;
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.stopDeltas();
            throw throwable;
        }
        this.stopDeltas();
        return iJavaScriptElement;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void movePositive(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, IJavaScriptElement[] siblings, String[] names, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            int i;
            this.startDeltas();
            if (force) {
                i = 0;
                while (i < elements.length) {
                    IJavaScriptElement e = elements[i];
                    IJavaScriptElement collision = null;
                    collision = names == null ? this.generateHandle(e, null, destinations[i]) : this.generateHandle(e, names[i], destinations[i]);
                    CopyMoveResourcesTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
                    ++i;
                }
            }
            this.getJavaModel().move(elements, destinations, siblings, names, force, monitor);
            i = 0;
            while (i < elements.length) {
                IJavaScriptElementDelta[] deltas;
                IJavaScriptElement element = elements[i];
                IJavaScriptElement moved = null;
                moved = names == null ? this.generateHandle(element, null, destinations[i]) : this.generateHandle(element, names[i], destinations[i]);
                if (!(destinations[i].equals(element.getParent()) || element.getElementType() == 5 && ((IJavaScriptUnit)element).isWorkingCopy())) {
                    CopyMoveResourcesTests.assertTrue((String)"The original element must not exist", (!element.exists() ? 1 : 0) != 0);
                }
                CopyMoveResourcesTests.assertTrue((String)"Moved element should exist", (boolean)moved.exists());
                IJavaScriptElementDelta destDelta = null;
                if (this.isMainType(element, destinations[i]) && names != null && names[i] != null) {
                    destDelta = this.getDeltaFor(moved.getParent());
                    CopyMoveResourcesTests.assertTrue((String)"Renamed compilation unit as result of main type not added", (destDelta != null && destDelta.getKind() == 1 ? 1 : 0) != 0);
                    deltas = destDelta.getAddedChildren();
                    CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)deltas[0].getElement().equals(moved));
                    CopyMoveResourcesTests.assertTrue((String)"flag should be F_MOVED_FROM", ((deltas[0].getFlags() & 0x10) > 0 ? 1 : 0) != 0);
                    CopyMoveResourcesTests.assertTrue((String)"moved from handle should be original", (boolean)deltas[0].getMovedFromElement().equals(element));
                } else {
                    IJavaScriptElementDelta pkgDelta;
                    destDelta = this.getDeltaFor(destinations[i], true);
                    CopyMoveResourcesTests.assertTrue((String)"Destination container not changed", (destDelta != null && destDelta.getKind() == 4 ? 1 : 0) != 0);
                    deltas = destDelta.getAddedChildren();
                    int j = 0;
                    while (true) {
                        if (j >= deltas.length - 1) {
                            pkgDelta = deltas[deltas.length - 1];
                            CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)pkgDelta.getElement().equals(moved));
                        }
                        IJavaScriptElement pkg = deltas[j].getElement();
                        CopyMoveResourcesTests.assertTrue((String)"Side effect child should be a package fragment", (pkg.getElementType() == 4 ? 1 : 0) != 0);
                        CopyMoveResourcesTests.assertTrue((String)"Side effect child should be an enclosing package", (boolean)element.getElementName().startsWith(pkg.getElementName()));
                        ++j;
                    }
                    CopyMoveResourcesTests.assertTrue((String)"flag should be F_MOVED_FROM", ((pkgDelta.getFlags() & 0x10) > 0 ? 1 : 0) != 0);
                    CopyMoveResourcesTests.assertTrue((String)"moved from handle shoud be original", (boolean)pkgDelta.getMovedFromElement().equals(element));
                    IJavaScriptElementDelta sourceDelta = this.getDeltaFor(element, true);
                    CopyMoveResourcesTests.assertTrue((String)"moved to handle should be original", (boolean)sourceDelta.getMovedToElement().equals(moved));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        this.stopDeltas();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createJavaProject("P", new String[]{"src", "src2"});
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.CopyMoveResourcesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CopyMoveResourcesTests.buildModelTestSuite(clazz);
    }

    public void tearDown() throws Exception {
        this.deleteProject("P");
        super.tearDown();
    }

    public void testCopyCUAndType() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.copyNegative(new IJavaScriptElement[]{cuSource, cuSource.getType("X")}, new IJavaScriptElement[]{cuSource.getParent(), cuSource}, null, new String[]{"Y.js", "Y"}, false, 967);
    }

    public void testCopyCUForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, true);
    }

    public void testCopyCURename() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, "Y.js", false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyCUReadOnly() throws CoreException {
        IFile file2;
        block7: {
            if (!Util.isReadOnlySupported()) {
                return;
            }
            IFile file = null;
            file2 = null;
            try {
                this.createFolder("/P/src/p1");
                file = this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
                Util.setReadOnly((IResource)file, (boolean)true);
                IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
                this.createFolder("/P/src/p2");
                IPackageFragment pkgDest = this.getPackage("/P/src/p2");
                this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, false);
                file2 = this.getFile("/P/src/p2/X.js");
                CopyMoveResourcesTests.assertTrue((String)"Destination cu should be read-only", (boolean)file2.isReadOnly());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (file != null) {
                    Util.setReadOnly((IResource)file, (boolean)false);
                }
                if (file2 != null) {
                    Util.setReadOnly(file2, (boolean)false);
                }
                this.deleteFolder("/P/src/p1");
                this.deleteFolder("/P/src/p2");
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (file == null) break block7;
            }
            Util.setReadOnly((IResource)file, (boolean)false);
        }
        if (file2 != null) {
            Util.setReadOnly((IResource)file2, (boolean)false);
        }
        this.deleteFolder("/P/src/p1");
        this.deleteFolder("/P/src/p2");
    }

    public void testCopyCURenameForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/Y.js", "package p2;\npublic class Y {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, "Y.js", true);
    }

    public void testCopyCUWithCollision() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyNegative((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, false, 977);
    }

    public void testCopyCUWithInvalidDestination() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.copyNegative((IJavaScriptElement)cuSource, (IJavaScriptElement)cuSource, null, null, false, 978);
    }

    public void testCopyCUWithNullContainer() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        try {
            cuSource.copy(null, null, null, false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        CopyMoveResourcesTests.assertTrue((String)"Should not be able to move a cu to a null container", (boolean)false);
    }

    public void testCopyCUWithServerProperties() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        QualifiedName qualifiedName = new QualifiedName("x.y.z", "a property");
        cuSource.getUnderlyingResource().setPersistentProperty(qualifiedName, "some value");
        this.createFolder("/P/src/p2");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, false);
        IJavaScriptUnit cu = pkgDest.getJavaScriptUnit("X.js");
        String propertyValue = cu.getUnderlyingResource().getPersistentProperty(qualifiedName);
        CopyMoveResourcesTests.assertEquals((String)"Server property should be copied with cu", (String)"some value", (String)propertyValue);
    }

    public void testCopyPackageFragment() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IPackageFragment pkgSource = this.getPackage("/P/src/p1");
        IPackageFragmentRoot rootDest = this.getPackageFragmentRoot("P", "src2");
        this.copyPositive((IJavaScriptElement)pkgSource, (IJavaScriptElement)rootDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyReadOnlyPackageFragment() throws CoreException {
        IFile xFile2;
        IPackageFragment p3Fragment2;
        IPackageFragment p1Fragment2;
        if (!Util.isReadOnlySupported()) {
            return;
        }
        IPackageFragment pkgSource = null;
        IPackageFragment pkg2 = null;
        try {
            this.createFolder("/P/src/p1/p2/p3");
            this.createFile("/P/src/p1/p2/p3/X.js", "package p1.p2.p3;\npublic class X {\n}");
            Util.setReadOnly((IResource)this.getFile("/P/src/p1/p2/p3/X.js"), (boolean)true);
            pkgSource = this.getPackage("/P/src/p1");
            Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)true);
            pkg2 = this.getPackage("/P/src/p1/p2/p3");
            Util.setReadOnly((IResource)pkg2.getResource(), (boolean)true);
            IPackageFragmentRoot rootDest = this.getPackageFragmentRoot("P", "src2");
            this.copyPositive((IJavaScriptElement)pkg2, (IJavaScriptElement)rootDest, null, null, false);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)Util.isReadOnly((IResource)this.getPackage("/P/src2/p1").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (!Util.isReadOnly((IResource)this.getPackage("/P/src2/p1/p2").getResource()) ? 1 : 0) != 0);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)Util.isReadOnly((IResource)this.getPackage("/P/src2/p1/p2/p3").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (boolean)Util.isReadOnly((IResource)this.getFile("/P/src2/p1/p2/p3/X.js")));
        }
        catch (Throwable throwable) {
            IFile xFile2;
            IPackageFragment p3Fragment2;
            IPackageFragment p1Fragment2;
            Object var4_5 = null;
            IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.js");
            if (xSrcFile != null) {
                Util.setReadOnly((IResource)xSrcFile, (boolean)false);
            }
            if (pkg2 != null) {
                Util.setReadOnly((IResource)pkg2.getResource(), (boolean)false);
            }
            if (pkgSource != null) {
                Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)false);
            }
            if ((p1Fragment2 = this.getPackage("/P/src2/p1")) != null) {
                Util.setReadOnly((IResource)p1Fragment2.getResource(), (boolean)false);
            }
            if ((p3Fragment2 = this.getPackage("/P/src2/p1/p2/p3")) != null) {
                Util.setReadOnly((IResource)p3Fragment2.getResource(), (boolean)false);
            }
            if ((xFile2 = this.getFile("/P/src2/p1/p2/p3/X.js")) != null) {
                Util.setReadOnly((IResource)xFile2, (boolean)false);
            }
            this.deleteFolder("/P/src/p1");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.js");
        if (xSrcFile != null) {
            Util.setReadOnly((IResource)xSrcFile, (boolean)false);
        }
        if (pkg2 != null) {
            Util.setReadOnly((IResource)pkg2.getResource(), (boolean)false);
        }
        if (pkgSource != null) {
            Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)false);
        }
        if ((p1Fragment2 = this.getPackage("/P/src2/p1")) != null) {
            Util.setReadOnly((IResource)p1Fragment2.getResource(), (boolean)false);
        }
        if ((p3Fragment2 = this.getPackage("/P/src2/p1/p2/p3")) != null) {
            Util.setReadOnly((IResource)p3Fragment2.getResource(), (boolean)false);
        }
        if ((xFile2 = this.getFile("/P/src2/p1/p2/p3/X.js")) != null) {
            Util.setReadOnly((IResource)xFile2, (boolean)false);
        }
        this.deleteFolder("/P/src/p1");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopy() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 84->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyDestination() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 103->107)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyForce() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 95->99)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyRename() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 86->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyRenameForce() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 97->101)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyWithCollision() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 97->101)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyWithInvalidDestination() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 69->73)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testMoveCUAndType() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.moveNegative(new IJavaScriptElement[]{cuSource, cuSource.getType("X")}, new IJavaScriptElement[]{cuSource.getParent(), cuSource}, null, new String[]{"Y.js", "Y"}, false, 967);
    }

    public void testMoveCUForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, true);
    }

    public void testMoveCURename() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, "Y.js", false);
    }

    public void testMoveCURenameForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/Y.js", "package p2;\npublic class Y {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, "Y.js", true);
    }

    public void testMoveCUWithCollision() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.moveNegative((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, false, 977);
    }

    public void testMoveCUWithInvalidDestination() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.moveNegative((IJavaScriptElement)cuSource, (IJavaScriptElement)cuSource, null, null, false, 978);
    }

    public void testMoveCUWithNullContainer() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        try {
            cuSource.move(null, null, null, false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        CopyMoveResourcesTests.assertTrue((String)"Should not be able to move a cu to a null container", (boolean)false);
    }

    public void testMovePackageFragment() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IPackageFragment pkgSource = this.getPackage("/P/src/p1");
        IPackageFragmentRoot rootDest = this.getPackageFragmentRoot("P", "src2");
        this.movePositive((IJavaScriptElement)pkgSource, (IJavaScriptElement)rootDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveReadOnlyPackageFragment() throws CoreException {
        IFile xFile2;
        IPackageFragment p3Fragment2;
        IPackageFragment p1Fragment2;
        if (!Util.isReadOnlySupported()) {
            return;
        }
        IPackageFragment pkgSource = null;
        IPackageFragment pkg2 = null;
        try {
            this.createFolder("/P/src/p1/p2/p3");
            this.createFile("/P/src/p1/p2/p3/X.js", "package p1.p2.p3;\npublic class X {\n}");
            Util.setReadOnly((IResource)this.getFile("/P/src/p1/p2/p3/X.js"), (boolean)true);
            pkgSource = this.getPackage("/P/src/p1");
            Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)true);
            pkg2 = this.getPackage("/P/src/p1/p2/p3");
            Util.setReadOnly((IResource)pkg2.getResource(), (boolean)true);
            IPackageFragmentRoot rootDest = this.getPackageFragmentRoot("P", "src2");
            this.movePositive((IJavaScriptElement)pkg2, (IJavaScriptElement)rootDest, null, null, false);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)Util.isReadOnly((IResource)this.getPackage("/P/src2/p1").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (!Util.isReadOnly((IResource)this.getPackage("/P/src2/p1/p2").getResource()) ? 1 : 0) != 0);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)Util.isReadOnly((IResource)this.getPackage("/P/src2/p1/p2/p3").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (boolean)Util.isReadOnly((IResource)this.getFile("/P/src2/p1/p2/p3/X.js")));
        }
        catch (Throwable throwable) {
            IFile xFile2;
            IPackageFragment p3Fragment2;
            IPackageFragment p1Fragment2;
            Object var4_5 = null;
            IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.js");
            if (xSrcFile != null) {
                Util.setReadOnly((IResource)xSrcFile, (boolean)false);
            }
            if (pkg2 != null) {
                Util.setReadOnly((IResource)pkg2.getResource(), (boolean)false);
            }
            if (pkgSource != null) {
                Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)false);
            }
            if ((p1Fragment2 = this.getPackage("/P/src2/p1")) != null) {
                Util.setReadOnly((IResource)p1Fragment2.getResource(), (boolean)false);
            }
            if ((p3Fragment2 = this.getPackage("/P/src2/p1/p2/p3")) != null) {
                Util.setReadOnly((IResource)p3Fragment2.getResource(), (boolean)false);
            }
            if ((xFile2 = this.getFile("/P/src2/p1/p2/p3/X.js")) != null) {
                Util.setReadOnly((IResource)xFile2, (boolean)false);
            }
            this.deleteFolder("/P/src/p1");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.js");
        if (xSrcFile != null) {
            Util.setReadOnly((IResource)xSrcFile, (boolean)false);
        }
        if (pkg2 != null) {
            Util.setReadOnly((IResource)pkg2.getResource(), (boolean)false);
        }
        if (pkgSource != null) {
            Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)false);
        }
        if ((p1Fragment2 = this.getPackage("/P/src2/p1")) != null) {
            Util.setReadOnly((IResource)p1Fragment2.getResource(), (boolean)false);
        }
        if ((p3Fragment2 = this.getPackage("/P/src2/p1/p2/p3")) != null) {
            Util.setReadOnly((IResource)p3Fragment2.getResource(), (boolean)false);
        }
        if ((xFile2 = this.getFile("/P/src2/p1/p2/p3/X.js")) != null) {
            Util.setReadOnly((IResource)xFile2, (boolean)false);
        }
        this.deleteFolder("/P/src/p1");
    }

    /*
     * Exception decompiling
     */
    public void testMoveWorkingCopy() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 86->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testMoveWorkingCopy2() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 106->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

