/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.ClasspathInitializerTests;
import org.eclipse.wst.jsdt.core.tests.model.ContainerInitializer;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.VariablesInitializer;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;

public class JavaSearchScopeTests
extends ModifyingResourceTests
implements IJavaScriptSearchConstants {
    static /* synthetic */ Class class$0;

    public JavaSearchScopeTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaSearchScopeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaSearchScopeTests.buildModelTestSuite(clazz);
    }

    protected void tearDown() throws Exception {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        manager.containers = new HashMap(5);
        manager.variables = new HashMap(5);
        super.tearDown();
    }

    protected void assertScopeEquals(String expected, IJavaScriptSearchScope scope) {
        String actual = scope.toString();
        if (!expected.equals(actual)) {
            System.out.println(String.valueOf(this.displayString(actual, 3)) + ",");
        }
        JavaSearchScopeTests.assertEquals((String)"Unexpected scope", (String)expected, (String)actual);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSources() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}, (int)1);
            this.assertScopeEquals("JavaSearchScope on [\n\t/P\n]", scope);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testApplicationLibrairiesExternalJar() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}, (int)2);
            this.assertScopeEquals("JavaSearchScope on [\n\t" + this.getExternalJCLPath("").toOSString() + "\n" + "]", scope);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testApplicationLibrairiesJarAndClassFolder() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, new String[]{"/P/internal.jar", "/P/classfolder"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}, (int)2);
            this.assertScopeEquals("JavaSearchScope on [\n\t/P/internal.jar\n\t/P/classfolder\n]", scope);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testApplicationLibrairiesClasspathVariable() throws CoreException {
        try {
            VariablesInitializer.setInitializer(new ClasspathInitializerTests.DefaultVariableInitializer(new String[]{"TEST_LIB", "/P/lib.jar"}));
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[]{"TEST_LIB"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}, (int)2);
            this.assertScopeEquals("JavaSearchScope on [\n\t/P/lib.jar\n]", scope);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            VariablesInitializer.reset();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
        VariablesInitializer.reset();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testApplicationLibrairiesJsGlobalScopeContainer() throws CoreException {
        try {
            ContainerInitializer.setInitializer(new ClasspathInitializerTests.DefaultContainerInitializer(new String[]{"P", "/P/lib.jar"}));
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}, (int)2);
            this.assertScopeEquals("JavaSearchScope on [\n\t/P/lib.jar\n]", scope);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSystemLibraries() throws CoreException {
        try {
            ClasspathInitializerTests.DefaultContainerInitializer intializer = new ClasspathInitializerTests.DefaultContainerInitializer(new String[]{"P", "/P/lib.jar"}){

                protected ClasspathInitializerTests.DefaultContainerInitializer.DefaultContainer newContainer(char[][] libPaths) {
                    return new ClasspathInitializerTests.DefaultContainerInitializer.DefaultContainer(this, libPaths){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int getKind() {
                            return 2;
                        }
                    };
                }
            };
            ContainerInitializer.setInitializer(intializer);
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}, (int)4);
            this.assertScopeEquals("JavaSearchScope on [\n\t/P/lib.jar\n]", scope);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSourcesOrDirectReferencedProjects() throws CoreException {
        try {
            this.createJavaProject("P1");
            IJavaScriptProject project = this.createJavaProject("P2", new String[]{"src"}, new String[0], new String[]{"/P1"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}, (int)9);
            this.assertScopeEquals("JavaSearchScope on [\n\t/P1\n\t/P2/src\n]", scope);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSourcesOrContainerReferencedProjects() throws CoreException {
        try {
            this.createJavaProject("P1");
            ContainerInitializer.setInitializer(new ClasspathInitializerTests.DefaultContainerInitializer(new String[]{"P2", "/P1"}));
            IJavaScriptProject project = this.createJavaProject("P2", new String[]{"src"}, new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project}, (int)9);
            this.assertScopeEquals("JavaSearchScope on [\n\t/P1\n\t/P2/src\n]", scope);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses01() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P\"", (boolean)scope.encloses("/P"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses02() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose P", (boolean)scope.encloses((IJavaScriptElement)project));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses03() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/\"", (boolean)scope.encloses("/P/"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses04() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)project.getProject());
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose root P", (boolean)scope.encloses((IJavaScriptElement)root));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses05() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/x/y\"", (boolean)scope.encloses("/P/x/y"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses06() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/x/y/\"", (boolean)scope.encloses("/P/x/y/"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses07() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragment pkg = this.getPackage("/P/x/y");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose package x.y", (boolean)scope.encloses((IJavaScriptElement)pkg));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses08() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragment pkg = this.getPackage("/P");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose default package", (boolean)scope.encloses((IJavaScriptElement)pkg));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses09() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/x/y/A.java\"", (boolean)scope.encloses("/P/x/y/A.js"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses10() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/x/y/A.js");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose compilation unit A.js", (boolean)scope.encloses((IJavaScriptElement)cu));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses11() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/A.java\"", (boolean)scope.encloses("/P/A.js"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses12() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/A.js");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose compilation unit A.js", (boolean)scope.encloses((IJavaScriptElement)cu));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses13() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/x/y/A.js");
            IType type = cu.getType("A");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose type A", (boolean)scope.encloses((IJavaScriptElement)type));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses14() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertFalse((String)"scope on P should not enclose \"/P\"", (boolean)scope.encloses("/P"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses14b() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertFalse((String)"scope on P should not enclose \"/\"", (boolean)scope.encloses("/"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses14c() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertFalse((String)"scope on P should not enclose \"\"", (boolean)scope.encloses(""));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses15() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertFalse((String)"scope on P should enclose P", (boolean)scope.encloses((IJavaScriptElement)project));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses16() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src\"", (boolean)scope.encloses("/P/src"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses17() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/\"", (boolean)scope.encloses("/P/src/"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses18() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)project.getProject().getFolder("src"));
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose root P/src", (boolean)scope.encloses((IJavaScriptElement)root));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses19() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/x/y\"", (boolean)scope.encloses("/P/src/x/y"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses20() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/x/y/\"", (boolean)scope.encloses("/P/src/x/y/"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses21() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragment pkg = this.getPackage("/P/src/x/y");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose package x.y", (boolean)scope.encloses((IJavaScriptElement)pkg));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses22() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragment pkg = this.getPackage("/P/src");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose default package", (boolean)scope.encloses((IJavaScriptElement)pkg));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses23() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/x/y/A.java\"", (boolean)scope.encloses("/P/src/x/y/A.js"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses24() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src/x/y/A.js");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose compilation unit A.js", (boolean)scope.encloses((IJavaScriptElement)cu));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses25() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/A.java\"", (boolean)scope.encloses("/P/src/A.js"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses26() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src/A.js");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose compilation unit A.js", (boolean)scope.encloses((IJavaScriptElement)cu));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses27() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src/x/y/A.js");
            IType type = cu.getType("A");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose type A", (boolean)scope.encloses((IJavaScriptElement)type));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses28() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertFalse((String)"scope on P should not enclose \"/P\"", (boolean)scope.encloses("/P"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses28b() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertFalse((String)"scope on P should not enclose \"/P\"", (boolean)scope.encloses("/"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses28c() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertFalse((String)"scope on P should not enclose \"/P\"", (boolean)scope.encloses(""));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses29() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertFalse((String)"scope on P should enclose P", (boolean)scope.encloses((IJavaScriptElement)project));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses30() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src\"", (boolean)scope.encloses("/P/src"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses31() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/\"", (boolean)scope.encloses("/P/src/"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses32() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)project.getProject().getFolder("src"));
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose root P/src", (boolean)scope.encloses((IJavaScriptElement)root));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses33() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/x/y\"", (boolean)scope.encloses("/P/src/x/y"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses34() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/x/y/\"", (boolean)scope.encloses("/P/src/x/y/"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses35() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragment pkg = this.getPackage("/P/src/x/y");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose package x.y", (boolean)scope.encloses((IJavaScriptElement)pkg));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses36() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IPackageFragment pkg = this.getPackage("/P/src");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose default package", (boolean)scope.encloses((IJavaScriptElement)pkg));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses37() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/x/y/A.java\"", (boolean)scope.encloses("/P/src/x/y/A.js"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses38() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src/x/y/A.js");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose compilation unit A.js", (boolean)scope.encloses((IJavaScriptElement)cu));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses39() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose \"/P/src/A.java\"", (boolean)scope.encloses("/P/src/A.js"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses40() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src/A.js");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose compilation unit A.js", (boolean)scope.encloses((IJavaScriptElement)cu));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScopeEncloses41() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src/"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src/x/y/A.js");
            IType type = cu.getType("A");
            JavaSearchScopeTests.assertTrue((String)"scope on P should enclose type A", (boolean)scope.encloses((IJavaScriptElement)type));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug101022() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P1", new String[]{"src", "test", "test2"});
            this.createFile("/P1/src/Test.js", "public class Test {\n\tprotected void foo() {}\n}");
            this.createFile("/P1/test/Test.js", "public class Test {\n\tprotected void foo() {}\n}");
            this.createFile("/P1/test2/Test.js", "public class Test {\n\tprotected void foo() {}\n}");
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFolder("/P1/test"));
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{root});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search("foo", 1, 0, scope, (SearchRequestor)resultCollector);
            this.assertSearchResults("test/Test.java [in P1] void Test.foo() [foo]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug101426() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P1", new String[]{"src/", "test/", "test2/"}, new String[]{"JCL_LIB"});
            this.createFile("/P1/src/Test.js", "public interface ITest {\n}");
            this.createFile("/P1/test/Test.js", "public class Test {\n\tITest test;\n}");
            this.createFile("/P1/test2/Test.js", "public class Test2 {\n\tITest test;\n}");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search("ITest", 0, 2, scope, (SearchRequestor)resultCollector);
            this.assertSearchResults("test/Test.java [in P1] Test.test [ITest]\ntest2/Test.java [in P1] Test2.test [ITest]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug101777() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P1");
            this.createFile("/P1/Test.js", "public class Test {\n\tpublic static void main(String[] args) {}\n}");
            IPackageFragment[] fragments = project.getPackageFragments();
            IPackageFragment defaultFragment = null;
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                if (fragment.getElementName().length() == 0) {
                    defaultFragment = fragment;
                    break;
                }
                ++i;
            }
            JavaSearchScopeTests.assertNotNull((String)"We should have a default fragment for project P1!", defaultFragment);
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{defaultFragment});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search("main(String[]) void", 1, 0, scope, (SearchRequestor)resultCollector);
            this.assertSearchResults("Test.java [in P1] void Test.main(String[]) [main]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug119203() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P1", new String[]{"src"});
            this.createFile("/P1/src/Test.js", "public class Test {\n}");
            this.createFile("/P1/src/X.js", "public class X {\n\tTest test;\n}");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search("Test", 0, 2, scope, (SearchRequestor)resultCollector);
            this.assertSearchResults("src/X.java [in P1] X.test [Test]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P1");
    }
}

