/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class StaticTests
extends TestCase {
    private static final String TEST_NAME = "Test Static vs Non Static JavaScript Content Assist";
    private static TestProjectSetup fTestProjectSetup;
    static /* synthetic */ Class class$0;

    public StaticTests() {
        super(TEST_NAME);
    }

    public StaticTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.ui.tests.contentassist.StaticTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false);
        return fTestProjectSetup;
    }

    public void testStatic_CamelCase_OtherFile_BeforeOpen_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"yahooDotCom : Server - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 2, 3, expectedProposals);
    }

    public void testStatic_CamelCase_OtherFile_BeforeOpen_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"clientIP : String - Server"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 4, 15, expectedProposals);
    }

    public void testStatic_OtherFile_BeforeOpen_ExpressionStarted_5() throws Exception {
        String[][] expectedProposals = new String[][]{{"serverIP : String - Server"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 8, 8, expectedProposals);
    }

    public void testStatic_NegativeTest_OtherFile_BeforeOpen_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"getServerIP() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 6, 13, expectedProposals, true, false);
    }

    public void testStatic_NegativeTest_OtherFile_BeforeOpen_ExpressionStarted_5() throws Exception {
        String[][] expectedProposals = new String[][]{{"clientIP : String - Server", "getClientIP() - Global", "getClientPort() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 8, 8, expectedProposals, true, false);
    }

    public void testStatic_CamelCase_ThisFile_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"yahooDotCom : Server - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_0.js", 30, 3, expectedProposals);
    }

    public void testStatic_CamelCase_ThisFile_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"clientIP : String - Server"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_0.js", 32, 15, expectedProposals);
    }

    public void testStatic_ThisFile_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"clientIP : String - Server", "port - Server", "prototype - Server", "getClientIP() : String - Server", "getClientPort() - Server"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_0.js", 34, 12, expectedProposals);
    }

    public void testStatic_CamelCase_OtherFile_AfterOpen_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"yahooDotCom : Server - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 2, 3, expectedProposals);
    }

    public void testStatic_CamelCase_OtherFile_AfterOpen_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"clientIP : String - Server"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 4, 15, expectedProposals);
    }

    public void testStatic_OtherFile_AfterOpen_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"clientIP : String - Server", "port - Server", "prototype - Server", "getClientIP() : String - Server", "getClientPort() - Server"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 6, 12, expectedProposals);
    }

    public void testStatic_NegativeTest_OtherFile_AfterOpen_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"getServerIP() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 6, 12, expectedProposals, true, false);
    }

    public void testStatic_NegativeTest_OtherFile_AfterOpen_ExpressionStarted_5() throws Exception {
        String[][] expectedProposals = new String[][]{{"clientIP : String - Server", "getClientIP() - Global", "getClientPort() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 8, 7, expectedProposals, true, false);
    }
}

