/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.commands.nav.CaretPositionTracker;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.tools.ExposeHelper;
import org.eclipse.jst.pagedesigner.viewer.CaretUpdater;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewerListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class HTMLGraphicalViewer
extends ScrollingGraphicalViewer
implements IHTMLGraphicalViewer,
CaretPositionTracker {
    private IEditorPart _parentPart;
    private Caret _caret;
    private boolean _rangeMode = false;
    private DesignRange _selectionRange = null;
    private int _inBatch = 0;
    private final CaretUpdater _caretUpdater;
    private int _xOffset;
    private final List<IHTMLGraphicalViewerListener> _htmlViewerListeners;

    public HTMLGraphicalViewer(IEditorPart parent) {
        this._parentPart = parent;
        this._htmlViewerListeners = new ArrayList<IHTMLGraphicalViewerListener>();
        this._caretUpdater = new CaretUpdater(this);
    }

    public void addHTMLViewerListener(IHTMLGraphicalViewerListener listener) {
        this.addSelectionChangedListener(listener);
        if (!this._htmlViewerListeners.contains(listener)) {
            this._htmlViewerListeners.add(listener);
        }
    }

    public void removeHTMLViewerListener(IHTMLGraphicalViewerListener listener) {
        this.removeSelectionChangedListener(listener);
        this._htmlViewerListeners.remove(listener);
    }

    public Viewport getViewport() {
        FigureCanvas canvas = this.getFigureCanvas();
        if (canvas != null) {
            return canvas.getViewport();
        }
        return null;
    }

    public IDOMModel getModel() {
        EditPart part = this.getContents();
        if (part != null) {
            return ((IDOMNode)part.getModel()).getModel();
        }
        return null;
    }

    public IStatusLineManager getStatusLineManager() {
        if (this._parentPart == null) {
            return null;
        }
        return this._parentPart.getEditorSite().getActionBars().getStatusLineManager();
    }

    public Caret getCaret() {
        if (this._caret == null) {
            Canvas parentCanvas = (Canvas)this.getControl();
            if (parentCanvas == null || parentCanvas.isDisposed()) {
                return null;
            }
            this._caret = new Caret(parentCanvas, 0);
            this._caretUpdater.connectViewer();
        }
        return this._caret;
    }

    public EditPart getPrimarySelectedNode() {
        List list = this.getSelectedEditParts();
        if (list.isEmpty()) {
            return null;
        }
        int i = 0;
        int n = list.size();
        while (i < n) {
            EditPart part = (EditPart)list.get(i);
            if (part.getSelected() == 2) {
                return part;
            }
            ++i;
        }
        return (EditPart)list.get(0);
    }

    public void ensureRangeSelectionMode() {
        if (!this._rangeMode) {
            EditPart primary = this.getPrimarySelectedNode();
            this.deselectAll();
            DesignPosition begin = primary == null ? DesignPosition.INVALID : DesignPosition.createPositionBeforePart(primary);
            DesignPosition after = primary == null ? DesignPosition.INVALID : DesignPosition.createPositionAfterPart(primary);
            this.internalSetRange(begin, after);
            this.fireSelectionChanged();
        }
    }

    public void ensureObjectSelectionMode() {
        if (this._rangeMode) {
            this.internalToObjectMode();
            this.fireSelectionChanged();
        }
    }

    public boolean isInRangeMode() {
        return this._rangeMode;
    }

    public ISelection getSelection() {
        if (this.isInRangeMode()) {
            return this.getRangeSelection();
        }
        return super.getSelection();
    }

    public void startSelectionChange() {
        if (this._inBatch == 0) {
            this.fireSelectionAboutToChange();
        }
        ++this._inBatch;
    }

    public void selectionChanged() {
        if (--this._inBatch == 0) {
            this.fireSelectionChanged();
            this.fireSelectionChangeFinished();
        }
    }

    private void fireSelectionAboutToChange() {
        IHTMLGraphicalViewerListener[] listeners = this._htmlViewerListeners.toArray(new IHTMLGraphicalViewerListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].selectionAboutToChange();
            ++i;
        }
    }

    private void fireSelectionChangeFinished() {
        IHTMLGraphicalViewerListener[] listeners = this._htmlViewerListeners.toArray(new IHTMLGraphicalViewerListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].selectionChangeFinished();
            ++i;
        }
    }

    protected void fireSelectionChanged() {
        if (this._inBatch == 0) {
            super.fireSelectionChanged();
        }
    }

    public void setSelection(ISelection newSelection) {
        if (newSelection instanceof IStructuredSelection) {
            this.internalToObjectMode();
            ExposeHelper.expose(newSelection, (ScrollingGraphicalViewer)this);
            this.updateRangeSelection(newSelection);
            super.setSelection(newSelection);
        } else if (newSelection instanceof DesignRange) {
            DesignRange range = (DesignRange)newSelection;
            this.internalSetRange(range.getStartPosition(), range.getEndPosition());
            this.fireSelectionChanged();
        }
    }

    public void updateRangeSelection(ISelection newSelection) {
        if (newSelection instanceof IStructuredSelection && !(((IStructuredSelection)newSelection).getFirstElement() instanceof DocumentEditPart)) {
            Object element = ((IStructuredSelection)newSelection).getFirstElement();
            if (element instanceof ElementEditPart) {
                this.updateRangeSelection(new DesignRefPosition((EditPart)element, false), new DesignRefPosition((EditPart)element, true));
            } else if (element instanceof Node) {
                DOMRefPosition start = new DOMRefPosition((Node)element, false);
                DOMRefPosition end = new DOMRefPosition((Node)element, true);
                this.updateRangeSelection(DOMPositionHelper.toDesignPosition(start), DOMPositionHelper.toDesignPosition(end));
            }
        }
    }

    private void updateRangeSelection(DesignPosition position, DesignPosition position2) {
        if (position == null) {
            position = DesignPosition.INVALID;
        }
        if (position2 == null || !position2.isValid()) {
            position2 = position;
        }
        if (!position.isValid()) {
            position = position2;
        }
        this._selectionRange = new DesignRange(position, position2);
    }

    public void appendSelection(EditPart editpart) {
        this.internalToObjectMode();
        super.appendSelection(editpart);
    }

    public void deselectAll() {
        this.internalToObjectMode();
        super.deselectAll();
    }

    public void clearSelectionRange() {
        this.internalToObjectMode();
        this._selectionRange = null;
    }

    public void deselect(EditPart editpart) {
        if (!this._rangeMode) {
            super.deselect(editpart);
        }
    }

    public DesignRange getRangeSelection() {
        return this._selectionRange;
    }

    public void setRange(DesignPosition position, DesignPosition position2) {
        this.internalSetRange(position, position2);
        this.fireSelectionChanged();
    }

    public void setRangeEndPosition(DesignPosition position) {
        DesignRange range = this.getRangeSelection();
        DesignPosition begin = null;
        if (range != null) {
            begin = range.getStartPosition();
        }
        this.internalSetRange(begin, position);
        this.fireSelectionChanged();
    }

    private void internalToObjectMode() {
        this._rangeMode = false;
    }

    private void internalSetRange(DesignPosition position, DesignPosition position2) {
        if (!this._rangeMode) {
            this.deselectAll();
            this._rangeMode = true;
        }
        if (position == null) {
            position = DesignPosition.INVALID;
        }
        if (position2 == null || !position2.isValid()) {
            position2 = position;
        }
        if (!position.isValid()) {
            position = position2;
        }
        this._selectionRange = new DesignRange(position, position2);
    }

    public void dumpStatus() {
        this.isInRangeMode();
    }

    public int getXoffset() {
        return this._xOffset;
    }

    public void setXoffset(int xoffset) {
        this._xOffset = xoffset;
    }

    public void updateHorizontalPos() {
        Caret caret = this.getCaret();
        if (caret != null && !caret.isDisposed() && this.isInRangeMode()) {
            Rectangle rect = caret.getBounds();
            this.setXoffset(rect.x);
        }
    }

    public IEditorPart getParent() {
        return this._parentPart;
    }
}

