/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TreeIterableTests
extends TestCase {
    Collection<TreeNode> nodes = new ArrayList<TreeNode>();
    private static Transformer<TreeNode, Iterable<? extends TreeNode>> CHILDREN_TRANSFORMER = new ChildrenTransformer();

    public TreeIterableTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator1() {
        for (TreeNode tn : ObjectTools.tree((Object)this.buildTree(), CHILDREN_TRANSFORMER)) {
            TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
        }
    }

    public void testIterator2() {
        for (TreeNode tn : IterableTools.treeIterable((Object[])new TreeNode[]{this.buildTree()}, CHILDREN_TRANSFORMER)) {
            TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
        }
    }

    public void testToString() {
        TreeIterableTests.assertNotNull((Object)IterableTools.treeIterable((Object)this.buildTree(), CHILDREN_TRANSFORMER).toString());
    }

    private TreeNode buildTree() {
        TreeNode root = new TreeNode("root");
        TreeNode child1 = new TreeNode(root, "child 1");
        new TreeNode(child1, "grandchild 1A");
        TreeNode child2 = new TreeNode(root, "child 2");
        new TreeNode(child2, "grandchild 2A");
        TreeNode grandchild2B = new TreeNode(child2, "grandchild 2B");
        new TreeNode(grandchild2B, "great-grandchild 2B1");
        new TreeNode(grandchild2B, "great-grandchild 2B2");
        TreeNode grandchild2C = new TreeNode(child2, "grandchild 2C");
        new TreeNode(grandchild2C, "great-grandchild 2C1");
        new TreeNode(root, "child 3");
        return root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ChildrenTransformer
    extends TransformerAdapter<TreeNode, Iterable<? extends TreeNode>> {
        protected ChildrenTransformer() {
        }

        public Iterable<? extends TreeNode> transform(TreeNode node) {
            return node.getChildren();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TreeNode {
        private String name;
        private Collection<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(String name) {
            TreeIterableTests.this.nodes.add(this);
            this.name = name;
        }

        public TreeNode(TreeNode parent, String name) {
            this(name);
            parent.addChild(this);
        }

        public String getName() {
            return this.name;
        }

        private void addChild(TreeNode child) {
            this.children.add(child);
        }

        public Iterable<TreeNode> getChildren() {
            return this.children;
        }

        public int childrenSize() {
            return this.children.size();
        }

        public String toString() {
            return "TreeNode(" + this.name + ")";
        }
    }
}

