/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterator.ChainIterator;
import org.eclipse.jpt.common.utility.internal.transformer.DisabledTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainIteratorTests
extends TestCase {
    private static final Class<?>[] VECTOR_HIERARCHY = new Class[]{Vector.class, AbstractList.class, AbstractCollection.class, Object.class};
    private static final TransformerAdapter<Class<?>, Class<?>> SUPERCLASS_TRANSFORMER = new SuperclassTransformer();

    public ChainIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<Class<?>> stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ChainIteratorTests.assertEquals((int)VECTOR_HIERARCHY.length, (int)i);
    }

    public void testNext() {
        int i = 0;
        Iterator<Class<?>> stream = this.buildIterator();
        while (stream.hasNext()) {
            ChainIteratorTests.assertEquals((String)"bogus link", VECTOR_HIERARCHY[i], stream.next());
            ++i;
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<Class<?>> stream = this.buildIterator();
        Class<?> javaClass = null;
        while (stream.hasNext()) {
            javaClass = stream.next();
        }
        try {
            javaClass = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ChainIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + javaClass), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator<Class<?>> stream = this.buildIterator();
        while (stream.hasNext()) {
            if (stream.next() != AbstractCollection.class) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ChainIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private Iterator<Class<?>> buildIterator() {
        return this.buildChainIterator(Vector.class, (Transformer<Class<?>, Class<?>>)SUPERCLASS_TRANSFORMER);
    }

    private Iterator<Class<?>> buildChainIterator(Class<?> startLink, Transformer<Class<?>, Class<?>> transformer) {
        return new ChainIterator(startLink, transformer);
    }

    public void testInvalidChainIterator() {
        ChainIterator iterator = new ChainIterator(Vector.class, DisabledTransformer.instance());
        boolean exCaught = false;
        try {
            Class c = (Class)iterator.next();
            ChainIteratorTests.fail((String)("invalid class: " + c.getName()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        ChainIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SuperclassTransformer
    extends TransformerAdapter<Class<?>, Class<?>> {
        SuperclassTransformer() {
        }

        public Class<?> transform(Class<?> clazz) {
            return clazz.getSuperclass();
        }
    }
}

