/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.SocketUtil;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.PipedTransportService;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoTransportService;
import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.ListenerKey;
import org.eclipse.wst.jsdt.debug.transport.TransportService;

public class TransportTest
extends TestCase {
    public void testSocketStartStopListening() throws Exception {
        RhinoTransportService service = new RhinoTransportService();
        ListenerKey key = service.startListening(SocketUtil.findFreePortString());
        TransportTest.assertNotNull((Object)key);
        service.stopListening(key);
    }

    public void _testSocketAcceptAttach() throws Exception {
        RhinoTransportService service = new RhinoTransportService();
        String port = SocketUtil.findFreePortString();
        TransportTest.assertTrue((String)"A valid port could not be found on localhost", (!"-1".equals(port) ? 1 : 0) != 0);
        ListenerKey key = service.startListening(port);
        Thread t = new Thread((TransportService)service, key){
            private final /* synthetic */ TransportService val$service;
            private final /* synthetic */ ListenerKey val$key;
            {
                this.val$service = transportService;
                this.val$key = listenerKey;
            }

            public void run() {
                Connection c = null;
                try {
                    c = this.val$service.accept(this.val$key, 5000L, 5000L);
                    TransportTest.assertNotNull((Object)c);
                    c.close();
                }
                catch (IOException e) {
                    TransportTest.fail((String)e.getMessage());
                }
            }
        };
        t.start();
        Connection c = service.attach(port, 5000L, 5000L);
        TransportTest.assertNotNull((Object)c);
        c.close();
        t.join(5000L);
        service.stopListening(key);
    }

    public void testPipedStartStopListening() throws Exception {
        PipedTransportService service = new PipedTransportService();
        ListenerKey key = service.startListening(SocketUtil.findFreePortString());
        TransportTest.assertNotNull((Object)key);
        service.stopListening(key);
    }

    public void testPipedAcceptAttach() throws Exception {
        PipedTransportService service = new PipedTransportService();
        String port = SocketUtil.findFreePortString();
        TransportTest.assertTrue((String)"A valid port could not be found on localhost", (!"-1".equals(port) ? 1 : 0) != 0);
        ListenerKey key = service.startListening(port);
        Thread t = new Thread((TransportService)service, key){
            private final /* synthetic */ TransportService val$service;
            private final /* synthetic */ ListenerKey val$key;
            {
                this.val$service = transportService;
                this.val$key = listenerKey;
            }

            public void run() {
                Connection c = null;
                try {
                    c = this.val$service.accept(this.val$key, 5000L, 5000L);
                    TransportTest.assertNotNull((Object)c);
                    c.close();
                }
                catch (IOException e) {
                    TransportTest.fail((String)e.getMessage());
                }
            }
        };
        t.start();
        Connection c = service.attach(port, 5000L, 5000L);
        TransportTest.assertNotNull((Object)c);
        c.close();
        t.join(5000L);
        service.stopListening(key);
    }
}

