/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class FunctionPrototypeTests
extends TestCase {
    private static final String TEST_NAME = "Test that prototype (i.e. a function property) is available in content assist";
    private static TestProjectSetup fTestProjectSetup;
    static /* synthetic */ Class class$0;

    public FunctionPrototypeTests() {
        super(TEST_NAME);
    }

    public FunctionPrototypeTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.ui.tests.contentassist.FunctionPrototypeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false);
        return fTestProjectSetup;
    }

    public void testPrototypeFunction_SameFile() throws Exception {
        String[][] expectedProposals = new String[][]{{"prototype - Function", "getServerIP() - FunctionPrototype0"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestFunctionPrototype_0.js", 25, 19, expectedProposals);
    }

    public void testSimpleFunction_SameFile() throws Exception {
        String[][] expectedProposals = new String[][]{{"prototype - Function"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestFunctionPrototype_0.js", 27, 10, expectedProposals);
    }

    public void testPrototypeFunction_OtherFile() throws Exception {
        String[][] expectedProposals = new String[][]{{"prototype - Function", "getServerIP() - FunctionPrototype0"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestFunctionPrototype_1.js", 0, 19, expectedProposals);
    }

    public void testSimpleFunction_OtherFile() throws Exception {
        String[][] expectedProposals = new String[][]{{"prototype - Function"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestFunctionPrototype_1.js", 2, 10, expectedProposals);
    }

    public void testNotGlobal_ThisFile() throws Exception {
        String[][] expectedProposals = new String[][]{{"getServerIP()", "getClientIP"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_0.js", 37, 0, expectedProposals, true, false);
    }

    public void testNotGlobal_OtherFile() throws Exception {
        String[][] expectedProposals = new String[][]{{"getServerIP()", "getClientIP"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "StaticTests_1.js", 7, 0, expectedProposals, true, false);
    }
}

