/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.xsl.internal.debug.ui.AbstractTableBlock;
import org.eclipse.wst.xsl.internal.debug.ui.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.actions.AbstractStylesheetAction;
import org.eclipse.wst.xsl.internal.debug.ui.actions.AddExternalFileAction;
import org.eclipse.wst.xsl.internal.debug.ui.actions.AddWorkspaceFileAction;
import org.eclipse.wst.xsl.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.wst.xsl.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.wst.xsl.internal.debug.ui.actions.RemoveAction;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.IStylesheetEntriesChangedListener;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.StylesheetContentProvider;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.StylesheetLabelProvider;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.StylesheetViewer;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;

public class TransformsBlock
extends AbstractTableBlock
implements IStylesheetEntriesChangedListener {
    protected static final String DIALOG_SETTINGS_PREFIX = "TransformsBlock";
    private StylesheetViewer stylesheetViewer;
    private LaunchPipeline pipeline;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(this.getName());
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.setControl((Control)group);
        this.stylesheetViewer = new StylesheetViewer((Composite)group);
        gd = new GridData(4, 4, true, true);
        this.stylesheetViewer.getViewer().getTable().setLayoutData((Object)gd);
        this.stylesheetViewer.addEntriesChangedListener(this);
        this.stylesheetViewer.getViewer().getControl().setFont(font);
        this.stylesheetViewer.getViewer().setLabelProvider((IBaseLabelProvider)new StylesheetLabelProvider());
        this.stylesheetViewer.getViewer().setContentProvider((IContentProvider)new StylesheetContentProvider());
        this.stylesheetViewer.getViewer().getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    RemoveAction ra = new RemoveAction(TransformsBlock.this.stylesheetViewer);
                    ra.run();
                    TransformsBlock.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Composite upDownButtonComp = new Composite((Composite)group, 0);
        GridLayout upDownButtonLayout = new GridLayout();
        upDownButtonLayout.marginHeight = 0;
        upDownButtonLayout.marginWidth = 0;
        upDownButtonComp.setLayout((Layout)upDownButtonLayout);
        gd = new GridData(4, 4, false, true);
        upDownButtonComp.setLayoutData((Object)gd);
        upDownButtonComp.setFont(font);
        this.createArrowButton(upDownButtonComp, new MoveUpAction(this.stylesheetViewer), 128);
        Label spacer = new Label(upDownButtonComp, 0);
        gd = new GridData(0, 4, false, true);
        spacer.setLayoutData((Object)gd);
        this.createArrowButton(upDownButtonComp, new MoveDownAction(this.stylesheetViewer), 1024);
        Composite pathButtonComp = new Composite((Composite)group, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createButton(pathButtonComp, new AddWorkspaceFileAction(this.stylesheetViewer));
        this.createButton(pathButtonComp, new AddExternalFileAction(this.stylesheetViewer, DIALOG_SETTINGS_PREFIX));
        this.createButton(pathButtonComp, new RemoveAction(this.stylesheetViewer));
    }

    public Viewer getStylesheetViewer() {
        return this.stylesheetViewer == null ? null : this.stylesheetViewer.getViewer();
    }

    protected Button createArrowButton(Composite pathButtonComp, AbstractStylesheetAction action, int updown) {
        Button b = new Button(pathButtonComp, 4 | updown);
        GridData gd = new GridData();
        b.setLayoutData((Object)gd);
        action.setButton(b);
        return b;
    }

    protected Button createButton(Composite pathButtonComp, AbstractStylesheetAction action) {
        Button button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        return button;
    }

    public String getName() {
        return Messages.TransformsBlock_Name;
    }

    public void setPipeline(LaunchPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.stylesheetViewer.getViewer().setInput((Object)this.pipeline);
        if (this.pipeline.getTransformDefs().size() > 0) {
            this.stylesheetViewer.getViewer().setSelection((ISelection)new StructuredSelection(this.pipeline.getTransformDefs().get(0)));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void entriesChanged(StylesheetViewer viewer) {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void setSortColumn(int column) {
        super.setSortColumn(column);
    }

    protected Table getTable() {
        return this.stylesheetViewer == null ? null : this.stylesheetViewer.getViewer().getTable();
    }

    protected IDialogSettings getDialogSettings() {
        return XSLDebugUIPlugin.getDefault().getDialogSettings();
    }

    protected String getQualifier() {
        return "org.eclipse.wst.xsl.debug.ui.MAIN_TRANSFORMS_BLOCK";
    }

    public void dispose() {
        if (this.stylesheetViewer != null) {
            this.stylesheetViewer.removeEntriesChangedListener(this);
        }
        super.dispose();
    }
}

