/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.gen.internal.Association;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.AssociationTablesPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.CardinalityPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.JoinColumnsPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.NewAssociationWizardPage;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewAssociationWizard
extends Wizard {
    public static String ASSOCIATION_SCHEMA = "ASSOCIATION_SCHEMA";
    public static String ASSOCIATION_REFERRER_TABLE = "ASSOCIATION_REFERRER_TABLE";
    public static String ASSOCIATION_REFERENCED_TABLE = "ASSOCIATION_REFERENCED_TABLE";
    public static String ASSOCIATION_JOIN_COLUMNS1 = "ASSOCIATION_REFERRER_COLUMNS1";
    public static String ASSOCIATION_JOIN_COLUMNS2 = "ASSOCIATION_REFERRER_COLUMNS2";
    public static String ASSOCIATION_JOIN_TABLE = "ASSOCIATION_JOIN_TABLE";
    public static String ASSOCIATION_CADINALITY = "ASSOCIATION_CADINALITY";
    private JpaProject jpaProject;
    private HashMap<String, Object> associationDataModel = new HashMap();
    private ORMGenCustomizer customizer = null;
    private AssociationTablesPage associationTablesPage;
    private JoinColumnsPage joinColumnsPage;
    private CardinalityPage cardinalityPage;
    protected final ResourceManager resourceManager;

    public NewAssociationWizard(JpaProject jpaProject, ORMGenCustomizer customizer, ResourceManager resourceManager) {
        this.jpaProject = jpaProject;
        this.customizer = customizer;
        this.resourceManager = resourceManager;
        this.setWindowTitle(JptJpaUiWizardsEntityGenMessages.GenerateEntitiesWizard_newAssoc_title);
        this.associationDataModel.put(ASSOCIATION_SCHEMA, this.customizer.getSchema());
        this.associationDataModel.put(ASSOCIATION_JOIN_COLUMNS1, new TreeMap());
        this.associationDataModel.put(ASSOCIATION_JOIN_COLUMNS2, new TreeMap());
    }

    public void addPages() {
        super.addPages();
        this.associationTablesPage = new AssociationTablesPage(this.customizer, this.resourceManager);
        this.addPage((IWizardPage)this.associationTablesPage);
        this.joinColumnsPage = new JoinColumnsPage(this.customizer);
        this.addPage((IWizardPage)this.joinColumnsPage);
        this.cardinalityPage = new CardinalityPage(this.customizer);
        this.addPage((IWizardPage)this.cardinalityPage);
    }

    public boolean performFinish() {
        return true;
    }

    public ORMGenCustomizer getCustomizer() {
        return this.customizer;
    }

    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    public HashMap<String, Object> getDataModel() {
        return this.associationDataModel;
    }

    public void updateTableNames() {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            ((NewAssociationWizardPage)page).updateWithNewTables();
            ++n2;
        }
    }

    public Association getNewAssociation() {
        String referrerTableName = this.getReferrerTableName();
        String referencedTableName = this.getReferencedTableName();
        ArrayList<String> referrerColNames = new ArrayList<String>();
        ArrayList<String> referencedColNames = new ArrayList<String>();
        String cardinality = (String)this.associationDataModel.get(ASSOCIATION_CADINALITY);
        if (cardinality.equals("many-to-many")) {
            return this.createManyToManyAssociation();
        }
        Object value = this.associationDataModel.get(ASSOCIATION_JOIN_COLUMNS1);
        if (value != null) {
            TreeMap joinColumns = (TreeMap)value;
            for (String pk : joinColumns.keySet()) {
                referrerColNames.add(pk);
                referencedColNames.add((String)joinColumns.get(pk));
            }
        }
        if (cardinality.equals("one-to-many")) {
            cardinality = "many-to-one";
            String temp1 = referrerTableName;
            referrerTableName = referencedTableName;
            referencedTableName = temp1;
            ArrayList<String> temp2 = referrerColNames;
            referrerColNames = referencedColNames;
            referencedColNames = temp2;
        }
        Association association = null;
        association = new Association(this.customizer, referrerTableName, referrerColNames, referencedTableName, referencedColNames);
        association.setCardinality(cardinality);
        association.setCustom(true);
        return association;
    }

    private Association createManyToManyAssociation() {
        String referrerTableName = this.getReferrerTableName();
        String joinTable = this.getJoinTableName();
        String referencedTableName = this.getReferencedTableName();
        ArrayList<String> referrerColNames = new ArrayList<String>();
        ArrayList<String> referrerJoinColNames = new ArrayList<String>();
        Object value = this.associationDataModel.get(ASSOCIATION_JOIN_COLUMNS1);
        if (value != null) {
            TreeMap joinColumns = (TreeMap)value;
            for (String pk : joinColumns.keySet()) {
                referrerColNames.add(pk);
                referrerJoinColNames.add((String)joinColumns.get(pk));
            }
        }
        value = this.associationDataModel.get(ASSOCIATION_JOIN_COLUMNS2);
        ArrayList<String> referencedColNames = new ArrayList<String>();
        ArrayList<String> referencedJoinColNames = new ArrayList<String>();
        if (value != null) {
            TreeMap joinColumns = (TreeMap)value;
            for (String pk : joinColumns.keySet()) {
                referencedJoinColNames.add(pk);
                referencedColNames.add((String)joinColumns.get(pk));
            }
        }
        Association association = null;
        association = new Association(this.customizer, referrerTableName, referrerColNames, referencedTableName, referencedColNames, joinTable, referrerJoinColNames, referencedJoinColNames);
        return association;
    }

    String getReferrerTableName() {
        return (String)this.associationDataModel.get(ASSOCIATION_REFERRER_TABLE);
    }

    String getReferencedTableName() {
        return (String)this.associationDataModel.get(ASSOCIATION_REFERENCED_TABLE);
    }

    String getJoinTableName() {
        return (String)this.associationDataModel.get(ASSOCIATION_JOIN_TABLE);
    }

    String getCardinality() {
        return (String)this.associationDataModel.get(ASSOCIATION_CADINALITY);
    }
}

