/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.refactoring.JptJpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaDeleteTypeParticipant
extends DeleteParticipant {
    protected final Set<IType> allTypes = new HashSet<IType>();
    protected final Map<IFile, Iterable<DeleteEdit>> persistenceXmlDeleteEdits = new HashMap<IFile, Iterable<DeleteEdit>>();
    protected final Map<IFile, Iterable<DeleteEdit>> mappingFilePersistentTypeDeleteEdits = new HashMap<IFile, Iterable<DeleteEdit>>();

    protected AbstractJpaDeleteTypeParticipant() {
    }

    protected void addType(IType type) {
        this.allTypes.add(type);
        this.addNestedTypes(type);
    }

    private void addNestedTypes(IType type) {
        IType[] iTypeArray = TypeTools.getTypes((IType)type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType nestedType = iTypeArray[n2];
            this.addType(nestedType);
            ++n2;
        }
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        monitor.subTask(JptJpaCoreRefactoringMessages.JPA_REFACORING_PARTICIPANT_LOADING_JPA_PROJECTS_SUB_TASK_NAME);
        Iterable<JpaProject> jpaProjects = this.getJpaProjects();
        int size = IterableTools.size(jpaProjects);
        if (size == 0) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 10 + 2));
        sm.subTask(this.getCheckConditionsSubTaskName());
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (JpaProject jpaProject : jpaProjects) {
            this.createDeleteEdits((IProgressMonitor)sm.newChild(10), jpaProject);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile file : this.persistenceXmlDeleteEdits.keySet()) {
            deltaFactory.change(file);
        }
        sm.worked(1);
        for (IFile file : this.mappingFilePersistentTypeDeleteEdits.keySet()) {
            deltaFactory.change(file);
        }
        sm.worked(1);
        return null;
    }

    protected Iterable<JpaProject> getJpaProjects() throws OperationCanceledException {
        try {
            JpaProjectManager jpaProjectManager = this.getJpaProjectManager();
            return jpaProjectManager != null ? jpaProjectManager.waitToGetJpaProjects() : IterableTools.emptyIterable();
        }
        catch (InterruptedException ex) {
            throw new OperationCanceledException(ex.getMessage());
        }
    }

    protected JpaProjectManager getJpaProjectManager() {
        return (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
    }

    protected String getCheckConditionsSubTaskName() {
        return JptJpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_SUB_TASK_NAME;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.persistenceXmlDeleteEdits.isEmpty() && this.mappingFilePersistentTypeDeleteEdits.isEmpty()) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.persistenceXmlDeleteEdits.size() + this.mappingFilePersistentTypeDeleteEdits.size()));
        sm.subTask(this.getCreateChangeSubTaskName());
        CompositeChange compositeChange = new CompositeChange(JptJpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_CHANGE_NAME);
        for (IFile persistenceXmlFile : this.persistenceXmlDeleteEdits.keySet()) {
            this.addPersistenceXmlDeleteTypeChange(persistenceXmlFile, compositeChange);
            sm.worked(1);
        }
        for (IFile mappingFile : this.mappingFilePersistentTypeDeleteEdits.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addMappingFileDeleteTypeChange(mappingFile, compositeChange);
            sm.worked(1);
        }
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    protected String getCreateChangeSubTaskName() {
        return JptJpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_SUB_TASK_NAME;
    }

    protected void createDeleteEdits(IProgressMonitor monitor, JpaProject jpaProject) throws OperationCanceledException {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit(jpaProject);
        if (persistenceUnit == null) {
            return;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + persistenceUnit.getMappingFileRefsSize()));
        Iterable<DeleteEdit> edits = this.createPersistenceXmlDeleteEdits(persistenceUnit);
        if (!IterableTools.isEmpty(edits)) {
            this.persistenceXmlDeleteEdits.put(jpaProject.getPersistenceXmlResource().getFile(), edits);
        }
        sm.worked(1);
        for (MappingFileRef mappingFileRef : persistenceUnit.getMappingFileRefs()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Iterable<DeleteEdit> mappingFileDeleteEdits = this.createMappingFileDeleteTypeEdits(mappingFileRef);
            if (!IterableTools.isEmpty(mappingFileDeleteEdits)) {
                this.mappingFilePersistentTypeDeleteEdits.put((IFile)mappingFileRef.getMappingFile().getResource(), mappingFileDeleteEdits);
            }
            sm.worked(1);
        }
    }

    protected Iterable<DeleteEdit> createPersistenceXmlDeleteEdits(PersistenceUnit persistenceUnit) {
        return IterableTools.children(this.getTypesOnClasspath(persistenceUnit.getJpaProject()), (Transformer)new PersistenceUnitDeleteTypeEditsTransformer(persistenceUnit));
    }

    protected Iterable<IType> getTypesOnClasspath(JpaProject jpaProject) {
        IJavaProject javaProject = jpaProject.getJavaProject();
        return IterableTools.filter(this.allTypes, (Predicate)new JavaProjectTools.JavaElementIsOnClasspath(javaProject));
    }

    protected void addPersistenceXmlDeleteTypeChange(IFile persistenceXmlFile, CompositeChange compositeChange) {
        Iterable<DeleteEdit> deleteTypeEdits = this.persistenceXmlDeleteEdits.get(persistenceXmlFile);
        TextChange textChange = this.getTextChange(persistenceXmlFile);
        if (textChange == null) {
            textChange = new TextFileChange(JptJpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_CHANGE_PERSISTENCE_XML_NAME, persistenceXmlFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        this.addEdits(textChange, deleteTypeEdits);
    }

    private Iterable<DeleteEdit> createMappingFileDeleteTypeEdits(MappingFileRef mappingFileRef) {
        return IterableTools.children(this.getTypesOnClasspath(mappingFileRef.getJpaProject()), (Transformer)new MappingFileDeleteTypeEditsTransformer(mappingFileRef));
    }

    protected void addMappingFileDeleteTypeChange(IFile mappingFile, CompositeChange compositeChange) {
        Iterable<DeleteEdit> deleteTypeEdits = this.mappingFilePersistentTypeDeleteEdits.get(mappingFile);
        TextChange textChange = this.getTextChange(mappingFile);
        if (textChange == null) {
            textChange = new TextFileChange(JptJpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_CHANGE_MAPPING_FILE_NAME, mappingFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        this.addEdits(textChange, deleteTypeEdits);
    }

    private PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        PersistenceXml persistenceXml = jpaProject.getContextModelRoot().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getRoot();
        if (persistence == null) {
            return null;
        }
        if (persistence.getPersistenceUnitsSize() != 1) {
            return null;
        }
        return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
    }

    private void addEdits(TextChange textChange, Iterable<? extends TextEdit> textEdits) {
        for (TextEdit textEdit : textEdits) {
            try {
                textChange.addEdit(textEdit);
            }
            catch (MalformedTreeException ex) {
                JptJpaCorePlugin.instance().logError(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappingFileDeleteTypeEditsTransformer
    extends TransformerAdapter<IType, Iterable<DeleteEdit>> {
        protected final MappingFileRef mappingFileRef;

        public MappingFileDeleteTypeEditsTransformer(MappingFileRef mappingFileRef) {
            this.mappingFileRef = mappingFileRef;
        }

        public Iterable<DeleteEdit> transform(IType type) {
            return this.mappingFileRef.createDeleteTypeEdits(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceUnitDeleteTypeEditsTransformer
    extends TransformerAdapter<IType, Iterable<DeleteEdit>> {
        protected final PersistenceUnit persistenceUnit;

        public PersistenceUnitDeleteTypeEditsTransformer(PersistenceUnit persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
        }

        public Iterable<DeleteEdit> transform(IType type) {
            return this.persistenceUnit.createDeleteTypeEdits(type);
        }
    }
}

