/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaManagedType
implements IManagedType {
    private final TypeMapping managedType;
    private IMappingBuilder<AttributeMapping> mappingBuilder;
    private Map<String, IMapping> mappings;
    private final JpaManagedTypeProvider provider;
    private IType type;

    protected JpaManagedType(JpaManagedTypeProvider provider, TypeMapping managedType, IMappingBuilder<AttributeMapping> mappingBuilder) {
        this.provider = provider;
        this.managedType = managedType;
        this.mappingBuilder = mappingBuilder;
    }

    protected IMapping buildMapping(AttributeMapping mapping) {
        return this.mappingBuilder.buildMapping((IManagedType)this, (Object)mapping);
    }

    protected Map<String, IMapping> buildMappings() {
        HashMap<String, IMapping> mappings = new HashMap<String, IMapping>();
        for (AttributeMapping mapping : this.managedType.getAllAttributeMappings()) {
            mappings.put(mapping.getName(), this.buildMapping(mapping));
        }
        return mappings;
    }

    public int compareTo(IManagedType managedType) {
        return this.getType().getName().compareTo(managedType.getType().getName());
    }

    public TypeMapping getManagedType() {
        return this.managedType;
    }

    protected IMappingBuilder<AttributeMapping> getMappingBuilder() {
        return this.mappingBuilder;
    }

    public IMapping getMappingNamed(String name) {
        this.initializeMappings();
        return this.mappings.get(name);
    }

    public JpaManagedTypeProvider getProvider() {
        return this.provider;
    }

    public IType getType() {
        if (this.type == null) {
            this.type = this.provider.getTypeRepository().getType(this.managedType.getPersistentType().getName());
        }
        return this.type;
    }

    protected void initializeMappings() {
        if (this.mappings == null) {
            this.mappings = this.buildMappings();
        }
    }

    public Iterable<IMapping> mappings() {
        this.initializeMappings();
        return IterableTools.cloneSnapshot(this.mappings.values());
    }
}

