/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.PersistentTypeContainer;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.jpql.spi.IManagedTypeBuilder;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaManagedTypeBuilder;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaNullManagedType;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeRepository;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaManagedTypeProvider
implements IManagedTypeProvider {
    private Collection<IEmbeddable> embeddables;
    private Collection<IEntity> entities;
    private final JpaProject jpaProject;
    private IManagedTypeBuilder managedTypeBuilder;
    private Map<String, IManagedType> managedTypes;
    private Collection<IMappedSuperclass> mappedSuperclasses;
    private IMappingBuilder<AttributeMapping> mappingBuilder;
    private final PersistentTypeContainer persistentTypeContainer;
    private JpaTypeRepository typeRepository;

    public JpaManagedTypeProvider(JpaProject jpaProject, PersistentTypeContainer persistentTypeContainer, IManagedTypeBuilder managedTypeBuilder, IMappingBuilder<AttributeMapping> mappingBuilder) {
        this.jpaProject = jpaProject;
        this.mappingBuilder = mappingBuilder;
        this.managedTypeBuilder = managedTypeBuilder;
        this.persistentTypeContainer = persistentTypeContainer;
    }

    public JpaManagedTypeProvider(JpaProject jpaProject, PersistentTypeContainer persistentTypeContainer, IMappingBuilder<AttributeMapping> mappingBuilder) {
        this(jpaProject, persistentTypeContainer, new JpaManagedTypeBuilder(), mappingBuilder);
    }

    protected IEmbeddable buildEmbeddable(Embeddable mappedClass) {
        return this.managedTypeBuilder.buildEmbeddable(this, mappedClass, this.mappingBuilder);
    }

    protected IEntity buildEntity(Entity mappedClass) {
        return this.managedTypeBuilder.buildEntity(this, mappedClass, this.mappingBuilder);
    }

    protected IManagedType buildManagedType(PersistentType persistentType) {
        TypeMapping mappedClass = persistentType.getMapping();
        if (mappedClass instanceof Entity) {
            IEntity entity = this.buildEntity((Entity)mappedClass);
            this.entities.add(entity);
            return entity;
        }
        if (mappedClass instanceof MappedSuperclass) {
            IMappedSuperclass mappedSuperclass = this.buildMappedSuperclass((MappedSuperclass)mappedClass);
            this.mappedSuperclasses.add(mappedSuperclass);
            return mappedSuperclass;
        }
        if (mappedClass instanceof Embeddable) {
            IEmbeddable embeddable = this.buildEmbeddable((Embeddable)mappedClass);
            this.embeddables.add(embeddable);
            return embeddable;
        }
        return new JpaNullManagedType(this, mappedClass);
    }

    protected Map<String, IManagedType> buildManagedTypes() {
        HashMap<String, IManagedType> managedTypes = new HashMap<String, IManagedType>();
        for (PersistentType persistentType : this.getPersistentTypeContainer().getPersistentTypes()) {
            String name;
            if (persistentType == null || managedTypes.containsKey(name = persistentType.getMapping().getName()) && persistentType.getOverriddenPersistentType() == null) continue;
            managedTypes.put(name, this.buildManagedType(persistentType));
        }
        return managedTypes;
    }

    protected IMappedSuperclass buildMappedSuperclass(MappedSuperclass mappedClass) {
        return this.managedTypeBuilder.buildMappedSuperclass(this, mappedClass, this.mappingBuilder);
    }

    public Iterable<IEntity> entities() {
        this.initializeManagedTypes();
        return IterableTools.cloneSnapshot(this.entities);
    }

    public IEmbeddable getEmbeddable(IType type) {
        return this.getEmbeddable(type.getName());
    }

    public IEmbeddable getEmbeddable(String typeName) {
        return this.getManagedType(this.embeddables, typeName);
    }

    public IEntity getEntity(IType type) {
        return this.getEntity(type.getName());
    }

    public IEntity getEntity(String typeName) {
        return this.getManagedType(this.entities, typeName);
    }

    public IEntity getEntityNamed(String entityName) {
        this.initializeManagedTypes();
        for (IEntity entity : this.entities) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        return null;
    }

    protected <T extends IManagedType> T getManagedType(Collection<T> managedTypes, String typeName) {
        this.initializeManagedTypes();
        for (IManagedType managedType : managedTypes) {
            if (!managedType.getType().getName().equals(typeName)) continue;
            return (T)managedType;
        }
        return null;
    }

    public IManagedType getManagedType(IType type) {
        return this.getManagedType(type.getName());
    }

    public IManagedType getManagedType(String typeName) {
        return this.getManagedType(this.managedTypes.values(), typeName);
    }

    public IMappedSuperclass getMappedSuperclass(IType type) {
        return this.getMappedSuperclass(type.getName());
    }

    public IMappedSuperclass getMappedSuperclass(String typeName) {
        return this.getManagedType(this.mappedSuperclasses, typeName);
    }

    public PersistentTypeContainer getPersistentTypeContainer() {
        return this.persistentTypeContainer;
    }

    protected PersistentTypeContainer getProvider() {
        return this.persistentTypeContainer;
    }

    public JpaTypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new JpaTypeRepository(this.jpaProject.getJavaProject());
        }
        return this.typeRepository;
    }

    protected void initializeManagedTypes() {
        if (this.managedTypes == null) {
            this.entities = new LinkedList<IEntity>();
            this.embeddables = new LinkedList<IEmbeddable>();
            this.mappedSuperclasses = new LinkedList<IMappedSuperclass>();
            this.managedTypes = this.buildManagedTypes();
        }
    }

    public Iterable<IManagedType> managedTypes() {
        this.initializeManagedTypes();
        return IterableTools.cloneSnapshot(this.managedTypes.values());
    }
}

