/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.TypeKind;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnum;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxbContextRoot
extends AbstractJaxbContextNode
implements JaxbContextRoot {
    protected final JaxbProject jaxbProject;
    protected final Map<String, JaxbPackage> packages;
    protected final Map<String, JavaType> types;
    public static final Predicate<JavaResourceAbstractType> JAVA_RESOURCE_TYPE_IS_ANNOTATED = new JavaResourceTypeIsAnnotated();

    public AbstractJaxbContextRoot(JaxbProject jaxbProject) {
        super(null);
        if (jaxbProject == null) {
            throw new NullPointerException();
        }
        this.jaxbProject = jaxbProject;
        this.packages = new Hashtable<String, JaxbPackage>();
        this.types = new Hashtable<String, JavaType>();
        this.initialize();
    }

    @Override
    public JaxbContextRoot getContextRoot() {
        return this;
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    protected void initialize() {
        for (String pkg : this.calculateInitialPackageNames()) {
            this.packages.put(pkg, this.buildPackage(pkg));
        }
        HashSet<String> totalTypeNames = new HashSet<String>();
        for (String typeName : CollectionTools.set(this.calculateInitialTypeNames())) {
            totalTypeNames.add(typeName);
            this.addType_(this.buildType(typeName));
        }
        for (String pkg : this.calculatePackageNames(totalTypeNames)) {
            if (this.packages.containsKey(pkg)) continue;
            this.packages.put(pkg, this.buildPackage(pkg));
        }
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        for (JaxbPackage jaxbPackage : this.getPackages()) {
            jaxbPackage.synchronizeWithResourceModel();
        }
        for (JavaType javaType : this.getJavaTypes()) {
            javaType.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        HashSet packagesToUpdate = CollectionTools.set((Object[])new String[0]);
        HashSet typesToUpdate = CollectionTools.set((Object[])new String[0]);
        HashSet packagesToRemove = CollectionTools.set(this.packages.keySet());
        HashSet typesToRemove = CollectionTools.set(this.types.keySet());
        HashSet totalTypes = CollectionTools.set((Object[])new String[0]);
        HashSet typesToScan = CollectionTools.set((Object[])new String[0]);
        for (String pkg : this.calculateInitialPackageNames()) {
            if (this.packages.containsKey(pkg)) {
                packagesToUpdate.add(pkg);
                packagesToRemove.remove(pkg);
                continue;
            }
            this.addPackage(this.buildPackage(pkg));
        }
        HashSet resourceTypesToProcess = CollectionTools.set(this.calculateInitialTypeNames());
        HashSet<String> referencedTypes = new HashSet<String>();
        while (!resourceTypesToProcess.isEmpty() || !typesToScan.isEmpty()) {
            for (String typeName : IterableTools.cloneSnapshot((Collection)resourceTypesToProcess)) {
                JavaResourceAbstractType resourceType = this.getJaxbProject().getJavaResourceType(typeName);
                if (resourceType != null) {
                    typesToRemove.remove(typeName);
                    totalTypes.add(typeName);
                    typesToScan.add(typeName);
                    this.processType(resourceType, typesToUpdate, referencedTypes.contains(typeName));
                }
                resourceTypesToProcess.remove(typeName);
            }
            for (String typeToScan : IterableTools.cloneSnapshot((Collection)typesToScan)) {
                JaxbTypeMapping typeMapping = this.getTypeMapping(typeToScan);
                if (typeMapping != null) {
                    for (String referencedTypeName : typeMapping.getReferencedXmlTypeNames()) {
                        JavaResourceAbstractType referencedType;
                        if (!(StringTools.isBlank((String)referencedTypeName) || totalTypes.contains(referencedTypeName) || (referencedType = this.getJaxbProject().getJavaResourceType(referencedTypeName)) == null || this.typeIsCoreJavaType(referencedTypeName))) {
                            resourceTypesToProcess.add(referencedType.getTypeBinding().getQualifiedName());
                        }
                        referencedTypes.add(referencedTypeName);
                    }
                }
                typesToScan.remove(typeToScan);
            }
        }
        for (String pkg : this.calculatePackageNames(totalTypes)) {
            if (this.packages.containsKey(pkg)) {
                packagesToUpdate.add(pkg);
                packagesToRemove.remove(pkg);
                continue;
            }
            this.addPackage(this.buildPackage(pkg));
        }
        for (String packageToUpdate : packagesToUpdate) {
            this.packages.get(packageToUpdate).update();
        }
        for (String typeToUpdate : typesToUpdate) {
            this.types.get(typeToUpdate).update();
        }
        for (String packageToRemove : packagesToRemove) {
            this.removePackage(packageToRemove);
        }
        for (String typeToRemove : typesToRemove) {
            this.removeType(typeToRemove);
        }
    }

    protected Set<String> calculateInitialPackageNames() {
        return CollectionTools.set((Iterable)IterableTools.transform(this.getJaxbProject().getAnnotatedJavaResourcePackages(), (Transformer)JavaResourcePackage.NAME_TRANSFORMER));
    }

    protected Set<String> calculatePackageNames(Set<String> typeNames) {
        HashSet packageNames = CollectionTools.set((Object[])new String[0]);
        for (String typeName : typeNames) {
            JavaType jaxbType = this.types.get(typeName);
            if (jaxbType == null) continue;
            packageNames.add(jaxbType.getTypeName().getPackageName());
        }
        return packageNames;
    }

    protected Iterable<String> calculateInitialTypeNames() {
        return IterableTools.transform(this.calculateInitialTypes(), (Transformer)new JavaResourceTypeNameTransformer());
    }

    protected Iterable<JavaResourceAbstractType> calculateInitialTypes() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{IterableTools.filter(this.getJaxbProject().getJavaSourceResourceTypes(), JAVA_RESOURCE_TYPE_IS_ANNOTATED), IterableTools.removeNulls((Iterable)IterableTools.transform((Iterable)IterableTools.children(this.getJaxbProject().getJaxbIndexResources(), JaxbIndexResource.CLASS_NAMES_TRANSFORMER), (Transformer)new JavaResourceTypeTransformer()))});
    }

    private boolean typeIsCoreJavaType(String typeName) {
        return typeName.startsWith("java");
    }

    protected void processType(JavaResourceAbstractType resourceType, Set<String> typesToUpdate, boolean defaultMapped) {
        JavaType type;
        TypeKind jaxbTypeKind = this.calculateJaxbTypeKind(resourceType);
        String className = resourceType.getTypeBinding().getQualifiedName();
        if (this.types.containsKey(className)) {
            type = this.types.get(className);
            if (type.getKind() == jaxbTypeKind) {
                typesToUpdate.add(className);
                type.setDefaultMapped(defaultMapped);
                return;
            }
            this.removeType(className);
        }
        type = this.buildType(resourceType);
        type.setDefaultMapped(defaultMapped);
        this.addType(type);
    }

    protected TypeKind calculateJaxbTypeKind(JavaResourceAbstractType resourceType) {
        if (resourceType.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.ENUM) {
            return TypeKind.ENUM;
        }
        return TypeKind.CLASS;
    }

    protected JavaType buildType(String typeName) {
        JavaResourceAbstractType resourceType = this.getJaxbProject().getJavaResourceType(typeName);
        return resourceType == null ? null : this.buildType(resourceType);
    }

    protected JavaType buildType(JavaResourceAbstractType resourceType) {
        return this.calculateJaxbTypeKind(resourceType) == TypeKind.ENUM ? this.buildJaxbEnum((JavaResourceEnum)resourceType) : this.buildJaxbClass((JavaResourceType)resourceType);
    }

    @Override
    public JaxbProject getJaxbProject() {
        return this.jaxbProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected IProject getProject() {
        return this.jaxbProject.getProject();
    }

    @Override
    public Iterable<JaxbPackage> getPackages() {
        return IterableTools.cloneLive(this.packages.values());
    }

    @Override
    public int getPackagesSize() {
        return this.packages.size();
    }

    @Override
    public JaxbPackage getPackage(String packageName) {
        for (JaxbPackage jaxbPackage : this.getPackages()) {
            if (!ObjectTools.equals((Object)jaxbPackage.getName(), (Object)packageName)) continue;
            return jaxbPackage;
        }
        return null;
    }

    protected JaxbPackage addPackage(JaxbPackage contextPackage) {
        if (this.packages.containsKey(contextPackage.getName())) {
            throw new IllegalArgumentException("Package with that name already exists.");
        }
        this.packages.put(contextPackage.getName(), contextPackage);
        this.fireItemAdded("packages", contextPackage);
        return contextPackage;
    }

    protected void removePackage(JaxbPackage contextPackage) {
        this.removePackage(contextPackage.getName());
    }

    protected void removePackage(String packageName) {
        if (!this.packages.containsKey(packageName)) {
            throw new IllegalArgumentException("No package with that name exists.");
        }
        JaxbPackage removedPackage = this.packages.remove(packageName);
        this.fireItemRemoved("packages", removedPackage);
    }

    protected JaxbPackage buildPackage(String packageName) {
        return this.getFactory().buildPackage(this, packageName);
    }

    protected boolean isEmpty(JaxbPackage jaxbPackage) {
        return jaxbPackage.isEmpty();
    }

    @Override
    public Iterable<JavaType> getJavaTypes() {
        return IterableTools.cloneLive(this.types.values());
    }

    @Override
    public int getJavaTypesSize() {
        return this.types.size();
    }

    @Override
    public JavaType getJavaType(String typeName) {
        return typeName == null ? null : this.types.get(typeName);
    }

    protected void addType_(JavaType type) {
        this.types.put(type.getTypeName().getFullyQualifiedName(), type);
    }

    protected void addType(JavaType type) {
        if (this.types.containsKey(type.getTypeName().getFullyQualifiedName())) {
            throw new IllegalArgumentException("Type with that name already exists.");
        }
        this.addType_(type);
        this.fireItemAdded("javaTypes", type);
    }

    protected void removeType(JavaType type) {
        this.removeType(type.getTypeName().getFullyQualifiedName());
    }

    protected void removeType(String typeName) {
        if (!this.types.containsKey(typeName)) {
            throw new IllegalArgumentException("No type with that name exists.");
        }
        JavaType removedType = this.types.remove(typeName);
        this.fireItemRemoved("javaTypes", removedType);
    }

    @Override
    public Iterable<JavaType> getJavaTypes(JaxbPackage jaxbPackage) {
        return IterableTools.filter(this.getJavaTypes(), (Predicate)new JavaTypeIsInPackage(jaxbPackage));
    }

    @Override
    public Iterable<JavaClass> getJavaClasses() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getJavaTypes(), (Predicate)new JavaType.IsKind(TypeKind.CLASS)));
    }

    @Override
    public Iterable<JavaClass> getJavaClasses(JaxbPackage jaxbPackage) {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getJavaTypes(jaxbPackage), (Predicate)new JavaType.IsKind(TypeKind.CLASS)));
    }

    @Override
    public Iterable<JavaEnum> getJavaEnums() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getJavaTypes(), (Predicate)new JavaType.IsKind(TypeKind.ENUM)));
    }

    @Override
    public Iterable<JavaEnum> getJavaEnums(JaxbPackage jaxbPackage) {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getJavaTypes(jaxbPackage), (Predicate)new JavaType.IsKind(TypeKind.ENUM)));
    }

    protected JavaClass buildJaxbClass(JavaResourceType resourceType) {
        return this.getFactory().buildJavaClass(this, resourceType);
    }

    protected JavaEnum buildJaxbEnum(JavaResourceEnum resourceEnum) {
        return this.getFactory().buildJavaEnum(this, resourceEnum);
    }

    @Override
    public Iterable<XmlRegistry> getXmlRegistries(JaxbPackage jaxbPackage) {
        return IterableTools.removeNulls((Iterable)IterableTools.transform(this.getJavaClasses(jaxbPackage), JavaClass.XML_REGISTRY_TRANSFORMER));
    }

    @Override
    public JaxbTypeMapping getTypeMapping(String typeName) {
        JavaType type = this.getJavaType(typeName);
        return type == null ? null : type.getMapping();
    }

    @Override
    public JaxbClassMapping getClassMapping(String typeName) {
        JavaType type = this.getJavaType(typeName);
        return type == null || type.getKind() != TypeKind.CLASS ? null : ((JavaClass)type).getMapping();
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.jaxbProject.stateChanged();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (JaxbPackage pkg : this.packages.values()) {
            pkg.validate(messages, reporter);
        }
        for (JavaType type : this.types.values()) {
            type.validate(messages, reporter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaResourceTypeIsAnnotated
    extends PredicateAdapter<JavaResourceAbstractType> {
        public boolean evaluate(JavaResourceAbstractType type) {
            if (type.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.TYPE && type.getAnnotation("javax.xml.bind.annotation.XmlRegistry") != null) {
                return true;
            }
            if (type.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.ENUM && type.getAnnotation("javax.xml.bind.annotation.XmlEnum") != null) {
                return true;
            }
            return type.getAnnotation("javax.xml.bind.annotation.XmlType") != null || type.getAnnotation("javax.xml.bind.annotation.XmlRootElement") != null || type.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter") > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaResourceTypeNameTransformer
    extends TransformerAdapter<JavaResourceAbstractType, String> {
        protected JavaResourceTypeNameTransformer() {
        }

        public String transform(JavaResourceAbstractType input) {
            return input.getTypeBinding().getQualifiedName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaResourceTypeTransformer
    extends TransformerAdapter<String, JavaResourceAbstractType> {
        protected JavaResourceTypeTransformer() {
        }

        public JavaResourceAbstractType transform(String typeName) {
            return AbstractJaxbContextRoot.this.getJaxbProject().getJavaResourceType(typeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaTypeIsInPackage
    extends CriterionPredicate<JavaType, String> {
        public JavaTypeIsInPackage(JaxbPackage jaxbPackage) {
            super((Object)jaxbPackage.getName());
        }

        public boolean evaluate(JavaType javaType) {
            return javaType.getTypeName().getPackageName().equals(this.criterion);
        }
    }
}

