/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StorageLabelProvider;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaScriptElementLabels {
    public static final long M_PARAMETER_TYPES = 1L;
    public static final long M_PARAMETER_NAMES = 2L;
    public static final long M_PRE_TYPE_PARAMETERS = 4L;
    public static final long M_APP_TYPE_PARAMETERS = 8L;
    public static final long M_EXCEPTIONS = 16L;
    public static final long M_APP_RETURNTYPE = 32L;
    public static final long M_PRE_RETURNTYPE = 64L;
    public static final long M_FULLY_QUALIFIED = 128L;
    public static final long M_POST_QUALIFIED = 256L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long I_POST_QUALIFIED = 2048L;
    public static final long F_APP_TYPE_SIGNATURE = 16384L;
    public static final long F_PRE_TYPE_SIGNATURE = 32768L;
    public static final long F_FULLY_QUALIFIED = 65536L;
    public static final long F_POST_QUALIFIED = 131072L;
    public static final long T_FULLY_QUALIFIED = 262144L;
    public static final long T_CONTAINER_QUALIFIED = 524288L;
    public static final long T_POST_QUALIFIED = 0x100000L;
    public static final long T_TYPE_PARAMETERS = 0x200000L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CU_QUALIFIED = 0x80000000L;
    public static final long CU_POST_QUALIFIED = 0x100000000L;
    public static final long P_QUALIFIED = 0x800000000L;
    public static final long P_POST_QUALIFIED = 0x1000000000L;
    public static final long P_COMPRESSED = 0x2000000000L;
    public static final long ROOT_VARIABLE = 0x10000000000L;
    public static final long ROOT_QUALIFIED = 0x20000000000L;
    public static final long ROOT_POST_QUALIFIED = 0x40000000000L;
    public static final long APPEND_ROOT_PATH = 0x80000000000L;
    public static final long PREPEND_ROOT_PATH = 0x100000000000L;
    public static final long REFERENCED_ROOT_POST_QUALIFIED = 0x200000000000L;
    public static final long USE_RESOLVED = 0x1000000000000L;
    public static final long F_CATEGORY = 0x2000000000000L;
    public static final long M_CATEGORY = 0x4000000000000L;
    public static final long T_CATEGORY = 0x8000000000000L;
    public static final long SHOW_TYPE = 0x10000000000000L;
    public static final long ALL_CATEGORY = new Long(0xE000000000000L);
    public static final long ALL_FULLY_QUALIFIED = new Long(2235681801344L);
    public static final long ALL_POST_QUALIFIED = new Long(4471364126976L);
    public static final long ALL_DEFAULT = new Long(0x20000AL);
    public static final long DEFAULT_QUALIFIED = new Long(2298807424L);
    public static final long DEFAULT_POST_QUALIFIED = new Long(4598139136L);
    public static final String CONCAT_STRING = JavaUIMessages.JavaElementLabels_concat_string;
    public static final String COMMA_STRING = JavaUIMessages.JavaElementLabels_comma_string;
    public static final String DECL_STRING = JavaUIMessages.JavaElementLabels_declseparator_string;
    private static final String CATEGORY_SEPARATOR_STRING = JavaUIMessages.JavaElementLabels_category_separator_string;
    public static final String ELLIPSIS_STRING = "...";
    public static final String DEFAULT_PACKAGE = JavaUIMessages.JavaElementLabels_default_package;
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;
    private static final IPath LIBCACHE_LOCATION = new Path(JavaScriptCore.getJavaScriptCore().getStateLocation().append(new String(SystemLibraryLocation.LIBRARY_RUNTIME_DIRECTORY)).toOSString());
    private static String fgPkgNamePattern = "";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;
    static /* synthetic */ Class class$0;

    static {
        fgPkgNameLength = -1;
    }

    private JavaScriptElementLabels() {
    }

    private static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static String getTextLabel(Object obj, long flags) {
        if (obj instanceof IJavaScriptElement) {
            return JavaScriptElementLabels.getElementLabel((IJavaScriptElement)obj, flags);
        }
        if (obj instanceof IResource) {
            return ((IResource)obj).getName();
        }
        if (obj instanceof IStorage) {
            StorageLabelProvider storageLabelProvider = new StorageLabelProvider();
            String label = storageLabelProvider.getText(obj);
            storageLabelProvider.dispose();
            return label;
        }
        if (obj instanceof IAdaptable) {
            IWorkbenchAdapter wbadapter;
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return wbadapter.getLabel(obj);
            }
        }
        return "";
    }

    public static String getElementLabel(IJavaScriptElement element, long flags) {
        StringBuffer buf = new StringBuffer(60);
        JavaScriptElementLabels.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void getElementLabel(IJavaScriptElement element, long flags, StringBuffer buf) {
        int type = element.getElementType();
        IPackageFragmentRoot root = null;
        if (type != 1 && type != 2 && type != 3) {
            root = JavaModelUtil.getPackageFragmentRoot(element);
        }
        if (root != null && JavaScriptElementLabels.getFlag(flags, 0x100000000000L)) {
            JavaScriptElementLabels.getPackageFragmentRootLabel(root, 0x20000000000L, buf);
            buf.append(CONCAT_STRING);
        }
        switch (type) {
            case 9: {
                JavaScriptElementLabels.getMethodLabel((IFunction)element, flags, buf);
                break;
            }
            case 8: {
                JavaScriptElementLabels.getFieldLabel((IField)element, flags, buf);
                break;
            }
            case 14: {
                JavaScriptElementLabels.getLocalVariableLabel((ILocalVariable)element, flags, buf);
                break;
            }
            case 10: {
                JavaScriptElementLabels.getInitializerLabel((IInitializer)element, flags, buf);
                break;
            }
            case 7: {
                JavaScriptElementLabels.getTypeLabel((IType)element, flags, buf);
                break;
            }
            case 6: {
                JavaScriptElementLabels.getClassFileLabel((IClassFile)element, flags, buf);
                break;
            }
            case 5: {
                JavaScriptElementLabels.getCompilationUnitLabel((IJavaScriptUnit)element, flags, buf);
                break;
            }
            case 4: {
                JavaScriptElementLabels.getPackageFragmentLabel((IPackageFragment)element, flags, buf);
                break;
            }
            case 3: {
                JavaScriptElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)element, flags, buf);
                break;
            }
            case 12: 
            case 13: {
                JavaScriptElementLabels.getDeclarationLabel(element, flags, buf);
                break;
            }
            case 1: 
            case 2: {
                buf.append(element.getDisplayName());
                break;
            }
            default: {
                buf.append(element.getDisplayName());
            }
        }
        if (root != null && JavaScriptElementLabels.getFlag(flags, 0x80000000000L)) {
            buf.append(CONCAT_STRING);
            JavaScriptElementLabels.getPackageFragmentRootLabel(root, 0x20000000000L, buf);
        }
    }

    public static void getMethodLabel(IFunction method, long flags, StringBuffer buf) {
        try {
            String[] types;
            String resolvedSig;
            BindingKey resolvedKey = JavaScriptElementLabels.getFlag(flags, 0x1000000000000L) && method.isResolved() ? new BindingKey(method.getKey()) : null;
            String string = resolvedSig = resolvedKey != null ? resolvedKey.toSignature() : null;
            if (JavaScriptElementLabels.getFlag(flags, 64L) && method.exists() && !method.isConstructor()) {
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                JavaScriptElementLabels.getTypeSignatureLabel(returnTypeSig, flags, buf);
                buf.append(' ');
            }
            IType declaringType = method.getDeclaringType();
            if (JavaScriptElementLabels.getFlag(flags, 128L) && declaringType != null && !method.isConstructor()) {
                JavaScriptElementLabels.getTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, buf);
                buf.append('.');
            }
            buf.append(method.getDisplayName());
            buf.append('(');
            if (JavaScriptElementLabels.getFlag(flags, 3L)) {
                types = null;
                int nParams = 0;
                boolean renderVarargs = false;
                if (JavaScriptElementLabels.getFlag(flags, 1L)) {
                    types = resolvedSig != null ? Signature.getParameterTypes((String)resolvedSig) : method.getParameterTypes();
                    nParams = types.length;
                    renderVarargs = method.exists() && Flags.isVarargs((int)method.getFlags());
                }
                String[] names = null;
                if (JavaScriptElementLabels.getFlag(flags, 2L) && method.exists()) {
                    names = method.getParameterNames();
                    if (types == null) {
                        nParams = names.length;
                    } else if (nParams != names.length) {
                        if (resolvedSig != null && types.length > names.length) {
                            nParams = names.length;
                            String[] typesWithoutSyntheticParams = new String[nParams];
                            System.arraycopy(types, types.length - nParams, typesWithoutSyntheticParams, 0, nParams);
                            types = typesWithoutSyntheticParams;
                        } else {
                            names = null;
                        }
                    }
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    if (types != null) {
                        String paramSig = types[i];
                        if (renderVarargs && i == nParams - 1) {
                            int newDim = Signature.getArrayCount((String)paramSig) - 1;
                            JavaScriptElementLabels.getTypeSignatureLabel(Signature.getElementType((String)paramSig), flags, buf);
                            int k = 0;
                            while (k < newDim) {
                                buf.append('[').append(']');
                                ++k;
                            }
                            buf.append(ELLIPSIS_STRING);
                        } else {
                            JavaScriptElementLabels.getTypeSignatureLabel(paramSig, flags, buf);
                        }
                    }
                    if (names != null) {
                        if (types != null) {
                            buf.append(' ');
                        }
                        buf.append(names[i]);
                    }
                    ++i;
                }
            } else if (method.getParameterTypes().length > 0) {
                buf.append(ELLIPSIS_STRING);
            }
            buf.append(')');
            if (JavaScriptElementLabels.getFlag(flags, 16L) && (types = resolvedKey != null ? new String[]{} : new String[]{}).length > 0) {
                buf.append(" throws ");
                int i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    JavaScriptElementLabels.getTypeSignatureLabel(types[i], flags, buf);
                    ++i;
                }
            }
            if (JavaScriptElementLabels.getFlag(flags, 32L) && method.exists() && !method.isConstructor() && method.getReturnType() != null) {
                buf.append(DECL_STRING);
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                JavaScriptElementLabels.getTypeSignatureLabel(returnTypeSig, flags, buf);
            }
            if (JavaScriptElementLabels.getFlag(flags, 0x4000000000000L) && method.exists()) {
                JavaScriptElementLabels.getCategoryLabel((IMember)method, buf);
            }
            if (JavaScriptElementLabels.getFlag(flags, 256L)) {
                buf.append(CONCAT_STRING);
                if (declaringType != null) {
                    JavaScriptElementLabels.getTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, buf);
                } else {
                    JavaScriptElementLabels.getFileLabel((IMember)method, 0x40000L | flags & 0x1002000000000L, buf);
                }
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private static void getCategoryLabel(IMember member, StringBuffer buf) throws JavaScriptModelException {
        String[] categories = member.getCategories();
        if (categories.length > 0) {
            StringBuffer categoriesBuf = new StringBuffer(30);
            int i = 0;
            while (i < categories.length) {
                if (i > 0) {
                    categoriesBuf.append(CATEGORY_SEPARATOR_STRING);
                }
                categoriesBuf.append(categories[i]);
                ++i;
            }
            buf.append(CONCAT_STRING);
            buf.append(Messages.format(JavaUIMessages.JavaElementLabels_category, categoriesBuf.toString()));
        }
    }

    public static void getFieldLabel(IField field, long flags, StringBuffer buf) {
        try {
            if (JavaScriptElementLabels.getFlag(flags, 32768L) && field.exists()) {
                if (JavaScriptElementLabels.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    JavaScriptElementLabels.getTypeSignatureLabel(new BindingKey(field.getKey()).toSignature(), flags, buf);
                } else {
                    JavaScriptElementLabels.getTypeSignatureLabel(field.getTypeSignature(), flags, buf);
                }
                buf.append(' ');
            }
            IType declaringType = field.getDeclaringType();
            if (JavaScriptElementLabels.getFlag(flags, 65536L)) {
                if (declaringType != null) {
                    JavaScriptElementLabels.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
                } else {
                    JavaScriptElementLabels.getFileLabel((IMember)field, 0x40000L | flags & 0x1002000000000L, buf);
                }
                buf.append('.');
            }
            buf.append(field.getDisplayName());
            if (JavaScriptElementLabels.getFlag(flags, 16384L) && field.exists() && field.getTypeSignature() != null) {
                buf.append(DECL_STRING);
                if (JavaScriptElementLabels.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    JavaScriptElementLabels.getTypeSignatureLabel(new BindingKey(field.getKey()).toSignature(), flags, buf);
                } else {
                    JavaScriptElementLabels.getTypeSignatureLabel(field.getTypeSignature(), flags, buf);
                }
            }
            if (JavaScriptElementLabels.getFlag(flags, 0x2000000000000L) && field.exists()) {
                JavaScriptElementLabels.getCategoryLabel((IMember)field, buf);
            }
            if (JavaScriptElementLabels.getFlag(flags, 131072L)) {
                buf.append(CONCAT_STRING);
                if (declaringType != null) {
                    JavaScriptElementLabels.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
                } else {
                    JavaScriptElementLabels.getFileLabel((IMember)field, 0x40000L | flags & 0x1002000000000L, buf);
                }
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
    }

    public static void getLocalVariableLabel(ILocalVariable localVariable, long flags, StringBuffer buf) {
        if (JavaScriptElementLabels.getFlag(flags, 32768L)) {
            JavaScriptElementLabels.getTypeSignatureLabel(localVariable.getTypeSignature(), flags, buf);
            buf.append(' ');
        }
        if (JavaScriptElementLabels.getFlag(flags, 65536L)) {
            JavaScriptElementLabels.getElementLabel(localVariable.getParent(), 0x40081L | flags & 0x1002000000000L, buf);
            buf.append('.');
        }
        buf.append(localVariable.getDisplayName());
        if (JavaScriptElementLabels.getFlag(flags, 16384L)) {
            buf.append(DECL_STRING);
            JavaScriptElementLabels.getTypeSignatureLabel(localVariable.getTypeSignature(), flags, buf);
        }
        if (JavaScriptElementLabels.getFlag(flags, 131072L)) {
            buf.append(CONCAT_STRING);
            JavaScriptElementLabels.getElementLabel(localVariable.getParent(), 0x40081L | flags & 0x1002000000000L, buf);
        }
    }

    public static void getInitializerLabel(IInitializer initializer, long flags, StringBuffer buf) {
        if (JavaScriptElementLabels.getFlag(flags, 1024L)) {
            JavaScriptElementLabels.getTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, buf);
            buf.append('.');
        }
        buf.append(JavaUIMessages.JavaElementLabels_initializer);
        if (JavaScriptElementLabels.getFlag(flags, 2048L)) {
            buf.append(CONCAT_STRING);
            JavaScriptElementLabels.getTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, buf);
        }
    }

    private static void getTypeSignatureLabel(String typeSig, long flags, StringBuffer buf) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                buf.append(Signature.toString((String)typeSig));
                break;
            }
            case 4: {
                JavaScriptElementLabels.getTypeSignatureLabel(Signature.getElementType((String)typeSig), flags, buf);
                int dim = Signature.getArrayCount((String)typeSig);
                while (dim > 0) {
                    buf.append('[').append(']');
                    --dim;
                }
                break;
            }
            case 1: {
                String baseType = Signature.toString((String)typeSig);
                Util.insertTypeLabel((String)Signature.getSimpleName((String)baseType), (StringBuffer)buf);
                JavaScriptElementLabels.getTypeArgumentSignaturesLabel(new String[0], flags, buf);
            }
        }
    }

    private static void getTypeArgumentSignaturesLabel(String[] typeArgsSig, long flags, StringBuffer buf) {
        if (typeArgsSig.length > 0) {
            buf.append('<');
            int i = 0;
            while (i < typeArgsSig.length) {
                if (i > 0) {
                    buf.append(COMMA_STRING);
                }
                JavaScriptElementLabels.getTypeSignatureLabel(typeArgsSig[i], flags, buf);
                ++i;
            }
            buf.append('>');
        }
    }

    private static void getTypeParameterSignaturesLabel(String[] typeParamSigs, long flags, StringBuffer buf) {
        if (typeParamSigs.length > 0) {
            buf.append('<');
            int i = 0;
            while (i < typeParamSigs.length) {
                if (i > 0) {
                    buf.append(COMMA_STRING);
                }
                buf.append(Signature.getTypeVariable((String)typeParamSigs[i]));
                ++i;
            }
            buf.append('>');
        }
    }

    public static void getTypeLabel(IType type, long flags, StringBuffer buf) {
        String typeName;
        IPackageFragment pack;
        if (JavaScriptElementLabels.getFlag(flags, 262144L) && !(pack = type.getPackageFragment()).isDefaultPackage()) {
            JavaScriptElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, buf);
        }
        if (JavaScriptElementLabels.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                JavaScriptElementLabels.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, buf);
                buf.append('.');
            }
            if ((parentType = type.getParent().getElementType()) == 9 || parentType == 8 || parentType == 10) {
                JavaScriptElementLabels.getElementLabel(type.getParent(), 0L, buf);
                buf.append('.');
            }
        }
        if ((typeName = type.getDisplayName()).length() == 0) {
            try {
                String supertypeName = Signature.getSimpleName((String)type.getSuperclassName());
                typeName = Messages.format(JavaUIMessages.JavaElementLabels_anonym_type, supertypeName);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                typeName = JavaUIMessages.JavaElementLabels_anonym;
            }
        }
        buf.append(typeName);
        if (JavaScriptElementLabels.getFlag(flags, 0x200000L) && JavaScriptElementLabels.getFlag(flags, 0x1000000000000L) && type.isResolved()) {
            JavaScriptElementLabels.getTypeParameterSignaturesLabel(new String[0], flags, buf);
        }
        if (JavaScriptElementLabels.getFlag(flags, 0x8000000000000L) && type.exists()) {
            try {
                JavaScriptElementLabels.getCategoryLabel((IMember)type, buf);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        if (JavaScriptElementLabels.getFlag(flags, 0x100000L)) {
            buf.append(CONCAT_STRING);
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                JavaScriptElementLabels.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
                int parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8 || parentType == 10) {
                    buf.append('.');
                    JavaScriptElementLabels.getElementLabel(type.getParent(), 0L, buf);
                }
            } else {
                JavaScriptElementLabels.getPackageFragmentLabel(type.getPackageFragment(), flags & 0x1002000000000L, buf);
            }
        }
    }

    public static void getDeclarationLabel(IJavaScriptElement declaration, long flags, StringBuffer buf) {
        IJavaScriptElement openable;
        if (JavaScriptElementLabels.getFlag(flags, 0x1000000L) && (openable = (IJavaScriptElement)declaration.getOpenable()) != null) {
            buf.append(JavaScriptElementLabels.getElementLabel(openable, 0x88000000L | flags & 0x1002000000000L));
            buf.append('/');
        }
        if (declaration.getElementType() == 12) {
            buf.append(JavaUIMessages.JavaElementLabels_import_container);
        } else {
            buf.append(declaration.getDisplayName());
        }
        if (JavaScriptElementLabels.getFlag(flags, 0x2000000L) && (openable = (IJavaScriptElement)declaration.getOpenable()) != null) {
            buf.append(CONCAT_STRING);
            buf.append(JavaScriptElementLabels.getElementLabel(openable, 0x88000000L | flags & 0x1002000000000L));
        }
    }

    public static void getClassFileLabel(IClassFile classFile, long flags, StringBuffer buf) {
        IPackageFragment pack;
        if (JavaScriptElementLabels.getFlag(flags, 0x8000000L) && !(pack = (IPackageFragment)classFile.getParent()).isDefaultPackage()) {
            JavaScriptElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, buf);
            buf.append('.');
        }
        buf.append(classFile.getDisplayName());
        if (JavaScriptElementLabels.getFlag(flags, 0x10000000L)) {
            buf.append(CONCAT_STRING);
            JavaScriptElementLabels.getPackageFragmentLabel((IPackageFragment)classFile.getParent(), flags & 0x1002000000000L, buf);
        }
    }

    public static void getCompilationUnitLabel(IJavaScriptUnit cu, long flags, StringBuffer buf) {
        IPackageFragment pack;
        if (JavaScriptElementLabels.getFlag(flags, 0x80000000L) && !(pack = (IPackageFragment)cu.getParent()).isDefaultPackage()) {
            JavaScriptElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, buf);
            buf.append('.');
        }
        buf.append(cu.getDisplayName());
        if (JavaScriptElementLabels.getFlag(flags, 0x100000000L)) {
            buf.append(CONCAT_STRING);
            JavaScriptElementLabels.getPackageFragmentLabel((IPackageFragment)cu.getParent(), flags & 0x1002000000000L, buf);
        }
    }

    public static void getFileLabel(IMember member, long flags, StringBuffer buf) {
        IJavaScriptUnit compUnit = member.getJavaScriptUnit();
        if (compUnit != null) {
            JavaScriptElementLabels.getCompilationUnitLabel(compUnit, flags, buf);
        } else {
            IClassFile classFile = member.getClassFile();
            if (classFile != null) {
                JavaScriptElementLabels.getClassFileLabel(classFile, flags, buf);
            }
        }
    }

    public static void getPackageFragmentLabel(IPackageFragment pack, long flags, StringBuffer buf) {
        if (JavaScriptElementLabels.getFlag(flags, 0x800000000L)) {
            JavaScriptElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L, buf);
            buf.append('/');
        }
        JavaScriptElementLabels.refreshPackageNamePattern();
        if (pack.isDefaultPackage()) {
            buf.append(DEFAULT_PACKAGE);
        } else if (JavaScriptElementLabels.getFlag(flags, 0x2000000000L) && fgPkgNameLength >= 0) {
            String name = pack.getDisplayName();
            int start = 0;
            int dot = name.indexOf(46, start);
            while (dot > 0) {
                if (dot - start > fgPkgNameLength - 1) {
                    buf.append(fgPkgNamePrefix);
                    if (fgPkgNameChars > 0) {
                        buf.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                    }
                    buf.append(fgPkgNamePostfix);
                } else {
                    buf.append(name.substring(start, dot + 1));
                }
                start = dot + 1;
                dot = name.indexOf(46, start);
            }
            buf.append(name.substring(start));
        } else {
            buf.append(pack.getDisplayName());
        }
        if (JavaScriptElementLabels.getFlag(flags, 0x1000000000L)) {
            buf.append(CONCAT_STRING);
            JavaScriptElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L, buf);
        }
    }

    public static void getPackageFragmentRootLabel(IPackageFragmentRoot root, long flags, StringBuffer buf) {
        if (root.isArchive()) {
            JavaScriptElementLabels.getArchiveLabel(root, flags, buf);
        } else {
            JavaScriptElementLabels.getFolderLabel(root, flags, buf);
        }
    }

    private static void getArchiveLabel(IPackageFragmentRoot root, long flags, StringBuffer buf) {
        if (JavaScriptElementLabels.getFlag(flags, 0x10000000000L) && JavaScriptElementLabels.getVariableLabel(root, flags, buf)) {
            return;
        }
        boolean external = root.isExternal();
        if (external) {
            JavaScriptElementLabels.getExternalArchiveLabel(root, flags, buf);
        } else {
            JavaScriptElementLabels.getInternalArchiveLabel(root, flags, buf);
        }
    }

    private static boolean getVariableLabel(IPackageFragmentRoot root, long flags, StringBuffer buf) {
        try {
            IIncludePathEntry rawEntry = root.getRawIncludepathEntry();
            if (rawEntry != null && rawEntry.getEntryKind() == 4) {
                IPath path = rawEntry.getPath().makeRelative();
                if (JavaScriptElementLabels.getFlag(flags, 0x200000000000L)) {
                    int segements = path.segmentCount();
                    if (segements > 0) {
                        buf.append(path.segment(segements - 1));
                        if (segements > 1) {
                            buf.append(CONCAT_STRING);
                            buf.append(path.removeLastSegments(1).toOSString());
                        }
                    } else {
                        buf.append(path.toString());
                    }
                } else {
                    buf.append(path.toString());
                }
                buf.append(CONCAT_STRING);
                if (root.isExternal()) {
                    buf.append(root.getPath().toOSString());
                } else {
                    buf.append(root.getPath().makeRelative().toString());
                }
                return true;
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
        return false;
    }

    private static void getExternalArchiveLabel(IPackageFragmentRoot root, long flags, StringBuffer buf) {
        IPath path = root.getPath();
        if (JavaScriptElementLabels.getFlag(flags, 0x200000000000L)) {
            int segements = path.segmentCount();
            if (segements > 0) {
                buf.append(path.segment(segements - 1));
                if (segements > 1 || path.getDevice() != null) {
                    buf.append(CONCAT_STRING);
                    buf.append(path.removeLastSegments(1).toOSString());
                }
            } else {
                buf.append(path.toOSString());
            }
        } else {
            buf.append(path.toOSString());
        }
    }

    private static void getInternalArchiveLabel(IPackageFragmentRoot root, long flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = JavaScriptElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = JavaScriptElementLabels.getFlag(flags, 0x200000000000L) && JavaScriptElementLabels.isReferenced(root);
        if (rootQualified) {
            buf.append(root.getPath().makeRelative().toString());
        } else {
            buf.append(root.getDisplayName());
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (JavaScriptElementLabels.getFlag(flags, 0x40000000000L)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getPath().makeRelative().toString());
            }
        }
    }

    private static void getFolderLabel(IPackageFragmentRoot root, long flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = JavaScriptElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = JavaScriptElementLabels.getFlag(flags, 0x200000000000L) && JavaScriptElementLabels.isReferenced(root);
        if (rootQualified) {
            if (LIBCACHE_LOCATION.isPrefixOf(root.getPath())) {
                buf.append(root.getPath().lastSegment().toString());
            } else {
                buf.append(root.getPath().makeRelative().toString());
            }
        } else {
            if (resource != null) {
                IPath projectRelativePath = resource.getProjectRelativePath();
                if (projectRelativePath.segmentCount() == 0) {
                    buf.append(resource.getName());
                    referencedQualified = false;
                } else {
                    buf.append(projectRelativePath.toString());
                }
            } else {
                buf.append(root.getDisplayName());
            }
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getProject().getName());
            } else if (JavaScriptElementLabels.getFlag(flags, 0x40000000000L)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getDisplayName());
            }
        }
    }

    private static boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaScriptProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    private static void refreshPackageNamePattern() {
        String pattern = JavaScriptElementLabels.getPkgNamePatternForPackagesView();
        if (pattern.equals(fgPkgNamePattern)) {
            return;
        }
        if (pattern.length() == 0) {
            fgPkgNamePattern = "";
            fgPkgNameLength = -1;
            return;
        }
        fgPkgNamePattern = pattern;
        int i = 0;
        fgPkgNameChars = 0;
        fgPkgNamePrefix = "";
        fgPkgNamePostfix = "";
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (Character.isDigit(ch)) {
                fgPkgNameChars = ch - 48;
                if (i > 0) {
                    fgPkgNamePrefix = pattern.substring(0, i);
                }
                if (i >= 0) {
                    fgPkgNamePostfix = pattern.substring(i + 1);
                }
                fgPkgNameLength = fgPkgNamePrefix.length() + fgPkgNameChars + fgPkgNamePostfix.length();
                return;
            }
            ++i;
        }
        fgPkgNamePrefix = pattern;
        fgPkgNameLength = pattern.length();
    }

    private static String getPkgNamePatternForPackagesView() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (!store.getBoolean("org.eclipse.wst.jsdt.ui.compresspackagenames")) {
            return "";
        }
        return store.getString("PackagesView.pkgNamePatternForPackagesView");
    }

    public static String getContainerEntryLabel(IPath containerPath, IJavaScriptProject project) throws JavaScriptModelException {
        IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject)project);
        if (container != null) {
            return container.getDescription();
        }
        JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer((String)containerPath.segment(0));
        if (initializer != null) {
            return initializer.getDescription(containerPath, project);
        }
        return containerPath.toString();
    }
}

