/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RenameJavaElementAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RenameResourceAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RenameAction
extends SelectionDispatchAction {
    private RenameJavaElementAction fRenameJavaElement;
    private RenameResourceAction fRenameResource;

    public RenameAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.RenameAction_text);
        this.fRenameJavaElement = new RenameJavaElementAction(site);
        this.fRenameJavaElement.setText(this.getText());
        this.fRenameResource = new RenameResourceAction(site);
        this.fRenameResource.setText(this.getText());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.rename_action");
    }

    public RenameAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fRenameJavaElement = new RenameJavaElementAction(editor);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fRenameJavaElement.selectionChanged(event);
        if (this.fRenameResource != null) {
            this.fRenameResource.selectionChanged(event);
        }
        this.setEnabled(this.computeEnabledState());
    }

    public void update(ISelection selection) {
        this.fRenameJavaElement.update(selection);
        if (this.fRenameResource != null) {
            this.fRenameResource.update(selection);
        }
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (this.fRenameResource != null) {
            return this.fRenameJavaElement.isEnabled() || this.fRenameResource.isEnabled();
        }
        return this.fRenameJavaElement.isEnabled();
    }

    public void run(IStructuredSelection selection) {
        if (this.fRenameJavaElement.isEnabled()) {
            this.fRenameJavaElement.run(selection);
        }
        if (this.fRenameResource != null && this.fRenameResource.isEnabled()) {
            this.fRenameResource.run(selection);
        }
    }

    public void run(ITextSelection selection) {
        if (this.fRenameJavaElement.canRunInEditor()) {
            this.fRenameJavaElement.run(selection);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameAction_rename, (String)RefactoringMessages.RenameAction_unavailable);
        }
    }
}

