/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.DeleteServerDialog;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalDeleteAction
extends SelectionProviderAction {
    private TreeViewer viewer;

    public GlobalDeleteAction(TreeViewer viewer, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionDelete);
        this.viewer = viewer;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        IServer[] servers = this.getAcceptedServers(sel);
        if (servers != null && servers.length > 0) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(this.allSelectionAreModuleServer(sel));
    }

    private boolean allSelectionAreModuleServer(IStructuredSelection sel) {
        for (Object obj : sel) {
            if (!(obj instanceof ModuleServer)) {
                return false;
            }
            ModuleServer ms = (ModuleServer)obj;
            if (this.accept(ms)) continue;
            return false;
        }
        return true;
    }

    public boolean accept(ModuleServer ms) {
        if (ms.getServer() == null) {
            return false;
        }
        IStatus status = ms.getServer().canModifyModules(null, ms.module, null);
        return status.isOK();
    }

    public boolean accept(IServer server) {
        return !server.isReadOnly();
    }

    public void run() {
        IStructuredSelection sel = this.getStructuredSelection();
        if (!sel.isEmpty()) {
            IServer[] selAsServers = this.getAcceptedServers(sel);
            if (selAsServers != null) {
                this.deleteServers(selAsServers);
            } else {
                ArrayList<IModule> moduleList = GlobalDeleteAction.getRemovableModuleList(sel);
                if (moduleList != null) {
                    IServer s = ((ModuleServer)sel.getFirstElement()).getServer();
                    IModule[] asArray = moduleList.toArray(new IModule[moduleList.size()]);
                    new RemoveModuleAction(this.getShell(), s, asArray).run();
                }
            }
        }
    }

    private Shell getShell() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            return this.viewer.getTree().getShell();
        }
        return null;
    }

    private IFolder[] getConfigurationsFor(IServer[] serverArr) {
        ArrayList<IFolder> list = new ArrayList<IFolder>();
        int i = 0;
        while (i < serverArr.length) {
            if (serverArr[i].getServerConfiguration() != null) {
                list.add(serverArr[i].getServerConfiguration());
            }
            ++i;
        }
        IServer[] servers2 = ServerCore.getServers();
        if (servers2 != null) {
            int size2 = servers2.length;
            int j = 0;
            while (j < size2) {
                IFolder folder;
                boolean found = false;
                int i2 = 0;
                while (i2 < serverArr.length) {
                    if (serverArr[i2].equals(servers2[j])) {
                        found = true;
                    }
                    ++i2;
                }
                if (!found && (folder = servers2[j].getServerConfiguration()) != null && list.contains(folder)) {
                    list.remove(folder);
                }
                ++j;
            }
        }
        return list.toArray(new IFolder[list.size()]);
    }

    private IServer[] getAcceptedServers(IStructuredSelection sel) {
        ArrayList<IServer> l = new ArrayList<IServer>();
        Iterator i = sel.iterator();
        Object o = null;
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof IServer)) {
                return null;
            }
            if (((IServer)o).isReadOnly()) continue;
            l.add(o);
        }
        return l.toArray(new IServer[l.size()]);
    }

    public static ArrayList<IModule> getRemovableModuleList(IStructuredSelection sel) {
        Iterator i = sel.iterator();
        IServer s = null;
        Object next = null;
        ArrayList<IModule> moduleList = new ArrayList<IModule>();
        while (i.hasNext()) {
            next = i.next();
            if (!(next instanceof ModuleServer) || ((ModuleServer)next).getServer() == null) {
                return null;
            }
            if (s == null) {
                s = ((ModuleServer)next).getServer();
            } else if (!s.getId().equals(((ModuleServer)next).getServer().getId())) {
                return null;
            }
            IModule[] nextMod = ((ModuleServer)next).getModule();
            if (nextMod == null || nextMod.length != 1 || nextMod[0] == null) {
                return null;
            }
            moduleList.add(((ModuleServer)next).getModule()[0]);
        }
        return moduleList;
    }

    protected void deleteServer(IServer server) {
        this.deleteServers(new IServer[]{server});
    }

    protected void deleteServers(IServer[] servers) {
        DeleteServerDialog dsd = new DeleteServerDialog(this.getShell(), servers, this.getConfigurationsFor(servers));
        dsd.open();
    }
}

